/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.svn;

import com.trilead.ssh2.crypto.PEMDecoder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNSSHPrivateKeyUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char[] readPrivateKey(File privateKey) {
        if (!(privateKey != null && privateKey.exists() && privateKey.isFile() && privateKey.canRead())) {
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "Can not read private key from '" + privateKey + "'");
            return null;
        }
        BufferedReader reader = null;
        StringWriter buffer = new StringWriter();
        try {
            int ch;
            reader = new BufferedReader(new FileReader(privateKey));
            while ((ch = ((Reader)reader).read()) >= 0) {
                buffer.write(ch);
            }
        }
        catch (IOException e) {
            char[] cArray;
            try {
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, e);
                cArray = null;
            }
            catch (Throwable throwable) {
                SVNFileUtil.closeFile(reader);
                throw throwable;
            }
            SVNFileUtil.closeFile(reader);
            return cArray;
        }
        SVNFileUtil.closeFile(reader);
        return buffer.toString().toCharArray();
    }

    public static boolean isValidPrivateKey(char[] privateKey, String passphrase) {
        try {
            PEMDecoder.decode((char[])privateKey, (String)passphrase);
        }
        catch (IOException e) {
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, e);
            return false;
        }
        return true;
    }
}

