/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc;

import java.io.File;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.wc2.compat.SvnCodec;
import org.tmatesoft.svn.core.wc.ISVNExternalsHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.SVNBasicClient;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnCanonicalizeUrls;
import org.tmatesoft.svn.core.wc2.SvnCheckout;
import org.tmatesoft.svn.core.wc2.SvnExport;
import org.tmatesoft.svn.core.wc2.SvnRelocate;
import org.tmatesoft.svn.core.wc2.SvnSwitch;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.core.wc2.SvnUpdate;

public class SVNUpdateClient
extends SVNBasicClient {
    private ISVNExternalsHandler myExternalsHandler;
    private boolean updateLocksOnDemand;
    private boolean exportExpandsKeywords;

    public SVNUpdateClient(ISVNAuthenticationManager authManager, ISVNOptions options) {
        super(authManager, options);
        this.setExternalsHandler(null);
    }

    public SVNUpdateClient(ISVNRepositoryPool repositoryPool, ISVNOptions options) {
        super(repositoryPool, options);
        this.setExternalsHandler(null);
    }

    public void setExternalsHandler(ISVNExternalsHandler externalsHandler) {
        this.myExternalsHandler = externalsHandler;
    }

    public ISVNExternalsHandler getExternalsHandler() {
        if (this.myExternalsHandler == null) {
            return ISVNExternalsHandler.DEFAULT;
        }
        return this.myExternalsHandler;
    }

    public long doUpdate(File file, SVNRevision revision, boolean recursive) throws SVNException {
        return this.doUpdate(file, revision, SVNDepth.fromRecurse(recursive), false, false);
    }

    public long doUpdate(File file, SVNRevision revision, boolean recursive, boolean force) throws SVNException {
        return this.doUpdate(file, revision, SVNDepth.fromRecurse(recursive), force, false);
    }

    public long[] doUpdate(File[] paths, SVNRevision revision, SVNDepth depth, boolean allowUnversionedObstructions, boolean depthIsSticky) throws SVNException {
        return this.doUpdate(paths, revision, depth, allowUnversionedObstructions, depthIsSticky, false);
    }

    public long[] doUpdate(File[] paths, SVNRevision revision, SVNDepth depth, boolean allowUnversionedObstructions, boolean depthIsSticky, boolean makeParents) throws SVNException {
        if (paths == null || paths.length == 0) {
            return new long[0];
        }
        SvnUpdate up = this.getOperationsFactory().createUpdate();
        up.setUpdateLocksOnDemand(this.isUpdateLocksOnDemand());
        for (int i = 0; i < paths.length; ++i) {
            up.addTarget(SvnTarget.fromFile(paths[i]));
        }
        up.setRevision(revision);
        up.setDepth(depth);
        up.setDepthIsSticky(depthIsSticky);
        up.setAllowUnversionedObstructions(allowUnversionedObstructions);
        up.setIgnoreExternals(this.isIgnoreExternals());
        up.setMakeParents(makeParents);
        up.setExternalsHandler(SvnCodec.externalsHandler(this.getExternalsHandler()));
        return (long[])up.run();
    }

    public long doUpdate(File path, SVNRevision revision, SVNDepth depth, boolean allowUnversionedObstructions, boolean depthIsSticky) throws SVNException {
        long[] result = this.doUpdate(new File[]{path}, revision, depth, allowUnversionedObstructions, depthIsSticky);
        return result[0];
    }

    public void setUpdateLocksOnDemand(boolean locksOnDemand) {
        this.updateLocksOnDemand = locksOnDemand;
    }

    public boolean isUpdateLocksOnDemand() {
        return this.updateLocksOnDemand;
    }

    public long doSwitch(File file, SVNURL url, SVNRevision revision, boolean recursive) throws SVNException {
        return this.doSwitch(file, url, SVNRevision.UNDEFINED, revision, SVNDepth.getInfinityOrFilesDepth(recursive), false, false);
    }

    public long doSwitch(File file, SVNURL url, SVNRevision pegRevision, SVNRevision revision, boolean recursive) throws SVNException {
        return this.doSwitch(file, url, pegRevision, revision, SVNDepth.getInfinityOrFilesDepth(recursive), false, false);
    }

    public long doSwitch(File file, SVNURL url, SVNRevision pegRevision, SVNRevision revision, boolean recursive, boolean force) throws SVNException {
        return this.doSwitch(file, url, pegRevision, revision, SVNDepth.getInfinityOrFilesDepth(recursive), force, false);
    }

    public long doSwitch(File path, SVNURL url, SVNRevision pegRevision, SVNRevision revision, SVNDepth depth, boolean allowUnversionedObstructions, boolean depthIsSticky) throws SVNException {
        return this.doSwitch(path, url, pegRevision, revision, depth, allowUnversionedObstructions, depthIsSticky, true);
    }

    public long doSwitch(File path, SVNURL url, SVNRevision pegRevision, SVNRevision revision, SVNDepth depth, boolean allowUnversionedObstructions, boolean depthIsSticky, boolean ignoreAncestry) throws SVNException {
        SvnSwitch sw = this.getOperationsFactory().createSwitch();
        sw.setUpdateLocksOnDemand(this.isUpdateLocksOnDemand());
        sw.setSwitchTarget(SvnTarget.fromURL(url, pegRevision));
        sw.setSingleTarget(SvnTarget.fromFile(path));
        sw.setRevision(revision);
        sw.setDepth(depth);
        sw.setDepthIsSticky(depthIsSticky);
        sw.setAllowUnversionedObstructions(allowUnversionedObstructions);
        sw.setIgnoreAncestry(ignoreAncestry);
        sw.setIgnoreExternals(this.isIgnoreExternals());
        sw.setExternalsHandler(SvnCodec.externalsHandler(this.getExternalsHandler()));
        return (Long)sw.run();
    }

    public long doCheckout(SVNURL url, File dstPath, SVNRevision pegRevision, SVNRevision revision, boolean recursive) throws SVNException {
        return this.doCheckout(url, dstPath, pegRevision, revision, SVNDepth.fromRecurse(recursive), false);
    }

    public long doCheckout(SVNURL url, File dstPath, SVNRevision pegRevision, SVNRevision revision, boolean recursive, boolean force) throws SVNException {
        return this.doCheckout(url, dstPath, pegRevision, revision, SVNDepth.fromRecurse(recursive), force);
    }

    public long doCheckout(SVNURL url, File dstPath, SVNRevision pegRevision, SVNRevision revision, SVNDepth depth, boolean allowUnversionedObstructions) throws SVNException {
        SvnCheckout co = this.getOperationsFactory().createCheckout();
        co.setUpdateLocksOnDemand(this.isUpdateLocksOnDemand());
        co.setSource(SvnTarget.fromURL(url, pegRevision));
        co.setSingleTarget(SvnTarget.fromFile(dstPath));
        co.setRevision(revision);
        co.setDepth(depth);
        co.setAllowUnversionedObstructions(allowUnversionedObstructions);
        co.setIgnoreExternals(this.isIgnoreExternals());
        co.setExternalsHandler(SvnCodec.externalsHandler(this.getExternalsHandler()));
        return (Long)co.run();
    }

    public long doExport(SVNURL url, File dstPath, SVNRevision pegRevision, SVNRevision revision, String eolStyle, boolean force, boolean recursive) throws SVNException {
        return this.doExport(url, dstPath, pegRevision, revision, eolStyle, force, SVNDepth.fromRecurse(recursive));
    }

    public long doExport(SVNURL url, File dstPath, SVNRevision pegRevision, SVNRevision revision, String eolStyle, boolean overwrite, SVNDepth depth) throws SVNException {
        SvnExport export = this.getOperationsFactory().createExport();
        export.setUpdateLocksOnDemand(this.isUpdateLocksOnDemand());
        export.setSingleTarget(SvnTarget.fromFile(dstPath));
        export.setSource(SvnTarget.fromURL(url, pegRevision));
        export.setRevision(revision);
        export.setEolStyle(eolStyle);
        export.setForce(overwrite);
        export.setDepth(depth);
        export.setExpandKeywords(this.isExportExpandsKeywords());
        export.setIgnoreExternals(this.isIgnoreExternals());
        export.setExternalsHandler(SvnCodec.externalsHandler(this.getExternalsHandler()));
        return (Long)export.run();
    }

    public long doExport(File srcPath, File dstPath, SVNRevision pegRevision, SVNRevision revision, String eolStyle, boolean force, boolean recursive) throws SVNException {
        return this.doExport(srcPath, dstPath, pegRevision, revision, eolStyle, force, SVNDepth.fromRecurse(recursive));
    }

    public long doExport(File srcPath, File dstPath, SVNRevision pegRevision, SVNRevision revision, String eolStyle, boolean overwrite, SVNDepth depth) throws SVNException {
        SvnExport export = this.getOperationsFactory().createExport();
        export.setUpdateLocksOnDemand(this.isUpdateLocksOnDemand());
        export.setSingleTarget(SvnTarget.fromFile(dstPath));
        export.setSource(SvnTarget.fromFile(srcPath, pegRevision));
        export.setRevision(revision);
        export.setEolStyle(eolStyle);
        export.setForce(overwrite);
        export.setIgnoreExternals(this.isIgnoreExternals());
        export.setDepth(depth);
        export.setExpandKeywords(this.isExportExpandsKeywords());
        export.setExternalsHandler(SvnCodec.externalsHandler(this.getExternalsHandler()));
        return (Long)export.run();
    }

    public void doRelocate(File dst, SVNURL oldURL, SVNURL newURL, boolean recursive) throws SVNException {
        SvnRelocate relocate = this.getOperationsFactory().createRelocate();
        relocate.setSingleTarget(SvnTarget.fromFile(dst));
        relocate.setFromUrl(oldURL);
        relocate.setToUrl(newURL);
        relocate.setRecursive(recursive);
        relocate.run();
    }

    public void doCanonicalizeURLs(File dst, boolean omitDefaultPort, boolean recursive) throws SVNException {
        SvnCanonicalizeUrls cu = this.getOperationsFactory().createCanonicalizeUrls();
        cu.setSingleTarget(SvnTarget.fromFile(dst));
        cu.setDepth(recursive ? SVNDepth.INFINITY : SVNDepth.IMMEDIATES);
        cu.setOmitDefaultPort(omitDefaultPort);
        cu.setIgnoreExternals(this.isIgnoreExternals());
        cu.run();
    }

    public void setExportExpandsKeywords(boolean expand) {
        this.exportExpandsKeywords = expand;
    }

    public boolean isExportExpandsKeywords() {
        return this.exportExpandsKeywords;
    }
}

