/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc2;

import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc2.AbstractSvnCommit;
import org.tmatesoft.svn.core.wc2.ISvnCommitParameters;
import org.tmatesoft.svn.core.wc2.SvnCommitPacket;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;

public class SvnCommit
extends AbstractSvnCommit {
    private boolean keepChangelists;
    private boolean keepLocks;
    private ISvnCommitParameters commitParameters;
    private SvnCommitPacket packet;
    private boolean force;
    private boolean isFailOnMultipleRepositories;
    private boolean combinePackets;
    private SvnCommitPacket[] splitPackets;

    protected SvnCommit(SvnOperationFactory factory) {
        super(factory);
    }

    public boolean isKeepChangelists() {
        return this.keepChangelists;
    }

    public void setKeepChangelists(boolean keepChangelists) {
        this.keepChangelists = keepChangelists;
    }

    public boolean isKeepLocks() {
        return this.keepLocks;
    }

    public void setKeepLocks(boolean keepLocks) {
        this.keepLocks = keepLocks;
    }

    public ISvnCommitParameters getCommitParameters() {
        return this.commitParameters;
    }

    public void setCommitParameters(ISvnCommitParameters commitParameters) {
        this.commitParameters = commitParameters;
    }

    public SvnCommitPacket collectCommitItems() throws SVNException {
        this.ensureArgumentsAreValid();
        if (this.packet != null) {
            return this.packet;
        }
        this.packet = this.getOperationFactory().collectCommitItems(this);
        return this.packet;
    }

    public SvnCommitPacket[] splitCommitPackets(boolean combinePackets) throws SVNException {
        if (this.splitPackets != null) {
            return this.splitPackets;
        }
        this.splitPackets = this.collectCommitItems().split(combinePackets);
        return this.splitPackets;
    }

    public SVNCommitInfo run() throws SVNException {
        if (this.packet == null) {
            this.packet = this.collectCommitItems();
        }
        return (SVNCommitInfo)super.run();
    }

    protected void ensureArgumentsAreValid() throws SVNException {
        super.ensureArgumentsAreValid();
        if (this.getDepth() == SVNDepth.UNKNOWN) {
            this.setDepth(SVNDepth.INFINITY);
        }
    }

    protected int getMaximumTargetsCount() {
        return Integer.MAX_VALUE;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public boolean isForce() {
        return this.force;
    }

    public boolean isChangesWorkingCopy() {
        return true;
    }

    public void setCombinePackets(boolean combine) {
        this.combinePackets = combine;
    }

    public boolean isCombinePackets() {
        return this.combinePackets;
    }

    public boolean isFailOnMultipleRepositories() {
        return this.isFailOnMultipleRepositories;
    }

    public void setFailOnMultipleRepositories(boolean fail) {
        this.isFailOnMultipleRepositories = fail;
    }

    protected void initDefaults() {
        super.initDefaults();
        this.setCombinePackets(true);
    }
}

