#ifndef LOGGER_H
#define LOGGER_H
#include <QFile>
#include <QTextStream>
#include <QMutex>
#include <QDateTime>
#include <memory>

class Logger
{
public:
    Logger(QString  appDir, QString logFileName);
    ~Logger();
    void writeString(QString strToWrite);
    void writeBytes(QByteArray arrToWrite);
private:
    std::unique_ptr<QFile> myLogFile;
    std::unique_ptr<QTextStream> logStream;
    QMutex mutex; //mutex for control writes to the logs
};

#endif // LOGGER_H
