#ifndef UTIL_H
#define UTIL_H

#include <QtGlobal> // for debug macros
#ifdef QT_DEBUG
    #include <QDebug>
#endif
#include <QString>
#include <QMessageBox>
#include <QFileDialog>
#include <QListView>
#include <QTreeView>
#include <QDesktopServices>
#include <QUrl>
#include <QCoreApplication>
#include <QDesktopWidget>
#include <QSettings>
#include <QXmlStreamReader>
#include <memory>

/**
  Utilities functions (global)
  **/
namespace Util{
QString normalizePath(QString path);
QString cutName(QString path);
QString cutNameWithoutBackSlash(QString path);
QString insertQuotes(const QString &currString);
QString normalizeAndQuote(QString path);
QString fullTrim(QString str);
QString normalizeDecimalSeparator(QString value);

inline const char* qStrToCstr(const QString &currentString){
    return currentString.toUtf8().constData();
}

inline const char* boolToCstr(bool currentBoolean){
    return currentBoolean ? "true" : "false";
}

QStringList multipleDirDialog(QString title);
QStringList substring(QString myString,QString separator,Qt::CaseSensitivity cs = Qt::CaseSensitive);
int indexOfBackward(QString myString, QString toSearch, int from = -1);
bool showQuestionPopUp(QWidget * parent, QString message, QMessageBox::StandardButton standardButton=QMessageBox::NoButton);
bool checkEmptySpaces(QStringList toCheck);
bool checkIfIntegers(QStringList toCheck);
bool checkIfDoubles(QStringList toCheck);
bool isStringInteger(QString myString);
bool isStringDouble(QString myString);
bool copyDir(const QString &fromPath, QString toPath, const bool isRecursive = false);
bool rmDir(const QString &dirPath);
QRect getScreenResolution();
void showPopUp(const QString &message);
void showRichPopUp(const QString &message);
void showWarningPopUp(const QString &message);
void showErrorPopUp(const QString &message);
void showRichErrorPopUp(const QString &message);
}
#endif // UTIL_H
