#include "bgimagewizard.h"

BGImageWizard::BGImageWizard(const QString &appDir, const QString &workspaceWizardLocation, QSettings *vagoSettings, Logger *myLogger)
{
    this->appDir = appDir;
    this->workspaceWizardLocation=workspaceWizardLocation;
    this->vagoSettings=vagoSettings;
    this->myLogger=myLogger;
    this->bgImagesLocation=this->workspaceWizardLocation+"/BGImages";
}

int BGImageWizard::exec(){

    QPushButton *restartButton = new QPushButton("Restart");
    this->myWizard.setButton(QWizard::CustomButton1,restartButton);
    this->myWizard.setOption(QWizard::HaveCustomButton1, true);

    connect(&this->myWizard, SIGNAL(currentIdChanged(int)), this, SLOT(pageChanged(int)));
    connect(restartButton, SIGNAL(clicked(bool)), this, SLOT(restartWizard()));

    this->myWizard.setWindowIcon(QIcon(":/new/icons/background_image.png"));

    //Center and resize QWizard (http://www.thedazzlersinc.com/source/2012/06/04/qt-center-window-in-screen/)
#ifdef Q_OS_WIN
    this->myWizard.resize(640,480);
#else
    this->myWizard.resize(800,600); // Mac OS pcs should be able to render this resolution without any problem. It's also better
    // because the components on mac use more space
#endif
    QRect position = this->myWizard.frameGeometry();
    position.moveCenter(QDesktopWidget().availableGeometry().center());
    this->myWizard.move(position.topLeft());
    //

    BGImagePage2 *page2 = new BGImagePage2(this->myLogger);
    BGImagePage3 *page3 = new BGImagePage3();
    BGImagePageFinal *pageFinal = new BGImagePageFinal(this->appDir, this->myLogger, this->bgImagesLocation);

    this->myWizard.addPage(createIntroPage());
    this->myWizard.addPage(page2);
    this->myWizard.addPage(page3);
    this->myWizard.addPage(pageFinal);

    this->myWizard.setWindowTitle("Background Image Wizard");

    if(this->myWizard.exec()){ //modal and wait for finalization

    }

    return 0;
}

QWizardPage* BGImageWizard::createIntroPage() {
    QWizardPage *page = new QWizardPage;
    page->setTitle("Introduction");

    QLabel *label = new QLabel("Welcome to the Oni Background Image Wizard.\n"
                               "This wizard will allow you to create in a few and simple steps Oni background images (TXMB) "
                               "that can be used in the menus or as backgrounds screens for the levels.");
    label->setWordWrap(true);

    QVBoxLayout *layout = new QVBoxLayout;
    layout->addWidget(label);
    page->setLayout(layout);

    return page;
}

void BGImageWizard::restartWizard(){
    this->myWizard.restart();
}

void BGImageWizard::pageChanged(int pageId){
    // Last page?
    if(pageId==3){
       this->myWizard.setOption(QWizard::HaveCustomButton1, true); // set visible
       this->myWizard.button(QWizard::BackButton)->setEnabled(false); // disable back button, use restart if needed
        return;
    }
   this->myWizard.setOption(QWizard::HaveCustomButton1, false); // set invisible
   this->myWizard.button(QWizard::BackButton)->setEnabled(true); // set enable back button
}
