#ifndef BGIMAGEWIZARD_H
#define BGIMAGEWIZARD_H

// System includes
#include <QString>
#include <QWizard>
#include <QWizardPage>
#include <QLabel>
#include <QDesktopWidget>
#include <QVBoxLayout>
#include <QPushButton>

// Local includes
#include "bgimagepage2.h"
#include "bgimagepage3.h"
#include "bgimagepagefinal.h"

class BGImageWizard: public QObject // for signals and slots
{
    Q_OBJECT // for signals and slots
public:
    BGImageWizard(const QString &appDir, const QString &workspaceWizardLocation, QSettings *vagoSettings, Logger *myLogger);
    int exec();
private:
    QWizard myWizard;
    QWizardPage *createIntroPage();

    Logger *myLogger;
    QString workspaceWizardLocation;
    QString bgImagesLocation;
    QString appDir;
    QSettings *vagoSettings;
private slots:
    void restartWizard();
    void pageChanged(int pageId);
};

#endif // BGIMAGEWIZARD_H
