#include "soundpage5.h"
#include "ui_soundpage5.h"

SoundPage5::SoundPage5(QWidget *parent) :
    QWizardPage(parent),
    ui(new Ui::soundpage5)
{
    ui->setupUi(this);

    //Register fields to be accessible in another pages
    registerField("rbPriorityLowImp", ui->rbPriorityLow);
    registerField("rbPriorityNormalImp", ui->rbPriorityNormal);
    registerField("rbPriorityHighImp", ui->rbPriorityHigh);
    registerField("rbPriorityHighestImp", ui->rbPriorityHighest);

    registerField("leMinVolumeDistanceImp", ui->leMinVolumeDistance);
    registerField("leMaxVolumeDistanceImp", ui->leMaxVolumeDistance);
    registerField("leMinAngleImp", ui->leMinAngle);
    registerField("leMaxAngleImp", ui->leMaxAngle);
    registerField("leMinAttenuationImp", ui->leMinAttenuation);
    registerField("leImpactVelocityImp", ui->leImpactVelocity);
    registerField("leMinOcclusionImp", ui->leMinOcclusion);
}

bool SoundPage5::validatePage(){
    QStringList leContents;
    leContents << ui->leMinVolumeDistance->text() << ui->leMaxVolumeDistance->text() <<
                  ui->leMinAngle->text() << ui->leMaxAngle->text() << ui->leMinAttenuation->text() <<
                  ui->leImpactVelocity->text() << ui->leMinOcclusion->text();

    if(Util::checkEmptySpaces(leContents)){
        Util::showErrorPopUp("Please fill all fields first!");
        return false;
    }

    if(Util::checkIfDoubles(leContents)){
        Util::showErrorPopUp("All fields must contains numbers!");
        return false;
    }

    return true;
}

SoundPage5::~SoundPage5()
{
    delete ui;
}
