#include "DropLineEdit.h"

DropLineEdit::DropLineEdit(QWidget *parent) : QLineEdit(parent)
{
    //setDragDropMode(QAbstractItemView::DropOnly);
    setAcceptDrops(true);
}

void DropLineEdit::dragEnterEvent(QDragEnterEvent *event) {

    const QMimeData* mimeData = event->mimeData();

    // We only accept if our widget is enabled and it is only one file
    if(
            !this->isEnabled() ||
            mimeData->urls().size() != 1 ||
            // checks if it is a file (folders are ignored)
            QDir(mimeData->urls().at(0).toLocalFile()).exists()
    )
    {
        event->ignore();
    }
    else{
        event->acceptProposedAction();
    }
}

void DropLineEdit::dragMoveEvent(QDragMoveEvent *event) {
    event->acceptProposedAction();
}

void DropLineEdit::dropEvent(QDropEvent *event) {

    const QMimeData* mimeData = event->mimeData();

    event->acceptProposedAction();

    QStringList pathList = QStringList();

    if (mimeData->hasUrls())
    {
        this->setText(mimeData->urls().at(0).toLocalFile());
    }

}

void DropLineEdit::dragLeaveEvent(QDragLeaveEvent *event) {
    event->accept();
}
