#ifndef WMFORMATPAGE_H
#define WMFORMATPAGE_H

#include <QWizardPage>
#include <QColorDialog>
#include <QKeyEvent>
#include <QTextBlock>

#include "utilvago.h"
#include "WmPage.h"
#include "wmsetuppage.h"

namespace Ui {
class WmFormatPage;
}

class WmFormatPage : public QWizardPage
{
    Q_OBJECT
    
public:
    explicit WmFormatPage(Logger *myLogger, QWidget *parent = 0);
    QList<std::shared_ptr<WmPage> >& getCurrentPages();

    ~WmFormatPage();
    
private slots:
    bool validatePage();

    void on_tbBold_clicked();

    void on_pbAddPageAfter_clicked();

    void on_pbAddPageBefore_clicked();

    void on_pbDeleteCurrentPage_clicked();

    void on_tbItalic_clicked();

    void on_tbFontColor_clicked();

    void on_fcbFont_currentFontChanged(const QFont &f);

    void on_cbTextSize_currentTextChanged(const QString &arg1);

private:
    enum class FormatType{
        BOLD,
        ITALIC,
        COLOR,
        FONT_TYPE,
        FONT_SIZE
    };

    Ui::WmFormatPage *ui;
    QList<std::shared_ptr<WmPage>> currentPages;
    bool windowsIsInitialized = false;
    Logger *myLogger;

private:
    void setupComboBoxTextSize();
    void addPage(bool afterCurrentPage = true);
    void updateTabNames(int startIndex);
    void setCurrentFormatting(int index);
    void setDefaultOniFont(int index);
    void formatText(FormatType desiredFormatType);
    void initializePage();
    void keyPressEvent (QKeyEvent * event);
};

#endif // WMFORMATPAGE_H
