#include "preferences.h"
#include "ui_preferences.h"

Preferences::Preferences(QWidget *parent, QSettings *vagoSettings) :
    QDialog(parent),
    ui(new Ui::Preferences)
{
    ui->setupUi(this);
    this->setAttribute(Qt::WA_DeleteOnClose,true ); //destroy itself once finished.

    this->vagoSettings=vagoSettings;

    ui->leAEfolder->setText(this->vagoSettings->value("AeFolder").toString());
    ui->leWorkspace->setText(this->vagoSettings->value("Workspace").toString());
    ui->leWidth->setText(this->vagoSettings->value("WindowWidth").toString());
    ui->leHeight->setText(this->vagoSettings->value("WindowHeight").toString());
    ui->cbOniWindow->setChecked(this->vagoSettings->value("OniWindow").toBool());
    ui->cbSeparate->setChecked(this->vagoSettings->value("SeparateInWorkspace").toBool());
    ui->cbAskSaveProject->setChecked(this->vagoSettings->value("AskSaveProject").toBool());
    ui->cbAskOpenLastProject->setChecked(this->vagoSettings->value("AskToOpenLastProject").toBool());
#ifdef Q_OS_MAC
    ui->cbUseYesAsDefaultWhenRemovingItems->setChecked(this->vagoSettings->value("useYesAsDefaultWhenRemovingItems").toBool());
#endif

#ifdef Q_OS_WIN
    ui->cbUseYesAsDefaultWhenRemovingItems->hide(); // don't display this mac os only option in windows
#endif

}

Preferences::~Preferences()
{
    delete ui;
}

// Need to override to do the verification
// http://stackoverflow.com/questions/3261676/how-to-make-qdialogbuttonbox-not-close-its-parent-qdialog
void Preferences::accept (){
    QStringList options;
    QRect screenRes = Util::getScreenResolution();

    options << ui->leAEfolder->text() << ui->leWorkspace->text() << ui->leWidth->text() << ui->leHeight->text();

    if(Util::checkEmptySpaces(options)){
        Util::showErrorPopUp("Setting not saved! There are empty settings.");
        return;
    }

    if(Util::checkIfIntegers(QStringList() << ui->leWidth->text() << ui->leHeight->text() )){
        Util::showErrorPopUp("Setting not saved! Width and Height must be numbers.");
        return;
    }

    if(ui->leWidth->text().toInt() > screenRes.width() || ui->leHeight->text().toInt() > screenRes.height()){
        Util::showErrorPopUp("Setting not saved! Width or Height specified are greater than actual screen resolution.");
        return;
    }

    if(ui->leWidth->text().toInt() <= 0  || ui->leHeight->text().toInt() <= 0 ){
        Util::showErrorPopUp("Settings not saved! Width and Height must be greater than 0.");
        return;
    }

    this->vagoSettings->setValue("AeFolder",ui->leAEfolder->text());
    this->vagoSettings->setValue("Workspace",ui->leWorkspace->text());
    this->vagoSettings->setValue("WindowWidth",ui->leWidth->text());
    this->vagoSettings->setValue("WindowHeight",ui->leHeight->text());
    this->vagoSettings->setValue("OniWindow",ui->cbOniWindow->isChecked());
    this->vagoSettings->setValue("SeparateInWorkspace",ui->cbSeparate->isChecked());
    this->vagoSettings->setValue("AskSaveProject",ui->cbAskSaveProject->isChecked());
    this->vagoSettings->setValue("AskToOpenLastProject",ui->cbAskOpenLastProject->isChecked());
#ifdef Q_OS_MAC
    this->vagoSettings->setValue("useYesAsDefaultWhenRemovingItems",ui->cbUseYesAsDefaultWhenRemovingItems->isChecked());
#endif

    Util::showPopUp("You need to restart the application to all changes take effect.");

    QDialog::accept();
}

void Preferences::on_pbChooseWorkspace_clicked()
{
    QString newDir=QFileDialog::getExistingDirectory(this,"Choose workspace folder...");
    newDir=Util::normalizePath(newDir);

    if(!newDir.isEmpty()){
        ui->leWorkspace->setText(newDir);
    }
}

void Preferences::on_pbChooseAE_clicked()
{
    QString newDir=QFileDialog::getExistingDirectory(this,"Choose AE folder...");
    newDir=Util::normalizePath(newDir);

    if(!newDir.isEmpty()){
        ui->leAEfolder->setText(newDir);
    }
}

void Preferences::on_buttonBox_rejected()
{
    this->destroy(true,true);
}

