#include "soundpage3.h"
#include "ui_soundpage3.h"

SoundPage3::SoundPage3(QWidget *parent) :
    QWizardPage(parent),
    ui(new Ui::soundpage3)
{
    ui->setupUi(this);

    //Register fields to be accessible in another pages

    registerField("rbPriorityLow", ui->rbPriorityLow);
    registerField("rbPriorityNormal", ui->rbPriorityNormal);
    registerField("rbPriorityHigh", ui->rbPriorityHigh);
    registerField("rbPriorityHighest", ui->rbPriorityHighest);
    registerField("cbInterruptOnStop", ui->cbInterruptOnStop);

    registerField("cbPlayOnce", ui->cbPlayOnce);
    registerField("cbCanPan", ui->cbCanPan);

    registerField("leSphereRadious", ui->leSphereRadious);
    registerField("leMinElapsedTime", ui->leMinElapsedTime);
    registerField("leMaxElapsedTime", ui->leMaxElapsedTime);
    registerField("leMinVolumeDistance", ui->leMinVolumeDistance);
    registerField("leMaxVolumeDistance", ui->leMaxVolumeDistance);
    registerField("leMinOcclusion", ui->leMinOcclusion);
    registerField("leTreshold", ui->leTreshold);
}

bool SoundPage3::validatePage(){
    QStringList leContents;
    leContents << ui->leSphereRadious->text() << ui->leMinElapsedTime->text() << ui->leMaxElapsedTime->text()
                       << ui->leMinVolumeDistance->text() << ui->leMaxVolumeDistance->text() << ui->leMinOcclusion->text()
                       << ui->leTreshold->text();

    if(Util::checkEmptySpaces(leContents)){
        Util::showErrorPopUp("Please fill all fields first!");
        return false;
    }

    if(Util::checkIfDoubles(leContents)){
        Util::showErrorPopUp("All fields must contains numbers!");
        return false;
    }

    return true;
}

SoundPage3::~SoundPage3()
{
    delete ui;
}
