#ifndef ABSTRACTWIZARD_H
#define ABSTRACTWIZARD_H

#include <QLabel>
#include <QVBoxLayout>
#include <QLineEdit>
#include <QRect>
#include <QDesktopWidget>
#include <QTextStream>
#include <QSettings>
#include <QWizard>
#include <QIcon>
#include <QPushButton>

// This abstract class allow us to re-use most of the code used in wizards.
// To create wizard use the WizardFactory class available in "wizardfactory.h"
class AbstractWizard: public QObject // for signals and slots
{
    Q_OBJECT // for signals and slots
protected:
	QWizard myWizard;
    QString workspaceWizardLocation;
	QSettings *vagoSettings;
    QString appDir;
protected:
    AbstractWizard(const QString &appDir, const QString &workspaceWizardLocation, QSettings *vagoSettings, const bool hasRestartButton);
    virtual void exec()=0;
	void showWizard(const QString &windowsTitle, const QString &windowsIcon);
    QWizardPage* createIntroPage(const QString &text);
    virtual void beforeClose(QDialog::DialogCode resultStatus)=0;
protected slots:
    void wizardFinished(int resultStatus);
private:
    bool hasRestartButton;
private slots:
    void pageChanged(int pageId);
    void restartWizard();
};

#endif // ABSTRACTWIZARD_H
