#ifndef CONVERTER_H
#define CONVERTER_H
#include <QProcess>
#include <QProgressBar>
#include <QThread>
#ifdef Q_OS_WIN
#include <QWinTaskbarProgress>
#endif

#include "utilvago.h"

class Converter : public QThread
{
     Q_OBJECT
public:
    Converter(QString AppDir, QStringList *myData);

    #ifdef Q_OS_WIN
    Converter(QString AppDir, QStringList *myData, QWinTaskbarProgress *win7TaskBarProgress);
    #endif
private:
    QString AppDir;
    QStringList *myData;
    std::unique_ptr<QProcess> myProcess;
    #ifdef Q_OS_WIN
    QWinTaskbarProgress *win7TaskBarProgress = nullptr;
    #endif

protected:
    void run(); //for thread
private slots:
    void terminateCurrProcess();
signals:
    void setupPB(int numberTasks);
    void taskDone();
    void resultConversion(QString result, int numErrors);
    void conversionAborted();
};



#endif // CONVERTER_H
