/*
#     ___  _ _      ___
#    |    | | |    |
# ___|    |   | ___|    PS2DEV Open Source Project.
#----------------------------------------------------------
# Copyright (c) 2001 Fabrice Bellard.
# Copyright (c) 2002-2004 Michael Niedermayer <michaelni@gmx.at>
#               2005 Adopted for SMS by Eugene Plotnikov
# Licensed (like the original ffmpeg source code) under the terms of the
# GNU Lesser General Public License as published by the Free Software Foundation;
# either version 2 of the License, or (at your option) any later version.
#
*/
#include "SMS_MSMPEG4.h"
#include "SMS_MPEG4.h"
#include "SMS_VLC.h"
#include "SMS_H263.h"
#include "SMS_VideoBuffer.h"
#include "SMS_DMA.h"
#include "SMS_DXSB.h"

#include <malloc.h>
#include <stdlib.h>
#include <string.h>

#define MYCTX()   (  ( SMS_Codec_MSMPEG4Context* )apCtx -> m_pCodec -> m_pCtx  )
#define BASECTX() g_MPEGCtx

#define NB_RL_TABLES   6
#define DC_MAX       119

#define DEFAULT_INTER_INDEX    3
#define DC_VLC_BITS            9
#define MV_VLC_BITS            9
#define CBPY_VLC_BITS          6
#define V2_INTRA_CBPC_VLC_BITS 3
#define V2_MB_TYPE_VLC_BITS    7
#define V2_MV_VLC_BITS         9
#define MB_INTRA_VLC_BITS      9
#define MB_NON_INTRA_VLC_BITS  9
#define V1_INTRA_CBPC_VLC_BITS 6
#define V1_INTER_CBPC_VLC_BITS 6
#define INTER_INTRA_VLC_BITS   3
#define TEX_VLC_BITS           9

typedef struct MVTable {

 int             m_N;
 const uint16_t* m_pTblMVCode;
 const uint8_t*  m_pTblMVBits;
 const uint8_t*  m_pTblMVX;
 const uint8_t*  m_pTblMVY;
 uint16_t*       m_pTblMVIdx;
 SMS_VLC         m_VLC;

} MVTable;

extern const uint8_t  g_DCtab_lum  [  13 ][ 2 ] SMS_DATA_SECTION;
extern const uint8_t  g_DCtab_chrom[  13 ][ 2 ] SMS_DATA_SECTION;
extern const uint16_t g_intra_vlc  [ 103 ][ 2 ] SMS_DATA_SECTION;
extern const int8_t   g_intra_run  [ 102 ]      SMS_DATA_SECTION;
extern const int8_t   g_intra_level[ 102 ]      SMS_DATA_SECTION;
extern const uint16_t g_inter_vlc  [ 103 ][ 2 ] SMS_DATA_SECTION;
extern const int8_t   g_inter_run  [ 102 ]      SMS_DATA_SECTION;
extern const int8_t   g_inter_level[ 102 ]      SMS_DATA_SECTION;
extern const uint8_t  g_cbpy_tab   [  16 ][ 2 ] SMS_DATA_SECTION;
extern const uint8_t  g_mvtab      [  33 ][ 2 ] SMS_DATA_SECTION;

extern const uint8_t g_IntraMCBPC_bits    [  9 ] SMS_DATA_SECTION;
extern const uint8_t g_IntraMCBPC_code    [  9 ] SMS_DATA_SECTION;
extern const uint8_t g_InterMCBPC_bits    [ 28 ] SMS_DATA_SECTION;
extern const uint8_t g_InterMCBPC_code    [ 28 ] SMS_DATA_SECTION;
extern const uint8_t g_chroma_qscale_table[ 32 ] SMS_DATA_SECTION;

static int s_Init;

static uint8_t s_y_dc_scale_table[ 32 ] = {
  0,  8,  8,  8,  8, 10, 12, 14, 16, 17, 18, 19, 20, 21, 22, 23,
 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39
};
static uint8_t s_c_dc_scale_table[ 32 ] = {
  0,  8,  8,  8,  8,  9,  9, 10, 10, 11, 11, 12, 12, 13, 13, 14,
 14, 15, 15, 16, 16, 17, 17, 18, 18, 19, 19, 20, 20, 21, 21, 22
};
static const uint16_t s_table0_vlc[ 133 ][ 2 ] SMS_DATA_SECTION = {
 { 0x001,  2 }, { 0x006,  3 }, { 0x00F,  4 }, { 0x016,  5 },
 { 0x020,  6 }, { 0x018,  7 }, { 0x008,  8 }, { 0x09A,  8 },
 { 0x056,  9 }, { 0x13E,  9 }, { 0x0F0, 10 }, { 0x3A5, 10 },
 { 0x077, 11 }, { 0x1EF, 11 }, { 0x09A, 12 }, { 0x05D, 13 },
 { 0x001,  4 }, { 0x011,  5 }, { 0x002,  7 }, { 0x00B,  8 },
 { 0x012,  9 }, { 0x1D6,  9 }, { 0x27E, 10 }, { 0x191, 11 },
 { 0x0EA, 12 }, { 0x3DC, 12 }, { 0x13B, 13 }, { 0x004,  5 },
 { 0x014,  7 }, { 0x09E,  8 }, { 0x009, 10 }, { 0x1AC, 11 },
 { 0x1E2, 11 }, { 0x3CA, 12 }, { 0x05F, 13 }, { 0x017,  5 },
 { 0x04E,  7 }, { 0x05E,  9 }, { 0x0F3, 10 }, { 0x1AD, 11 },
 { 0x0EC, 12 }, { 0x5F0, 13 }, { 0x00E,  6 }, { 0x0E1,  8 },
 { 0x3A4, 10 }, { 0x09C, 12 }, { 0x13D, 13 }, { 0x03B,  6 },
 { 0x01C,  9 }, { 0x014, 11 }, { 0x9BE, 12 }, { 0x006,  7 },
 { 0x07A,  9 }, { 0x190, 11 }, { 0x137, 13 }, { 0x01B,  7 },
 { 0x008, 10 }, { 0x75C, 11 }, { 0x071,  7 }, { 0x0D7, 10 },
 { 0x9BF, 12 }, { 0x007,  8 }, { 0x0AF, 10 }, { 0x4CC, 11 },
 { 0x034,  8 }, { 0x265, 10 }, { 0x09F, 12 }, { 0x0E0,  8 },
 { 0x016, 11 }, { 0x327, 12 }, { 0x015,  9 }, { 0x17D, 11 },
 { 0xEBB, 12 }, { 0x014,  9 }, { 0x0F6, 10 }, { 0x1E4, 11 },
 { 0x0CB, 10 }, { 0x99D, 12 }, { 0x0CA, 10 }, { 0x2FC, 12 },
 { 0x17F, 11 }, { 0x4CD, 11 }, { 0x2FD, 12 }, { 0x4FE, 11 },
 { 0x13A, 13 }, { 0x00A,  4 }, { 0x042,  7 }, { 0x1D3,  9 },
 { 0x4DD, 11 }, { 0x012,  5 }, { 0x0E8,  8 }, { 0x04C, 11 },
 { 0x136, 13 }, { 0x039,  6 }, { 0x264, 10 }, { 0xEBA, 12 },
 { 0x000,  7 }, { 0x0AE, 10 }, { 0x99C, 12 }, { 0x01F,  7 },
 { 0x4DE, 11 }, { 0x043,  7 }, { 0x4DC, 11 }, { 0x003,  8 },
 { 0x3CB, 12 }, { 0x006,  8 }, { 0x99E, 12 }, { 0x02A,  8 },
 { 0x5F1, 13 }, { 0x00F,  8 }, { 0x9FE, 12 }, { 0x033,  8 },
 { 0x9FF, 12 }, { 0x098,  8 }, { 0x99F, 12 }, { 0x0EA,  8 },
 { 0x13C, 13 }, { 0x02E,  8 }, { 0x192, 11 }, { 0x136,  9 },
 { 0x06A,  9 }, { 0x015, 11 }, { 0x3AF, 10 }, { 0x1E3, 11 },
 { 0x074, 11 }, { 0x0EB, 12 }, { 0x2F9, 12 }, { 0x05C, 13 },
 { 0x0ED, 12 }, { 0x3DD, 12 }, { 0x326, 12 }, { 0x05E, 13 },
 { 0x016,  7 }
};
static const int8_t s_table0_run[ 132 ] SMS_DATA_SECTION = {
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  2,  2,  2,  2,  2,
  2,  2,  2,  3,  3,  3,  3,  3,  3,  3,  4,  4,  4,  4,  4,  5,
  5,  5,  5,  6,  6,  6,  6,  7,  7,  7,  8,  8,  8,  9,  9,  9,
 10, 10, 10, 11, 11, 11, 12, 12, 12, 13, 13, 13, 14, 14, 15, 15,
 16, 17, 18, 19, 20,  0,  0,  0,  0,  1,  1,  1,  1,  2,  2,  2,
  3,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,  8,  8,  9,  9, 10,
 10, 11, 11, 12, 12, 13, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22,
 23, 24, 25, 26
};
static const int8_t s_table0_level[ 132 ] SMS_DATA_SECTION = {
  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, 16,
  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11,  1,  2,  3,  4,  5,
  6,  7,  8,  1,  2,  3,  4,  5,  6,  7,  1,  2,  3,  4,  5,  1,
  2,  3,  4,  1,  2,  3,  4,  1,  2,  3,  1,  2,  3,  1,  2,  3,
  1,  2,  3,  1,  2,  3,  1,  2,  3,  1,  2,  3,  1,  2,  1,  2,
  1,  1,  1,  1,  1,  1,  2,  3,  4,  1,  2,  3,  4,  1,  2,  3,
  1,  2,  3,  1,  2,  1,  2,  1,  2,  1,  2,  1,  2,  1,  2,  1,
  2,  1,  2,  1,  2,  1,  2,  1,  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,
};
static const uint16_t s_table1_vlc[ 149 ][ 2 ] SMS_DATA_SECTION = {
 { 0x0004,  3 }, { 0x0014,  5 }, { 0x0017,  7 }, { 0x007F,  8 },
 { 0x0154,  9 }, { 0x01F2, 10 }, { 0x00BF, 11 }, { 0x0065, 12 },
 { 0x0AAA, 12 }, { 0x0630, 13 }, { 0x1597, 13 }, { 0x03B7, 14 },
 { 0x2B22, 14 }, { 0x0BE6, 15 }, { 0x000B,  4 }, { 0x0037,  7 },
 { 0x0062,  9 }, { 0x0007, 11 }, { 0x0166, 12 }, { 0x00CE, 13 },
 { 0x1590, 13 }, { 0x05F6, 14 }, { 0x0BE7, 15 }, { 0x0007,  5 },
 { 0x006D,  8 }, { 0x0003, 11 }, { 0x031F, 12 }, { 0x05F2, 14 },
 { 0x0002,  6 }, { 0x0061,  9 }, { 0x0055, 12 }, { 0x01DF, 14 },
 { 0x001A,  6 }, { 0x001E, 10 }, { 0x0AC9, 12 }, { 0x2B23, 14 },
 { 0x001E,  6 }, { 0x001F, 10 }, { 0x0AC3, 12 }, { 0x2B2B, 14 },
 { 0x0006,  7 }, { 0x0004, 11 }, { 0x02F8, 13 }, { 0x0019,  7 },
 { 0x0006, 11 }, { 0x063D, 13 }, { 0x0057,  7 }, { 0x0182, 11 },
 { 0x2AA2, 14 }, { 0x0004,  8 }, { 0x0180, 11 }, { 0x059C, 14 },
 { 0x007D,  8 }, { 0x0164, 12 }, { 0x076D, 15 }, { 0x0002,  9 },
 { 0x018D, 11 }, { 0x1581, 13 }, { 0x00AD,  8 }, { 0x0060, 12 },
 { 0x0C67, 14 }, { 0x001C,  9 }, { 0x00EE, 13 }, { 0x0003,  9 },
 { 0x02CF, 13 }, { 0x00D9,  9 }, { 0x1580, 13 }, { 0x0002, 11 },
 { 0x0183, 11 }, { 0x0057, 12 }, { 0x0061, 12 }, { 0x0031, 11 },
 { 0x0066, 12 }, { 0x0631, 13 }, { 0x0632, 13 }, { 0x00AC, 13 },
 { 0x031D, 12 }, { 0x0076, 12 }, { 0x003A, 11 }, { 0x0165, 12 },
 { 0x0C66, 14 }, { 0x0003,  2 }, { 0x0054,  7 }, { 0x02AB, 10 },
 { 0x0016, 13 }, { 0x05F7, 14 }, { 0x0005,  4 }, { 0x00F8,  9 },
 { 0x0AA9, 12 }, { 0x005F, 15 }, { 0x0004,  4 }, { 0x001C, 10 },
 { 0x1550, 13 }, { 0x0004,  5 }, { 0x0077, 11 }, { 0x076C, 15 },
 { 0x000E,  5 }, { 0x000A, 12 }, { 0x000C,  5 }, { 0x0562, 11 },
 { 0x0004,  6 }, { 0x031C, 12 }, { 0x0006,  6 }, { 0x00C8, 13 },
 { 0x000D,  6 }, { 0x01DA, 13 }, { 0x0007,  6 }, { 0x00C9, 13 },
 { 0x0001,  7 }, { 0x002E, 14 }, { 0x0014,  7 }, { 0x1596, 13 },
 { 0x000A,  7 }, { 0x0AC2, 12 }, { 0x0016,  7 }, { 0x015B, 14 },
 { 0x0015,  7 }, { 0x015A, 14 }, { 0x000F,  8 }, { 0x005E, 15 },
 { 0x007E,  8 }, { 0x00AB,  8 }, { 0x002D,  9 }, { 0x00D8,  9 },
 { 0x000B,  9 }, { 0x0014, 10 }, { 0x02B3, 10 }, { 0x01F3, 10 },
 { 0x003A, 10 }, { 0x0000, 10 }, { 0x0058, 10 }, { 0x002E,  9 },
 { 0x005E, 10 }, { 0x0563, 11 }, { 0x00EC, 12 }, { 0x0054, 12 },
 { 0x0AC1, 12 }, { 0x1556, 13 }, { 0x02FA, 13 }, { 0x0181, 11 },
 { 0x1557, 13 }, { 0x059D, 14 }, { 0x2AA3, 14 }, { 0x2B2A, 14 },
 { 0x01DE, 14 }, { 0x063C, 13 }, { 0x00CF, 13 }, { 0x1594, 13 },
 { 0x000D,  9 }
};
static const int8_t s_table1_run[ 148 ] SMS_DATA_SECTION = {
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  2,  2,  2,  2,  2,  3,  3,  3,  3,
  4,  4,  4,  4,  5,  5,  5,  5,  6,  6,  6,  7,  7,  7,  8,  8,
  8,  9,  9,  9, 10, 10, 10, 11, 11, 11, 12, 12, 12, 13, 13, 14,
 14, 15, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28,
 29,  0,  0,  0,  0,  0,  1,  1,  1,  1,  2,  2,  2,  3,  3,  3,
  4,  4,  5,  5,  6,  6,  7,  7,  8,  8,  9,  9, 10, 10, 11, 11,
 12, 12, 13, 13, 14, 14, 15, 15, 16, 17, 18, 19, 20, 21, 22, 23,
 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39,
 40, 41, 42, 43
};
static const int8_t s_table1_level[ 148 ] SMS_DATA_SECTION = {
  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14,  1,  2,
  3,  4,  5,  6,  7,  8,  9,  1,  2,  3,  4,  5,  1,  2,  3,  4,
  1,  2,  3,  4,  1,  2,  3,  4,  1,  2,  3,  1,  2,  3,  1,  2,
  3,  1,  2,  3,  1,  2,  3,  1,  2,  3,  1,  2,  3,  1,  2,  1,
  2,  1,  2,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  2,  3,  4,  5,  1,  2,  3,  4,  1,  2,  3,  1,  2,  3,
  1,  2,  1,  2,  1,  2,  1,  2,  1,  2,  1,  2,  1,  2,  1,  2,
  1,  2,  1,  2,  1,  2,  1,  2,  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1
};
static const uint16_t s_table2_vlc[ 186 ][ 2 ] SMS_DATA_SECTION = {
 { 0x0001,  2 }, { 0x0005,  3 }, { 0x000D,  4 }, { 0x0012,  5 },
 { 0x000E,  6 }, { 0x0015,  7 }, { 0x0013,  8 }, { 0x003F,  8 },
 { 0x004B,  9 }, { 0x011F,  9 }, { 0x00B8, 10 }, { 0x03E3, 10 },
 { 0x0172, 11 }, { 0x024D, 12 }, { 0x03DA, 12 }, { 0x02DD, 13 },
 { 0x1F55, 13 }, { 0x05B9, 14 }, { 0x3EAE, 14 }, { 0x0000,  4 },
 { 0x0010,  5 }, { 0x0008,  7 }, { 0x0020,  8 }, { 0x0029,  9 },
 { 0x01F4,  9 }, { 0x0233, 10 }, { 0x01E0, 11 }, { 0x012A, 12 },
 { 0x03DD, 12 }, { 0x050A, 13 }, { 0x1F29, 13 }, { 0x0A42, 14 },
 { 0x1272, 15 }, { 0x1737, 15 }, { 0x0003,  5 }, { 0x0011,  7 },
 { 0x00C4,  8 }, { 0x004B, 10 }, { 0x00B4, 11 }, { 0x07D4, 11 },
 { 0x0345, 12 }, { 0x02D7, 13 }, { 0x07BF, 13 }, { 0x0938, 14 },
 { 0x0BBB, 14 }, { 0x095E, 15 }, { 0x0013,  5 }, { 0x0078,  7 },
 { 0x0069,  9 }, { 0x0232, 10 }, { 0x0461, 11 }, { 0x03EC, 12 },
 { 0x0520, 13 }, { 0x1F2A, 13 }, { 0x3E50, 14 }, { 0x3E51, 14 },
 { 0x1486, 15 }, { 0x000C,  6 }, { 0x0024,  9 }, { 0x0094, 11 },
 { 0x08C0, 12 }, { 0x0F09, 14 }, { 0x1EF0, 15 }, { 0x003D,  6 },
 { 0x0053,  9 }, { 0x01A0, 11 }, { 0x02D6, 13 }, { 0x0F08, 14 },
 { 0x0013,  7 }, { 0x007C,  9 }, { 0x07C1, 11 }, { 0x04AC, 14 },
 { 0x001B,  7 }, { 0x00A0, 10 }, { 0x0344, 12 }, { 0x0F79, 14 },
 { 0x0079,  7 }, { 0x03E1, 10 }, { 0x02D4, 13 }, { 0x2306, 14 },
 { 0x0021,  8 }, { 0x023C, 10 }, { 0x0FAE, 12 }, { 0x23DE, 14 },
 { 0x0035,  8 }, { 0x0175, 11 }, { 0x07B3, 13 }, { 0x00C5,  8 },
 { 0x0174, 11 }, { 0x0785, 13 }, { 0x0048,  9 }, { 0x01A3, 11 },
 { 0x049E, 13 }, { 0x002C,  9 }, { 0x00FA, 10 }, { 0x07D6, 11 },
 { 0x0092, 10 }, { 0x05CC, 13 }, { 0x1EF1, 15 }, { 0x00A3, 10 },
 { 0x03ED, 12 }, { 0x093E, 14 }, { 0x01E2, 11 }, { 0x1273, 15 },
 { 0x07C4, 11 }, { 0x1487, 15 }, { 0x0291, 12 }, { 0x0293, 12 },
 { 0x0F8A, 12 }, { 0x0509, 13 }, { 0x0508, 13 }, { 0x078D, 13 },
 { 0x07BE, 13 }, { 0x078C, 13 }, { 0x04AE, 14 }, { 0x0BBA, 14 },
 { 0x2307, 14 }, { 0x0B9A, 14 }, { 0x1736, 15 }, { 0x000E,  4 },
 { 0x0045,  7 }, { 0x01F3,  9 }, { 0x047A, 11 }, { 0x05DC, 13 },
 { 0x23DF, 14 }, { 0x0019,  5 }, { 0x0028,  9 }, { 0x0176, 11 },
 { 0x049D, 13 }, { 0x23DD, 14 }, { 0x0030,  6 }, { 0x00A2, 10 },
 { 0x02EF, 12 }, { 0x05B8, 14 }, { 0x003F,  6 }, { 0x00A5, 10 },
 { 0x03DB, 12 }, { 0x093F, 14 }, { 0x0044,  7 }, { 0x07CB, 11 },
 { 0x095F, 15 }, { 0x0063,  7 }, { 0x03C3, 12 }, { 0x0015,  8 },
 { 0x08F6, 12 }, { 0x0017,  8 }, { 0x0498, 13 }, { 0x002C,  8 },
 { 0x07B2, 13 }, { 0x002F,  8 }, { 0x1F54, 13 }, { 0x008D,  8 },
 { 0x07BD, 13 }, { 0x008E,  8 }, { 0x1182, 13 }, { 0x00FB,  8 },
 { 0x050B, 13 }, { 0x002D,  8 }, { 0x07C0, 11 }, { 0x0079,  9 },
 { 0x1F5F, 13 }, { 0x007A,  9 }, { 0x1F56, 13 }, { 0x0231, 10 },
 { 0x03E4, 10 }, { 0x01A1, 11 }, { 0x0143, 11 }, { 0x01F7, 11 },
 { 0x016F, 12 }, { 0x0292, 12 }, { 0x02E7, 12 }, { 0x016C, 12 },
 { 0x016D, 12 }, { 0x03DC, 12 }, { 0x0F8B, 12 }, { 0x0499, 13 },
 { 0x03D8, 12 }, { 0x078E, 13 }, { 0x02D5, 13 }, { 0x1F5E, 13 },
 { 0x1F2B, 13 }, { 0x078F, 13 }, { 0x04AD, 14 }, { 0x3EAF, 14 },
 { 0x23DC, 14 }, { 0x004A,  9 }
};
static const int8_t s_table2_run[ 185 ] SMS_DATA_SECTION = {
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  3,  3,
  3,  3,  3,  3,  3,  3,  3,  3,  3,  4,  4,  4,  4,  4,  4,  5,
  5,  5,  5,  5,  6,  6,  6,  6,  7,  7,  7,  7,  8,  8,  8,  8,
  9,  9,  9,  9, 10, 10, 10, 11, 11, 11, 12, 12, 12, 13, 13, 13,
 14, 14, 14, 15, 15, 15, 16, 16, 17, 17, 18, 19, 20, 21, 22, 23,
 24, 25, 26, 27, 28, 29, 30,  0,  0,  0,  0,  0,  0,  1,  1,  1,
  1,  1,  2,  2,  2,  2,  3,  3,  3,  3,  4,  4,  4,  5,  5,  6,
  6,  7,  7,  8,  8,  9,  9, 10, 10, 11, 11, 12, 12, 13, 13, 14,
 14, 15, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28,
 29, 30, 31, 32, 33, 34, 35, 36, 37
};
static const int8_t s_table2_level[ 185 ] SMS_DATA_SECTION = {
  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, 16,
 17, 18, 19,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13,
 14, 15,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12,  1,  2,
  3,  4,  5,  6,  7,  8,  9, 10, 11,  1,  2,  3,  4,  5,  6,  1,
  2,  3,  4,  5,  1,  2,  3,  4,  1,  2,  3,  4,  1,  2,  3,  4,
  1,  2,  3,  4,  1,  2,  3,  1,  2,  3,  1,  2,  3,  1,  2,  3,
  1,  2,  3,  1,  2,  3,  1,  2,  1,  2,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,  2,  3,  4,  5,  6,  1,  2,  3,
  4,  5,  1,  2,  3,  4,  1,  2,  3,  4,  1,  2,  3,  1,  2,  1,
  2,  1,  2,  1,  2,  1,  2,  1,  2,  1,  2,  1,  2,  1,  2,  1,
  2,  1,  2,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,  1
};
static const uint16_t s_table4_vlc[ 169 ][ 2 ] SMS_DATA_SECTION = {
 { 0x0000,  3 }, { 0x0003,  4 }, { 0x000B,  5 }, { 0x0014,  6 },
 { 0x003F,  6 }, { 0x005D,  7 }, { 0x00A2,  8 }, { 0x00AC,  9 },
 { 0x016E,  9 }, { 0x020A, 10 }, { 0x02E2, 10 }, { 0x0432, 11 },
 { 0x05C9, 11 }, { 0x0827, 12 }, { 0x0B54, 12 }, { 0x04E6, 13 },
 { 0x105F, 13 }, { 0x172A, 13 }, { 0x20B2, 14 }, { 0x2D4E, 14 },
 { 0x39F0, 14 }, { 0x4175, 15 }, { 0x5A9E, 15 }, { 0x0004,  4 },
 { 0x001E,  5 }, { 0x0042,  7 }, { 0x00B6,  8 }, { 0x0173,  9 },
 { 0x0395, 10 }, { 0x072E, 11 }, { 0x0B94, 12 }, { 0x16A4, 13 },
 { 0x20B3, 14 }, { 0x2E45, 14 }, { 0x0005,  5 }, { 0x0040,  7 },
 { 0x0049,  9 }, { 0x028F, 10 }, { 0x05CB, 11 }, { 0x048A, 13 },
 { 0x09DD, 14 }, { 0x73E2, 15 }, { 0x0018,  5 }, { 0x0025,  8 },
 { 0x008A, 10 }, { 0x051B, 11 }, { 0x0E5F, 12 }, { 0x09C9, 14 },
 { 0x139C, 15 }, { 0x0029,  6 }, { 0x004F,  9 }, { 0x0412, 11 },
 { 0x048D, 13 }, { 0x2E41, 14 }, { 0x0038,  6 }, { 0x010E,  9 },
 { 0x05A8, 11 }, { 0x105C, 13 }, { 0x39F2, 14 }, { 0x0058,  7 },
 { 0x021F, 10 }, { 0x0E7E, 12 }, { 0x39FF, 14 }, { 0x0023,  8 },
 { 0x02E3, 10 }, { 0x04E5, 13 }, { 0x2E40, 14 }, { 0x00A1,  8 },
 { 0x05BE, 11 }, { 0x09C8, 14 }, { 0x0083,  8 }, { 0x013A, 11 },
 { 0x1721, 13 }, { 0x0044,  9 }, { 0x0276, 12 }, { 0x39F6, 14 },
 { 0x008B, 10 }, { 0x04EF, 13 }, { 0x5A9B, 15 }, { 0x0208, 10 },
 { 0x1CFE, 13 }, { 0x0399, 10 }, { 0x1CB4, 13 }, { 0x039E, 10 },
 { 0x39F3, 14 }, { 0x05AB, 11 }, { 0x73E3, 15 }, { 0x0737, 11 },
 { 0x5A9F, 15 }, { 0x082D, 12 }, { 0x0E69, 12 }, { 0x0E68, 12 },
 { 0x0433, 11 }, { 0x0B7B, 12 }, { 0x2DF8, 14 }, { 0x2E56, 14 },
 { 0x2E57, 14 }, { 0x39F7, 14 }, { 0x51A5, 15 }, { 0x0003,  3 },
 { 0x002A,  6 }, { 0x00E4,  8 }, { 0x028E, 10 }, { 0x0735, 11 },
 { 0x1058, 13 }, { 0x1CFA, 13 }, { 0x2DF9, 14 }, { 0x4174, 15 },
 { 0x0009,  4 }, { 0x0054,  8 }, { 0x0398, 10 }, { 0x048B, 13 },
 { 0x139D, 15 }, { 0x000D,  4 }, { 0x00AD,  9 }, { 0x0826, 12 },
 { 0x2D4C, 14 }, { 0x0011,  5 }, { 0x016B,  9 }, { 0x0B7F, 12 },
 { 0x51A4, 15 }, { 0x0019,  5 }, { 0x021B, 10 }, { 0x16FD, 13 },
 { 0x001D,  5 }, { 0x0394, 10 }, { 0x28D3, 14 }, { 0x002B,  6 },
 { 0x05BC, 11 }, { 0x5A9A, 15 }, { 0x002F,  6 }, { 0x0247, 12 },
 { 0x0010,  7 }, { 0x0A35, 12 }, { 0x003E,  6 }, { 0x0B7A, 12 },
 { 0x0059,  7 }, { 0x105E, 13 }, { 0x0026,  8 }, { 0x09CF, 14 },
 { 0x0055,  8 }, { 0x1CB5, 13 }, { 0x0057,  8 }, { 0x0E5B, 12 },
 { 0x00A0,  8 }, { 0x1468, 13 }, { 0x0170,  9 }, { 0x0090, 10 },
 { 0x01CE,  9 }, { 0x021A, 10 }, { 0x0218, 10 }, { 0x0168,  9 },
 { 0x021E, 10 }, { 0x0244, 12 }, { 0x0736, 11 }, { 0x0138, 11 },
 { 0x0519, 11 }, { 0x0E5E, 12 }, { 0x072C, 11 }, { 0x0B55, 12 },
 { 0x09DC, 14 }, { 0x20BB, 14 }, { 0x048C, 13 }, { 0x1723, 13 },
 { 0x2E44, 14 }, { 0x16A5, 13 }, { 0x0518, 11 }, { 0x39FE, 14 },
 { 0x0169,  9 }
};
static const int8_t s_table4_run[ 168 ] SMS_DATA_SECTION = {
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  1,  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  2,  2,  2,  2,  2,  2,  2,  2,  3,  3,  3,  3,  3,  3,
  3,  4,  4,  4,  4,  4,  5,  5,  5,  5,  5,  6,  6,  6,  6,  7,
  7,  7,  7,  8,  8,  8,  9,  9,  9, 10, 10, 10, 11, 11, 11, 12,
 12, 13, 13, 14, 14, 15, 15, 16, 16, 17, 18, 19, 20, 21, 22, 23,
 24, 25, 26,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  1,  1,  1,
  1,  2,  2,  2,  2,  3,  3,  3,  3,  4,  4,  4,  5,  5,  5,  6,
  6,  6,  7,  7,  8,  8,  9,  9, 10, 10, 11, 11, 12, 12, 13, 13,
 14, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28,
 29, 30, 31, 32, 33, 34, 35, 36
};
static const int8_t s_table4_level[ 168 ] SMS_DATA_SECTION = {
  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, 16,
 17, 18, 19, 20, 21, 22, 23,  1,  2,  3,  4,  5,  6,  7,  8,  9,
 10, 11,  1,  2,  3,  4,  5,  6,  7,  8,  1,  2,  3,  4,  5,  6,
  7,  1,  2,  3,  4,  5,  1,  2,  3,  4,  5,  1,  2,  3,  4,  1,
  2,  3,  4,  1,  2,  3,  1,  2,  3,  1,  2,  3,  1,  2,  3,  1,
  2,  1,  2,  1,  2,  1,  2,  1,  2,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  2,  3,  4,  5,  6,  7,  8,  9,  1,  2,  3,  4,
  5,  1,  2,  3,  4,  1,  2,  3,  4,  1,  2,  3,  1,  2,  3,  1,
  2,  3,  1,  2,  1,  2,  1,  2,  1,  2,  1,  2,  1,  2,  1,  2,
  1,  2,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1
};
static SMS_RLTable s_rl_table[ NB_RL_TABLES ] = {
 { 132,  85, s_table0_vlc, s_table0_run, s_table0_level },
 { 185, 119, s_table2_vlc, s_table2_run, s_table2_level },
 { 102,  67,  g_intra_vlc,  g_intra_run,  g_intra_level },
 { 148,  81, s_table1_vlc, s_table1_run, s_table1_level },
 { 168,  99, s_table4_vlc, s_table4_run, s_table4_level },
 { 102,  58, g_inter_vlc,   g_inter_run,  g_inter_level }
};
static const uint16_t s_table0_mv_code[ 1100 ] SMS_DATA_SECTION = {
 0x0001, 0x0003, 0x0005, 0x0007, 0x0003, 0x0008, 0x000C, 0x0001,
 0x0002, 0x001B, 0x0006, 0x000B, 0x0015, 0x0002, 0x000E, 0x000F,
 0x0014, 0x0020, 0x0022, 0x0025, 0x0027, 0x0029, 0x002D, 0x004B,
 0x004D, 0x0003, 0x0022, 0x0023, 0x0025, 0x0027, 0x0042, 0x0048,
 0x0049, 0x0050, 0x005C, 0x0091, 0x009F, 0x000E, 0x0043, 0x004C,
 0x0054, 0x0056, 0x008C, 0x0098, 0x009A, 0x009B, 0x00B1, 0x00B2,
 0x0120, 0x0121, 0x0126, 0x0133, 0x0139, 0x01A1, 0x01A4, 0x01A5,
 0x01A6, 0x01A7, 0x01AE, 0x01AF, 0x000B, 0x0019, 0x0085, 0x0090,
 0x009B, 0x00AA, 0x00AF, 0x010C, 0x010E, 0x011C, 0x011E, 0x0133,
 0x0144, 0x0160, 0x0174, 0x0175, 0x0177, 0x0178, 0x0249, 0x024B,
 0x0252, 0x0261, 0x0265, 0x0270, 0x0352, 0x0353, 0x0355, 0x0359,
 0x0010, 0x0011, 0x0013, 0x0034, 0x0035, 0x0036, 0x0037, 0x003D,
 0x003E, 0x0109, 0x0126, 0x0156, 0x021A, 0x021E, 0x023A, 0x023E,
 0x028E, 0x028F, 0x02CF, 0x0491, 0x0494, 0x049F, 0x04A0, 0x04A3,
 0x04A6, 0x04A7, 0x04AD, 0x04AE, 0x04C0, 0x04C4, 0x04C6, 0x04C8,
 0x04C9, 0x04F5, 0x04F6, 0x04F7, 0x0680, 0x0682, 0x0683, 0x0688,
 0x0689, 0x068D, 0x068E, 0x068F, 0x06A2, 0x06A3, 0x06A9, 0x06B0,
 0x06B1, 0x06B4, 0x06B5, 0x0024, 0x0060, 0x0063, 0x0078, 0x0079,
 0x0211, 0x0244, 0x0245, 0x0247, 0x0248, 0x0249, 0x024A, 0x024B,
 0x026B, 0x02AF, 0x02B8, 0x02BB, 0x0436, 0x0476, 0x0477, 0x047E,
 0x04C8, 0x04C9, 0x04CA, 0x0514, 0x0586, 0x0587, 0x0598, 0x059D,
 0x05D9, 0x05DA, 0x0920, 0x0921, 0x093B, 0x093C, 0x093D, 0x0942,
 0x0943, 0x0944, 0x0945, 0x0959, 0x095E, 0x095F, 0x0982, 0x0983,
 0x098E, 0x098F, 0x09C4, 0x09E7, 0x09E8, 0x09E9, 0x0D02, 0x0D17,
 0x0D18, 0x0D19, 0x0D41, 0x0D42, 0x0D43, 0x0D50, 0x0D5F, 0x0D6D,
 0x0D6E, 0x0D6F, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
 0x00C2, 0x00C3, 0x00C4, 0x00C5, 0x041E, 0x041F, 0x0420, 0x0421,
 0x048C, 0x048D, 0x04D3, 0x04D4, 0x04D5, 0x055C, 0x055D, 0x0572,
 0x0573, 0x0574, 0x0575, 0x08DE, 0x08DF, 0x08FE, 0x08FF, 0x0996,
 0x0A36, 0x0A37, 0x0B08, 0x0B09, 0x0B0A, 0x0B0B, 0x0B32, 0x0B33,
 0x0B34, 0x0B35, 0x0B36, 0x0B37, 0x0B38, 0x0B39, 0x0BB0, 0x0BF7,
 0x0BF8, 0x0BF9, 0x0BFA, 0x0BFB, 0x0BFC, 0x0BFD, 0x0BFE, 0x0BFF,
 0x1254, 0x1255, 0x1256, 0x1257, 0x1270, 0x1271, 0x1272, 0x1273,
 0x1274, 0x1275, 0x12AB, 0x12AC, 0x12AD, 0x12AE, 0x12AF, 0x12B0,
 0x12B1, 0x1315, 0x1316, 0x1317, 0x13BF, 0x13C0, 0x13C1, 0x13C2,
 0x13C3, 0x13C4, 0x13C5, 0x13C6, 0x13C7, 0x13C8, 0x13C9, 0x13CA,
 0x13CB, 0x13CC, 0x13CD, 0x1A06, 0x1A07, 0x1A28, 0x1A29, 0x1A2A,
 0x1A2B, 0x1A2C, 0x1A2D, 0x1A80, 0x1ABB, 0x1ABC, 0x1ABD, 0x1AD8,
 0x1AD9, 0x0094, 0x0095, 0x0096, 0x0097, 0x00A0, 0x00A1, 0x00A2,
 0x00A3, 0x0831, 0x0832, 0x0833, 0x0834, 0x0835, 0x0836, 0x0837,
 0x0838, 0x0839, 0x083A, 0x083B, 0x0939, 0x093A, 0x093B, 0x093C,
 0x093D, 0x093E, 0x093F, 0x09A0, 0x09A1, 0x09A2, 0x09A3, 0x09A4,
 0x09A5, 0x11AC, 0x11AD, 0x11AE, 0x11AF, 0x11B0, 0x11B1, 0x11B2,
 0x11B3, 0x11B4, 0x11B5, 0x11B6, 0x11B7, 0x11B8, 0x11B9, 0x11BA,
 0x11BB, 0x132F, 0x1454, 0x1455, 0x1456, 0x1457, 0x1458, 0x1459,
 0x145A, 0x145B, 0x145C, 0x145D, 0x145E, 0x145F, 0x1460, 0x1461,
 0x1462, 0x1463, 0x1464, 0x1465, 0x1466, 0x1467, 0x1468, 0x1469,
 0x146A, 0x146B, 0x17DE, 0x17DF, 0x17E0, 0x17E1, 0x17E2, 0x17E3,
 0x17E4, 0x17E5, 0x17E6, 0x17E7, 0x17E8, 0x17E9, 0x17EA, 0x17EB,
 0x17EC, 0x17ED, 0x2540, 0x2541, 0x2542, 0x2543, 0x2544, 0x2545,
 0x2546, 0x2547, 0x2548, 0x2549, 0x254A, 0x254B, 0x254C, 0x254D,
 0x254E, 0x254F, 0x2550, 0x2551, 0x2552, 0x2553, 0x2554, 0x2555,
 0x2628, 0x2766, 0x2767, 0x2768, 0x2769, 0x276A, 0x276B, 0x276C,
 0x276D, 0x276E, 0x276F, 0x2770, 0x2771, 0x2772, 0x2773, 0x2774,
 0x2775, 0x2776, 0x2777, 0x2778, 0x2779, 0x277A, 0x277B, 0x277C,
 0x277D, 0x3503, 0x3544, 0x3545, 0x3546, 0x3547, 0x3560, 0x3561,
 0x3562, 0x3563, 0x3564, 0x3565, 0x3566, 0x3567, 0x3568, 0x3569,
 0x356A, 0x356B, 0x356C, 0x356D, 0x356E, 0x356F, 0x3570, 0x3571,
 0x3572, 0x3573, 0x3574, 0x3575, 0x03F0, 0x103D, 0x103E, 0x103F,
 0x1040, 0x1041, 0x1042, 0x1043, 0x1044, 0x1045, 0x1046, 0x1047,
 0x1048, 0x1049, 0x104A, 0x104B, 0x104C, 0x104D, 0x104E, 0x104F,
 0x1050, 0x1051, 0x1052, 0x1053, 0x1054, 0x1055, 0x1056, 0x1057,
 0x1058, 0x1059, 0x105A, 0x105B, 0x105C, 0x105D, 0x105E, 0x105F,
 0x1060, 0x1061, 0x1270, 0x1271, 0x21B8, 0x21B9, 0x21BA, 0x21BB,
 0x21BC, 0x21BD, 0x21BE, 0x21BF, 0x21F0, 0x21F1, 0x21F2, 0x21F3,
 0x21F4, 0x21F5, 0x21F6, 0x21F7, 0x21F8, 0x21F9, 0x21FA, 0x21FB,
 0x21FC, 0x21FD, 0x21FE, 0x21FF, 0x2340, 0x2341, 0x2342, 0x2343,
 0x2344, 0x2345, 0x2346, 0x2347, 0x2348, 0x2349, 0x234A, 0x234B,
 0x234C, 0x234D, 0x234E, 0x234F, 0x2350, 0x2351, 0x2352, 0x2353,
 0x2354, 0x2355, 0x2356, 0x2357, 0x265C, 0x2F88, 0x2F89, 0x2F8A,
 0x2F8B, 0x2F8C, 0x2F8D, 0x2F8E, 0x2F8F, 0x2F90, 0x2F91, 0x2F92,
 0x2F93, 0x2F94, 0x2F95, 0x2F96, 0x2F97, 0x2F98, 0x2F99, 0x2F9A,
 0x2F9B, 0x2F9C, 0x2F9D, 0x2F9E, 0x2F9F, 0x2FA0, 0x2FA1, 0x2FA2,
 0x2FA3, 0x2FA4, 0x2FA5, 0x2FA6, 0x2FA7, 0x2FA8, 0x2FA9, 0x2FAA,
 0x2FAB, 0x2FAC, 0x2FAD, 0x2FAE, 0x2FAF, 0x2FB0, 0x2FB1, 0x2FB2,
 0x2FB3, 0x2FB4, 0x2FB5, 0x2FB6, 0x2FB7, 0x2FB8, 0x2FB9, 0x2FBA,
 0x2FBB, 0x4C52, 0x4C53, 0x4E28, 0x4E29, 0x4E2A, 0x4E2B, 0x4E2C,
 0x4E2D, 0x4E2E, 0x4E2F, 0x4E30, 0x4E31, 0x4E32, 0x4E33, 0x4E34,
 0x4E35, 0x4E36, 0x4E37, 0x4E38, 0x4E39, 0x4E3A, 0x4E3B, 0x4E3C,
 0x4E3D, 0x4E3E, 0x4E3F, 0x4E80, 0x4E81, 0x4E82, 0x4E83, 0x4E84,
 0x4E85, 0x4E86, 0x4E87, 0x4E88, 0x4E89, 0x4E8A, 0x4E8B, 0x4E8C,
 0x4E8D, 0x4E8E, 0x4E8F, 0x4E90, 0x4E91, 0x4E92, 0x4E93, 0x4E94,
 0x4E95, 0x4E96, 0x4E97, 0x4E98, 0x4E99, 0x4E9A, 0x4E9B, 0x4E9C,
 0x4E9D, 0x4E9E, 0x4E9F, 0x4EA0, 0x4EA1, 0x4EA2, 0x4EA3, 0x4EA4,
 0x4EA5, 0x4EA6, 0x4EA7, 0x4EA8, 0x4EA9, 0x4EAA, 0x4EAB, 0x4EAC,
 0x4EAD, 0x4EAE, 0x4EAF, 0x4EB0, 0x4EB1, 0x4EB2, 0x4EB3, 0x4EB4,
 0x4EB5, 0x4EB6, 0x4EB7, 0x4EB8, 0x4EB9, 0x4EBA, 0x4EBB, 0x4EBC,
 0x4EBD, 0x4EBE, 0x4EBF, 0x4EC0, 0x4EC1, 0x4EC2, 0x4EC3, 0x4EC4,
 0x4EC5, 0x4EC6, 0x4EC7, 0x4EC8, 0x4EC9, 0x4ECA, 0x4ECB, 0x6A04,
 0x6A05, 0x07E2, 0x07E3, 0x07E4, 0x07E5, 0x07E6, 0x07E7, 0x07E8,
 0x07E9, 0x07EA, 0x07EB, 0x07EC, 0x07ED, 0x07EE, 0x07EF, 0x07F0,
 0x07F1, 0x07F2, 0x07F3, 0x07F4, 0x07F5, 0x07F6, 0x07F7, 0x07F8,
 0x07F9, 0x07FA, 0x07FB, 0x07FC, 0x07FD, 0x07FE, 0x07FF, 0x2000,
 0x2001, 0x2002, 0x2003, 0x2004, 0x2005, 0x2006, 0x2007, 0x2008,
 0x2009, 0x200A, 0x200B, 0x200C, 0x200D, 0x200E, 0x200F, 0x2010,
 0x2011, 0x2012, 0x2013, 0x2014, 0x2015, 0x2016, 0x2017, 0x2018,
 0x2019, 0x201A, 0x201B, 0x201C, 0x201D, 0x201E, 0x201F, 0x2020,
 0x2021, 0x2022, 0x2023, 0x2024, 0x2025, 0x2026, 0x2027, 0x2028,
 0x2029, 0x202A, 0x202B, 0x202C, 0x202D, 0x202E, 0x202F, 0x2030,
 0x2031, 0x2032, 0x2033, 0x2034, 0x2035, 0x2036, 0x2037, 0x2038,
 0x2039, 0x203A, 0x203B, 0x203C, 0x203D, 0x203E, 0x203F, 0x2040,
 0x2041, 0x2042, 0x2043, 0x2044, 0x2045, 0x2046, 0x2047, 0x2048,
 0x2049, 0x204A, 0x204B, 0x204C, 0x204D, 0x204E, 0x204F, 0x2050,
 0x2051, 0x2052, 0x2053, 0x2054, 0x2055, 0x2056, 0x2057, 0x2058,
 0x2059, 0x205A, 0x205B, 0x205C, 0x205D, 0x205E, 0x205F, 0x2060,
 0x2061, 0x2062, 0x2063, 0x2064, 0x2065, 0x2066, 0x2067, 0x2068,
 0x2069, 0x206A, 0x206B, 0x206C, 0x206D, 0x206E, 0x206F, 0x2070,
 0x2071, 0x2072, 0x2073, 0x2074, 0x2075, 0x2076, 0x2077, 0x2078,
 0x2079, 0x4CBA, 0x4CBB, 0x5D88, 0x5D89, 0x5D8A, 0x5D8B, 0x5D8C,
 0x5D8D, 0x5D8E, 0x5D8F, 0x5DB0, 0x5DB1, 0x5DB2, 0x5DB3, 0x5DB4,
 0x5DB5, 0x5DB6, 0x5DB7, 0x5DB8, 0x5DB9, 0x5DBA, 0x5DBB, 0x5DBC,
 0x5DBD, 0x5DBE, 0x5DBF, 0x5E40, 0x5E41, 0x5E42, 0x5E43, 0x5E44,
 0x5E45, 0x5E46, 0x5E47, 0x5E48, 0x5E49, 0x5E4A, 0x5E4B, 0x5E4C,
 0x5E4D, 0x5E4E, 0x5E4F, 0x5E50, 0x5E51, 0x5E52, 0x5E53, 0x5E54,
 0x5E55, 0x5E56, 0x5E57, 0x5E58, 0x5E59, 0x5E5A, 0x5E5B, 0x5E5C,
 0x5E5D, 0x5E5E, 0x5E5F, 0x5E60, 0x5E61, 0x5E62, 0x5E63, 0x5E64,
 0x5E65, 0x5E66, 0x5E67, 0x5E68, 0x5E69, 0x5E6A, 0x5E6B, 0x5E6C,
 0x5E6D, 0x5E6E, 0x5E6F, 0x5E70, 0x5E71, 0x5E72, 0x5E73, 0x5E74,
 0x5E75, 0x5E76, 0x5E77, 0x5E78, 0x5E79, 0x5E7A, 0x5E7B, 0x5E7C,
 0x5E7D, 0x5E7E, 0x5E7F, 0x5E80, 0x5E81, 0x5E82, 0x5E83, 0x5E84,
 0x5E85, 0x5E86, 0x5E87, 0x5E88, 0x5E89, 0x5E8A, 0x5E8B, 0x5E8C,
 0x5E8D, 0x5E8E, 0x5E8F, 0x5E90, 0x5E91, 0x5E92, 0x5E93, 0x5E94,
 0x5E95, 0x5E96, 0x5E97, 0x5E98, 0x5E99, 0x5E9A, 0x5E9B, 0x5E9C,
 0x5E9D, 0x5E9E, 0x5E9F, 0x5EA0, 0x5EA1, 0x5EA2, 0x5EA3, 0x5EA4,
 0x5EA5, 0x5EA6, 0x5EA7, 0x5EA8, 0x5EA9, 0x5EAA, 0x5EAB, 0x5EAC,
 0x5EAD, 0x5EAE, 0x5EAF, 0x5EB0, 0x5EB1, 0x5EB2, 0x5EB3, 0x5EB4,
 0x5EB5, 0x5EB6, 0x5EB7, 0x5EB8, 0x5EB9, 0x5EBA, 0x5EBB, 0x5EBC,
 0x5EBD, 0x5EBE, 0x5EBF, 0x5EC0, 0x5EC1, 0x5EC2, 0x5EC3, 0x5EC4,
 0x5EC5, 0x5EC6, 0x5EC7, 0x5EC8, 0x5EC9, 0x5ECA, 0x5ECB, 0x5ECC,
 0x5ECD, 0x5ECE, 0x5ECF, 0x5ED0, 0x5ED1, 0x5ED2, 0x5ED3, 0x5ED4,
 0x5ED5, 0x5ED6, 0x5ED7, 0x5ED8, 0x5ED9, 0x5EDA, 0x5EDB, 0x5EDC,
 0x5EDD, 0x5EDE, 0x5EDF, 0x5EE0, 0x5EE1, 0x5EE2, 0x5EE3, 0x5EE4,
 0x5EE5, 0x5EE6, 0x5EE7, 0x5EE8, 0x5EE9, 0x5EEA, 0x5EEB, 0x5EEC,
 0x5EED, 0x5EEE, 0x5EEF, 0x5EF0, 0x5EF1, 0x5EF2, 0x5EF3, 0x5EF4,
 0x5EF5, 0x5EF6, 0x5EF7, 0x5EF8, 0x5EF9, 0x5EFA, 0x5EFB, 0x5EFC,
 0x5EFD, 0x5EFE, 0x5EFF, 0x5F00, 0x5F01, 0x5F02, 0x5F03, 0x5F04,
 0x5F05, 0x5F06, 0x5F07, 0x5F08, 0x5F09, 0x5F0A, 0x5F0B, 0x5F0C,
 0x5F0D, 0x5F0E, 0x5F0F, 0x0000
};
static const uint8_t s_table0_mv_bits[ 1100 ] SMS_DATA_SECTION = {
  1,  4,  4,  4,  5,  5,  5,  6,  6,  6,  7,  7,  7,  8,  8,  8,
  8,  8,  8,  8,  8,  8,  8,  8,  8,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 11, 11, 11, 11,
 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11,
 11, 11, 11, 11, 11, 11, 11, 11, 12, 12, 12, 12, 12, 12, 12, 12,
 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,
 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,
 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 13, 13, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
 14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
 15, 15, 15, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
 16, 16, 16, 16, 16, 16, 16, 16, 16, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17,  8
};
static const uint8_t s_table0_mvx[ 1099 ] SMS_DATA_SECTION = {
 32, 32, 31, 32, 33, 31, 33, 31, 33, 32, 34, 32, 30, 32, 31, 34,
 35, 32, 34, 33, 29, 33, 30, 30, 31, 31, 35, 29, 33, 35, 33, 34,
 31, 29, 30, 34, 30, 36, 28, 32, 34, 37, 30, 27, 32, 25, 39, 32,
 34, 32, 35, 35, 35, 31, 35, 29, 32, 29, 30, 29, 37, 27, 36, 38,
 37, 33, 32, 31, 29, 31, 28, 36, 33, 30, 34, 33, 33, 28, 27, 25,
 31, 26, 39, 32, 32, 31, 33, 39, 31, 38, 28, 36, 21, 23, 43, 36,
 34, 41, 30, 25, 28, 31, 30, 34, 38, 35, 61, 34, 28, 30, 37, 37,
 35, 27, 36,  3, 59, 38, 37, 32, 31, 29, 26, 33, 37, 33, 27, 27,
 35, 34, 34, 40, 42, 33, 32, 29,  4,  5, 28, 24, 25, 35, 39, 38,
 32, 23, 27, 32, 30, 35, 26, 34, 60, 36, 29, 22, 26, 41,  7, 30,
 38, 30, 36, 29, 30, 41, 26, 25, 32, 34, 24, 39,  1, 25, 39, 32,
 28, 29, 32, 38, 26, 36, 28, 63, 28, 39, 23, 21, 26, 35, 31, 35,
 57, 31, 29, 29, 28, 30, 27, 35,  2, 38, 40, 34, 37, 29, 38, 43,
 26, 32, 33, 42, 24, 40, 28, 32, 32, 32, 36, 32, 43, 25, 21, 31,
 30, 31, 41, 29, 33, 37, 26, 37, 27, 59, 23, 33, 35, 31, 31, 37,
 38, 39, 32, 23, 32, 27, 37, 36, 31, 40, 25, 27, 38, 31, 36, 28,
 31, 36, 25, 45,  3, 34, 38, 39, 40, 38, 30, 32, 19, 24, 25, 26,
 45, 20, 24, 33, 33, 31, 41, 34, 39, 47, 40, 58, 59, 41, 33,  3,
 17, 61, 42, 30, 26, 29, 36, 61, 33, 37, 62, 28, 25, 38, 25, 38,
 17, 23, 34, 33, 21, 33, 49, 27, 32, 23, 27, 22, 24, 22, 39, 43,
 27, 37,  6, 42, 47, 26, 30, 31, 41, 39, 33, 22, 45, 36, 32, 45,
 19, 22, 30,  5,  5, 17, 29, 22, 31, 31, 43, 37, 27, 32, 32, 32,
 33, 34, 43, 35, 29, 26, 22, 32, 19, 32, 25, 31, 41, 49, 28, 34,
 28, 39, 34, 19, 37, 38, 29, 21, 36, 42, 24, 48, 16, 28, 49, 22,
 34, 31, 38, 39, 44, 11, 35, 30, 33, 33, 23, 28, 33, 46, 15, 13,
 24, 41, 24, 34, 34, 30, 26, 24, 14, 60, 21, 29, 39, 23, 35, 37,
 63, 45, 33, 34, 47, 41, 22, 42, 35, 35, 23, 32, 35, 43, 32,  7,
 31, 41, 20, 31, 16, 13, 63, 25, 30, 32, 35, 30, 30, 31, 42, 47,
 39, 38, 40, 40, 51, 55, 56, 18, 21, 39, 39, 33, 17, 41, 23, 24,
 43, 25, 31, 20, 19, 45,  1, 34, 31, 22, 35, 15, 46, 46, 35, 31,
 28, 29, 29, 23, 41, 27, 14, 53, 53, 27, 24, 32, 57, 32, 17, 42,
 37, 29, 33,  1, 25, 32, 32, 63, 26, 40, 44, 36, 31, 39, 20, 20,
 44, 23, 33, 34, 35, 33, 33, 28, 41, 23, 41, 41, 29, 25, 26, 49,
 29, 24, 37, 49, 50, 51, 51, 26, 39, 25, 26, 15, 39, 18, 42, 17,
  4, 31, 32, 32, 60,  1, 42, 32,  0, 12, 19, 35, 21, 41, 17, 26,
 20, 45, 46, 32, 37, 22, 47, 29, 31, 27, 29, 30, 21, 33, 35, 18,
 25, 33, 50, 51, 42,  2, 15, 51, 53, 33, 25, 29, 55, 37, 38, 33,
 38, 59, 38, 33, 39, 13, 32, 40, 61, 61, 32,  9, 44,  3, 31, 29,
 25, 31, 27, 23,  9, 25,  9, 29, 20, 30, 30, 42, 18, 28, 25, 28,
 28, 21, 29, 43, 29, 43, 26, 44, 44, 21, 38, 21, 24, 45, 45, 35,
 39, 22, 35, 36, 34, 34, 45, 34, 29, 31, 46, 25, 46, 16, 17, 31,
 20, 32, 47, 47, 47, 32, 49, 49, 49, 31,  1, 27, 28, 39, 39, 21,
 36, 23, 51,  2, 40, 51, 32, 53, 24, 30, 24, 30, 21, 40, 57, 57,
 31, 41, 58, 32, 12,  4, 32, 34, 59, 31, 32, 13,  9, 35, 26, 35,
 37, 61, 37, 63, 26, 29, 41, 38, 23, 20, 41, 26, 41, 42, 42, 42,
 26, 26, 26, 26,  1, 26, 37, 37, 37, 23, 34, 42, 27, 43, 34, 27,
 31, 24, 33, 16,  3, 31, 24, 33, 24,  4, 44, 44, 11, 44, 31, 13,
 13, 44, 45, 13, 25, 22, 38, 26, 38, 38, 39, 32, 30, 39, 30, 22,
 32, 26, 30, 47, 47, 47, 19, 47, 30, 31, 35,  8, 23, 47, 47, 27,
 35, 47, 31, 48, 35, 19, 36, 49, 49, 33, 31, 39, 27, 39, 49, 49,
 50, 50, 50, 39, 31, 51, 51, 39, 28, 33, 33, 21, 40, 31, 52, 53,
 40, 53,  9, 33, 31, 53, 54, 54, 54, 55, 55, 34, 15, 56, 25, 56,
 21, 21, 40, 40, 25, 40, 58, 36,  5, 41, 41, 12, 60, 41, 41, 37,
 22, 61, 18, 29, 29, 30, 61, 30, 61, 62, 62, 30, 30, 63, 18, 13,
 30, 23, 19, 20, 20, 41, 13,  2,  5,  5,  1,  5, 32,  6, 32, 35,
 20, 35, 27, 35, 35, 36, 36, 13, 36, 41, 41, 41,  3, 30, 42, 27,
 20, 30, 27, 28, 30, 21, 33, 33, 14, 24, 30, 42, 24, 33, 25, 42,
 43, 14, 43, 43, 14, 43,  7, 36, 37, 37, 37, 37,  7, 14, 25, 43,
 43, 44, 15, 37,  7,  7,  3,  1,  8, 15, 15,  8, 44, 44, 44, 45,
 45, 45, 45,  8,  8, 45, 21, 45, 28, 28, 28, 21, 28, 28, 22, 37,
 46, 46, 37,  8, 29, 37, 29, 22, 46, 37, 22, 29, 47, 47, 38, 38,
 16, 38, 38, 33, 38, 22, 47, 47, 29, 25, 16,  0, 48,  1, 34, 48,
 48, 34, 25, 26, 26, 49, 49, 26,  1, 49,  4, 26,  4, 49,  1,  9,
 49, 49, 49, 10, 49, 17, 38, 17, 17, 50, 38, 50, 50, 22, 38, 51,
 38, 38, 51, 39, 39, 18, 22, 39, 51, 22, 52, 52, 52, 39, 53, 53,
 10, 23, 18, 29, 10, 53, 29, 54, 11, 54, 11, 11, 55,  1, 18, 55,
 55, 55, 55, 55, 55, 29, 34, 18, 29, 56, 56, 34, 57, 34, 34, 29,
 29, 57, 57, 35, 35, 35, 35, 35, 39, 35, 59, 59, 18, 59, 39, 30,
 18, 40, 60, 60, 61, 30, 18, 61, 61, 19, 19
};
static const uint8_t s_table0_mvy[ 1099 ] SMS_DATA_SECTION = {
 32, 31, 32, 33, 32, 31, 31, 33, 33, 34, 32, 30, 32, 35, 34, 31,
 32, 29, 33, 30, 32, 34, 33, 31, 30, 35, 31, 31, 29, 33, 35, 30,
 29, 33, 34, 34, 30, 32, 32, 36, 29, 32, 35, 32, 28, 32, 32, 27,
 35, 37, 34, 29, 30, 36, 35, 34, 25, 30, 29, 35, 33, 31, 31, 32,
 31, 28, 39, 28, 29, 37, 31, 33, 27, 36, 28, 36, 37, 33, 33, 31,
 27, 32, 31, 38, 26, 25, 25, 33, 39, 31, 34, 30, 32, 32, 32, 34,
 36, 32, 28, 33, 30, 38, 37, 27, 33, 28, 32, 37, 35, 38, 29, 34,
 27, 29, 29, 32, 32, 34, 35,  3, 26, 36, 31, 38, 30, 26, 35, 34,
 37, 26, 25, 32, 32, 39, 23, 37, 32, 32, 29, 32, 29, 36, 29, 30,
 41, 31, 30, 21, 39, 25, 34, 38, 32, 35, 39, 32, 33, 33, 32, 27,
 29, 25, 28, 27, 26, 31, 30, 35, 24, 24, 31, 34, 32, 30, 35, 40,
 28, 38,  5, 35, 29, 36, 36, 32, 38, 30, 33, 31, 35, 26, 23, 38,
 32, 41, 28, 25, 37, 40, 37, 39, 32, 36, 33, 39, 25, 26, 28, 31,
 28, 42, 23, 31, 33, 31, 39,  1, 59, 22, 27,  4, 33, 34, 33, 24,
 41,  3, 35, 41, 41, 28, 36, 36, 28, 33, 35, 21, 23, 21, 22, 37,
 27, 27, 43, 29, 60, 39, 27, 25, 59, 34, 27, 27, 26, 40, 37, 27,
 61, 26, 39, 33, 31, 22, 37, 25, 30, 25, 24, 61, 31, 34, 25, 38,
 32, 32, 30,  3, 61, 43, 29, 23, 28, 32, 28, 32, 31, 34,  5, 33,
 32, 33, 33, 42, 37, 23, 38, 31, 40, 26, 32, 26, 37, 38, 36, 24,
 29, 30, 20, 22, 29, 24, 32, 41,  2, 34, 25, 33, 29, 31, 39, 35,
 36, 24, 32, 30, 33, 27, 44, 60, 30, 36, 19, 34, 31, 24, 16, 35,
 32, 38, 21, 33, 31, 31, 21, 35,  5, 17, 29, 38, 38, 18, 58, 19,
 43, 41, 30, 41, 43, 39, 29,  7, 29, 17, 28, 19, 28, 31, 25, 19,
 40, 26, 21, 33, 39, 23, 40, 30, 39, 34, 35, 32, 32, 24, 33, 30,
 40, 47, 39, 37, 32, 33, 24, 23, 45, 47, 27, 23, 42, 32, 32, 33,
 36, 37, 37, 17, 18, 22, 40, 38, 32, 31, 35, 24, 17, 25, 17, 23,
 33, 34, 51, 42, 31, 36, 36, 29, 21, 22, 37, 44, 43, 25, 47, 33,
 45, 27, 31, 58, 31, 32, 31, 38, 43, 20, 47, 45, 54,  1, 26, 34,
 38, 14, 22, 24, 33, 34, 32, 32, 37, 21, 23, 49, 35, 23, 28, 39,
 39, 23, 55, 33, 30, 30, 63, 16, 42, 28, 13, 33, 33, 35, 19, 46,
 43, 17, 19, 36, 39, 24, 31, 32, 33, 26, 28, 62, 33, 63, 33, 39,
 19, 49, 17, 31, 43, 13, 15, 29, 25, 35, 33, 23, 49, 41, 28, 29,
 34, 38,  7, 61, 11, 50, 13, 41, 19, 47, 25, 26, 15, 42, 41, 29,
 45, 27, 17, 35, 32, 29, 32, 24, 13, 26, 26, 31, 24, 33, 28, 30,
 31, 11, 45, 46, 33, 33, 35, 57, 32, 32, 35, 45, 34, 11, 37, 42,
 39, 37, 31, 49, 21, 27, 29, 47, 53, 40, 51, 16, 26,  1, 40, 30,
 41, 44, 34, 25, 27, 31, 35, 35, 31, 15, 49,  1, 35, 40,  5, 58,
 21, 29, 22, 59, 45, 31,  9, 26,  9, 29, 11, 32, 30,  3, 13, 20,
 18, 20, 11,  3, 29, 40, 31, 53, 30, 17, 20, 37, 31, 42, 47, 47,
 54, 38,  9, 34, 13, 37, 21, 25, 27, 43, 42, 45, 40, 25, 27, 46,
 22, 25, 53, 20,  2, 14, 39, 15, 22, 44, 34, 21, 38, 33, 27, 48,
 34, 52, 35, 47, 49, 54,  2, 13, 23, 52, 29, 45, 22, 49, 54, 21,
 40, 42, 31, 30, 29, 34,  0, 25, 23, 51, 24, 59, 28, 38, 29, 31,
  2, 13, 31,  8, 31, 33, 12, 45, 41,  7, 14, 30, 25, 18, 43, 20,
 43, 35, 44,  1, 49, 42, 42, 18, 41, 38, 41, 44, 53, 11, 20, 25,
 45, 46, 47, 48, 39, 52, 46, 49, 63, 55, 44, 38, 13, 13, 57, 22,
 51, 16, 12, 28, 35, 57, 25, 20, 26, 28, 28, 29, 32, 31, 62, 34,
 35, 35, 19, 49, 48, 39, 40, 18, 43, 46, 11,  6, 48, 19, 49, 41,
 10, 23, 58, 17, 21, 23, 34, 30, 60,  0, 44, 34, 26, 37, 46, 43,
 49, 59,  4, 34, 59, 37, 22, 25, 28, 46,  6, 40, 59, 42, 36, 61,
 28, 30, 31, 43, 10, 22, 23, 47, 20, 52, 55, 36, 25, 16,  1, 11,
 27, 29,  5, 63, 18, 41, 31, 34, 38,  1,  5, 13, 28, 31, 17, 38,
 39, 41, 36, 37, 22, 39, 33, 43, 43, 15, 17, 49, 30, 21, 22, 20,
 10, 17, 25, 54, 57,  3, 34,  8, 36, 25, 31, 14, 15, 19, 29, 25,
 18, 39, 53, 22, 27, 20, 29, 33, 41, 42, 35, 62, 50, 29, 53, 50,
 35, 55, 42, 61, 63,  4,  7, 42, 21, 46, 47, 49, 27, 46, 17, 55,
 41, 50, 63,  4, 56, 18,  8, 10, 18, 51, 63, 36, 55, 18,  5, 55,
  9, 29, 17, 21, 30, 27,  1, 59,  7, 11, 12, 15,  5, 42, 24, 41,
 43,  7, 27, 22, 25, 31, 30, 37, 22, 39, 53, 29, 36, 37, 48,  0,
  5, 13, 17, 31, 32, 26, 46, 28, 44, 45, 46, 53, 49, 51,  3, 41,
  3, 22, 42, 33,  5, 45,  7, 22, 40, 53, 24, 14, 25, 27, 10, 12,
 34, 16, 17, 53, 20, 26, 39, 45, 18, 45, 35, 33, 31, 49,  4, 39,
 42, 11, 51,  5, 13, 26, 27, 17, 52, 30,  0, 22, 12, 34, 62, 36,
 38, 41, 47, 30, 63, 38, 41, 43, 59, 33, 45, 37, 38, 40, 47, 24,
 48, 49, 30,  1, 10, 22, 49, 15, 39, 59, 31, 32, 33, 18, 13, 15,
 31, 21, 27, 44, 42, 39, 46, 17, 26, 32, 30, 31,  0, 30, 34,  9,
 12, 13, 25, 31, 32, 55, 43, 35, 61, 33, 35, 46, 25, 47, 48, 62,
 63, 38, 61,  1,  2,  5,  7,  9, 46, 10, 34, 35, 36, 55, 51,  7,
 40, 23, 34, 37,  5, 13, 42, 18, 25, 27, 28
};
static const uint16_t s_table1_mv_code[ 1100 ] SMS_DATA_SECTION = {
 0x0000, 0x0007, 0x0009, 0x000F, 0x000A, 0x0011, 0x001A, 0x001C,
 0x0011, 0x0031, 0x0025, 0x002D, 0x002F, 0x006F, 0x0075, 0x0041,
 0x004C, 0x004E, 0x005C, 0x0060, 0x0062, 0x0066, 0x0068, 0x0069,
 0x006B, 0x00A6, 0x00C1, 0x00CB, 0x00CC, 0x00CE, 0x00DA, 0x00E8,
 0x00EE, 0x0087, 0x0090, 0x009E, 0x009F, 0x00BA, 0x00CA, 0x00D8,
 0x00DB, 0x00DF, 0x0104, 0x0109, 0x010C, 0x0143, 0x0145, 0x014A,
 0x0156, 0x015C, 0x01B3, 0x01D3, 0x01DA, 0x0103, 0x0109, 0x010B,
 0x0122, 0x0127, 0x0134, 0x0161, 0x0164, 0x0176, 0x0184, 0x018D,
 0x018E, 0x018F, 0x0190, 0x0193, 0x0196, 0x019D, 0x019E, 0x019F,
 0x01A9, 0x01B2, 0x01B4, 0x01BA, 0x01BB, 0x01BC, 0x0201, 0x0202,
 0x0205, 0x0207, 0x020D, 0x0210, 0x0211, 0x0215, 0x021B, 0x021F,
 0x0281, 0x0285, 0x0290, 0x029C, 0x029D, 0x02A2, 0x02A7, 0x02A8,
 0x02AA, 0x02B0, 0x02B1, 0x02B4, 0x02BC, 0x02BF, 0x0320, 0x0326,
 0x0327, 0x0329, 0x032A, 0x0336, 0x0360, 0x0362, 0x0363, 0x0372,
 0x03B2, 0x03BC, 0x03BD, 0x0203, 0x0205, 0x021A, 0x0249, 0x024A,
 0x024C, 0x02C7, 0x02CA, 0x02CE, 0x02EF, 0x030D, 0x0322, 0x0325,
 0x0338, 0x0373, 0x037A, 0x0409, 0x0415, 0x0416, 0x0418, 0x0428,
 0x042D, 0x042F, 0x0434, 0x0508, 0x0509, 0x0510, 0x0511, 0x051C,
 0x051E, 0x0524, 0x0541, 0x0543, 0x0546, 0x0547, 0x054D, 0x0557,
 0x055F, 0x056A, 0x056C, 0x056D, 0x056F, 0x0576, 0x0577, 0x057A,
 0x057B, 0x057C, 0x057D, 0x0600, 0x0601, 0x0603, 0x0614, 0x0616,
 0x0617, 0x061C, 0x061F, 0x0642, 0x0648, 0x0649, 0x064A, 0x064B,
 0x0657, 0x0668, 0x0669, 0x066B, 0x066E, 0x067F, 0x06C2, 0x06C8,
 0x06CB, 0x06DE, 0x06DF, 0x06E2, 0x06E3, 0x06EF, 0x0748, 0x074B,
 0x076E, 0x076F, 0x077C, 0x0409, 0x0423, 0x0428, 0x0429, 0x042A,
 0x042B, 0x0432, 0x0433, 0x0496, 0x049A, 0x04D5, 0x04DB, 0x0581,
 0x0582, 0x058B, 0x058C, 0x058D, 0x0598, 0x0599, 0x059A, 0x059E,
 0x05DD, 0x0619, 0x0632, 0x0633, 0x0648, 0x0672, 0x06A1, 0x06A2,
 0x06A3, 0x06AF, 0x06E2, 0x06E3, 0x06E4, 0x0800, 0x0801, 0x0802,
 0x0803, 0x081A, 0x081B, 0x0829, 0x082F, 0x0832, 0x083E, 0x083F,
 0x0852, 0x0853, 0x0858, 0x086B, 0x0877, 0x0878, 0x0879, 0x087A,
 0x087B, 0x0A00, 0x0A01, 0x0A0D, 0x0A0E, 0x0A0F, 0x0A24, 0x0A37,
 0x0A3A, 0x0A3B, 0x0A3E, 0x0A46, 0x0A47, 0x0A4A, 0x0A4B, 0x0A5F,
 0x0A79, 0x0A7A, 0x0A7B, 0x0A80, 0x0A81, 0x0A84, 0x0A85, 0x0A99,
 0x0AA5, 0x0AA6, 0x0AB8, 0x0ABA, 0x0ABB, 0x0ABC, 0x0ABD, 0x0AC8,
 0x0ACE, 0x0ACF, 0x0AD7, 0x0ADC, 0x0AEB, 0x0C04, 0x0C25, 0x0C26,
 0x0C27, 0x0C2A, 0x0C2B, 0x0C3A, 0x0C3B, 0x0C3C, 0x0C3D, 0x0CA0,
 0x0CAD, 0x0CD4, 0x0CD5, 0x0CFC, 0x0CFD, 0x0D86, 0x0D92, 0x0D93,
 0x0D94, 0x0D95, 0x0DB0, 0x0DB8, 0x0DB9, 0x0DBA, 0x0DBB, 0x0DC0,
 0x0DC2, 0x0DC3, 0x0DDA, 0x0DDB, 0x0DDC, 0x0DDD, 0x0E92, 0x0E93,
 0x0E94, 0x0E95, 0x0EC7, 0x0ECC, 0x0ECE, 0x0ECF, 0x0ED8, 0x0ED9,
 0x0EDA, 0x0EDB, 0x0808, 0x0809, 0x080A, 0x0810, 0x0811, 0x0844,
 0x0845, 0x0861, 0x0862, 0x0863, 0x086C, 0x0922, 0x0923, 0x092E,
 0x092F, 0x0936, 0x0937, 0x09B1, 0x09B2, 0x09B3, 0x09B4, 0x09B5,
 0x09B8, 0x09B9, 0x09BA, 0x09BB, 0x09BC, 0x09BD, 0x09BE, 0x09BF,
 0x0B00, 0x0B15, 0x0B2C, 0x0B2D, 0x0B2E, 0x0B2F, 0x0B36, 0x0BB9,
 0x0C28, 0x0C2A, 0x0C2B, 0x0C2C, 0x0C2D, 0x0C2E, 0x0C2F, 0x0C30,
 0x0C31, 0x0C38, 0x0C60, 0x0C61, 0x0C62, 0x0C63, 0x0C8D, 0x0C8E,
 0x0C8F, 0x0C92, 0x0CBE, 0x0CBF, 0x0CE6, 0x0CE7, 0x0D40, 0x0D41,
 0x0D57, 0x0D58, 0x0D59, 0x0D5A, 0x0D5B, 0x0D5C, 0x0D5D, 0x0D98,
 0x0D99, 0x0D9A, 0x0D9B, 0x0D9C, 0x0D9D, 0x0DAD, 0x0DAE, 0x0DAF,
 0x0DC0, 0x0DC1, 0x0DC2, 0x0DC3, 0x0DCA, 0x0DCB, 0x0DEC, 0x0DED,
 0x0DEE, 0x0DEF, 0x1018, 0x1022, 0x1023, 0x1030, 0x1031, 0x1032,
 0x1033, 0x1050, 0x1051, 0x105C, 0x1074, 0x1075, 0x1076, 0x1077,
 0x1078, 0x1079, 0x107A, 0x107B, 0x10B2, 0x10B3, 0x10B8, 0x10B9,
 0x10BA, 0x10BB, 0x10D4, 0x10EA, 0x10EB, 0x10EC, 0x10ED, 0x1404,
 0x1405, 0x1406, 0x1407, 0x1410, 0x1411, 0x1412, 0x1413, 0x1414,
 0x1415, 0x1416, 0x1417, 0x1418, 0x1419, 0x1466, 0x1467, 0x1468,
 0x1469, 0x146A, 0x146B, 0x146C, 0x146D, 0x147E, 0x147F, 0x1488,
 0x1489, 0x148A, 0x148B, 0x14B6, 0x14B7, 0x14B8, 0x14B9, 0x14BA,
 0x14BB, 0x14BC, 0x14BD, 0x14F0, 0x14F1, 0x14F8, 0x14F9, 0x14FA,
 0x14FB, 0x14FC, 0x14FD, 0x14FE, 0x14FF, 0x152A, 0x152B, 0x152C,
 0x152D, 0x152E, 0x152F, 0x1530, 0x1531, 0x1548, 0x1549, 0x154E,
 0x154F, 0x1558, 0x1559, 0x155A, 0x155B, 0x1572, 0x159A, 0x159B,
 0x15AC, 0x15BA, 0x15BB, 0x15D0, 0x15D1, 0x15D2, 0x15D3, 0x15D4,
 0x15D5, 0x181D, 0x181E, 0x181F, 0x1840, 0x1841, 0x1842, 0x1843,
 0x1844, 0x1845, 0x1846, 0x1847, 0x1848, 0x1849, 0x1861, 0x1862,
 0x1863, 0x1864, 0x1865, 0x1866, 0x1867, 0x1868, 0x1869, 0x186A,
 0x186B, 0x186C, 0x186D, 0x186E, 0x191B, 0x191C, 0x191D, 0x191E,
 0x191F, 0x1942, 0x1943, 0x1944, 0x1945, 0x1946, 0x1947, 0x1958,
 0x1959, 0x19ED, 0x19EE, 0x19EF, 0x19F0, 0x19F1, 0x19F2, 0x19F3,
 0x19F4, 0x19F5, 0x19F6, 0x19F7, 0x1B0E, 0x1B0F, 0x1B62, 0x1B63,
 0x1B64, 0x1B65, 0x1B66, 0x1B67, 0x1B68, 0x1B69, 0x1B6A, 0x1B6B,
 0x1B6C, 0x1B6D, 0x1B6E, 0x1B6F, 0x1B82, 0x1BA8, 0x1BA9, 0x1BAA,
 0x1BAB, 0x1BAC, 0x1BAD, 0x1BAE, 0x1BAF, 0x1BB0, 0x1BB1, 0x1BB2,
 0x1BB3, 0x1D80, 0x1D81, 0x1D82, 0x1D83, 0x1D84, 0x1D85, 0x1D86,
 0x1D87, 0x1D88, 0x1D89, 0x1D8A, 0x1D8B, 0x1D8C, 0x1D8D, 0x1007,
 0x1008, 0x1009, 0x100A, 0x100B, 0x100C, 0x100D, 0x100E, 0x100F,
 0x1016, 0x1080, 0x1081, 0x1082, 0x1083, 0x1084, 0x1085, 0x1086,
 0x1087, 0x10C0, 0x123A, 0x123B, 0x123C, 0x123D, 0x123E, 0x123F,
 0x1240, 0x1241, 0x1242, 0x1243, 0x1350, 0x1352, 0x1353, 0x1358,
 0x1359, 0x135A, 0x135B, 0x135C, 0x135D, 0x135E, 0x135F, 0x1360,
 0x1361, 0x1602, 0x1603, 0x160C, 0x160D, 0x160E, 0x160F, 0x1620,
 0x1621, 0x1622, 0x1623, 0x1624, 0x1625, 0x1626, 0x1627, 0x1628,
 0x1629, 0x166E, 0x166F, 0x167C, 0x167D, 0x167E, 0x167F, 0x1770,
 0x1771, 0x1852, 0x1853, 0x1872, 0x1873, 0x1874, 0x1875, 0x1876,
 0x1877, 0x1878, 0x1879, 0x187A, 0x187B, 0x187C, 0x187D, 0x187E,
 0x187F, 0x1918, 0x1919, 0x1926, 0x1927, 0x1970, 0x1971, 0x1972,
 0x1973, 0x1974, 0x1975, 0x1976, 0x1977, 0x1978, 0x1979, 0x197A,
 0x197B, 0x1AA0, 0x1AA1, 0x1AA2, 0x1AA3, 0x1AA4, 0x1AA5, 0x1AA6,
 0x1AA7, 0x1AA8, 0x1AA9, 0x1AAA, 0x1AAB, 0x1AAC, 0x1AAD, 0x1B3C,
 0x1B3D, 0x1B3E, 0x1B3F, 0x1B50, 0x1B51, 0x1B52, 0x1B53, 0x1B54,
 0x1B55, 0x1B56, 0x1B57, 0x1B58, 0x1B59, 0x2032, 0x2033, 0x2034,
 0x2035, 0x2036, 0x2037, 0x2038, 0x2039, 0x203A, 0x203B, 0x203C,
 0x203D, 0x203E, 0x203F, 0x2040, 0x2041, 0x2042, 0x2043, 0x20BA,
 0x20BB, 0x20CC, 0x20CD, 0x20CE, 0x20CF, 0x20E0, 0x20E1, 0x20E2,
 0x20E3, 0x20E4, 0x20E5, 0x20E6, 0x20E7, 0x21AA, 0x21AB, 0x21C0,
 0x21C1, 0x21C2, 0x21C3, 0x21C4, 0x21C5, 0x21C6, 0x21C7, 0x21C8,
 0x21C9, 0x21CA, 0x21CB, 0x21CC, 0x21CD, 0x21CE, 0x21CF, 0x21D0,
 0x21D1, 0x21D2, 0x21D3, 0x2894, 0x2895, 0x2896, 0x2897, 0x2898,
 0x2899, 0x289A, 0x289B, 0x289C, 0x289D, 0x289E, 0x289F, 0x28C0,
 0x28C1, 0x28C2, 0x28C3, 0x28C4, 0x28C5, 0x28C6, 0x28C7, 0x28C8,
 0x28C9, 0x28CA, 0x28CB, 0x2930, 0x2931, 0x2932, 0x2933, 0x2934,
 0x2935, 0x2936, 0x2937, 0x2938, 0x2939, 0x293A, 0x293B, 0x293C,
 0x293D, 0x293E, 0x293F, 0x2960, 0x2961, 0x2962, 0x2963, 0x2964,
 0x2965, 0x2966, 0x2967, 0x2968, 0x2969, 0x296A, 0x296B, 0x2A40,
 0x2A41, 0x2A42, 0x2A43, 0x2A44, 0x2A45, 0x2A46, 0x2A47, 0x2A48,
 0x2A49, 0x2A4A, 0x2A4B, 0x2A4C, 0x2A4D, 0x2A4E, 0x2A4F, 0x2A50,
 0x2A51, 0x2A52, 0x2A53, 0x2AE6, 0x2AE7, 0x2B24, 0x2B25, 0x2B26,
 0x2B27, 0x2B28, 0x2B29, 0x2B2A, 0x2B2B, 0x2B2C, 0x2B2D, 0x2B2E,
 0x2B2F, 0x2B30, 0x2B31, 0x2B32, 0x2B33, 0x2B5A, 0x2B5B, 0x3014,
 0x3015, 0x3016, 0x3017, 0x3020, 0x3021, 0x3022, 0x3023, 0x3024,
 0x3025, 0x3026, 0x3027, 0x3028, 0x3029, 0x302A, 0x302B, 0x302C,
 0x302D, 0x302E, 0x302F, 0x3030, 0x3031, 0x3032, 0x3033, 0x3034,
 0x3035, 0x3036, 0x3037, 0x3038, 0x3039, 0x30C0, 0x30C1, 0x30DE,
 0x30DF, 0x3218, 0x3219, 0x321A, 0x321B, 0x321C, 0x321D, 0x321E,
 0x321F, 0x3220, 0x3221, 0x3222, 0x3223, 0x3224, 0x3225, 0x3226,
 0x3227, 0x3228, 0x3229, 0x322A, 0x322B, 0x322C, 0x322D, 0x322E,
 0x322F, 0x3230, 0x3231, 0x3232, 0x3233, 0x3234, 0x3235, 0x3378,
 0x3379, 0x337A, 0x337B, 0x337C, 0x337D, 0x337E, 0x337F, 0x33C0,
 0x33C1, 0x33C2, 0x33C3, 0x33C4, 0x33C5, 0x33C6, 0x33C7, 0x33C8,
 0x33C9, 0x33CA, 0x33CB, 0x33CC, 0x33CD, 0x33CE, 0x33CF, 0x33D0,
 0x33D1, 0x33D2, 0x33D3, 0x33D4, 0x33D5, 0x33D6, 0x33D7, 0x33D8,
 0x33D9, 0x3706, 0x3707, 0x3730, 0x3731, 0x3732, 0x3733, 0x3734,
 0x3735, 0x3736, 0x3737, 0x3738, 0x3739, 0x373A, 0x373B, 0x373C,
 0x373D, 0x373E, 0x373F, 0x3740, 0x3741, 0x3742, 0x3743, 0x3744,
 0x3745, 0x3746, 0x3747, 0x3748, 0x3749, 0x374A, 0x374B, 0x374C,
 0x374D, 0x374E, 0x374F, 0x3B34, 0x3B35, 0x3B36, 0x3B37, 0x3BE8,
 0x3BE9, 0x3BEA, 0x3BEB, 0x3BEC, 0x3BED, 0x3BEE, 0x3BEF, 0x3BF0,
 0x3BF1, 0x3BF2, 0x3BF3, 0x3BF4, 0x3BF5, 0x3BF6, 0x3BF7, 0x3BF8,
 0x3BF9, 0x3BFA, 0x3BFB, 0x3BFC, 0x3BFD, 0x3BFE, 0x3BFF, 0x2000,
 0x2001, 0x2002, 0x2003, 0x2004, 0x2005, 0x2006, 0x2007, 0x2008,
 0x2009, 0x200A, 0x200B, 0x200C, 0x200D, 0x202E, 0x202F, 0x2182,
 0x2183, 0x21B4, 0x21B5, 0x21B6, 0x21B7, 0x21B8, 0x21B9, 0x21BA,
 0x21BB, 0x21BC, 0x21BD, 0x21BE, 0x21BF, 0x2460, 0x2461, 0x2462,
 0x2463, 0x2464, 0x2465, 0x2466, 0x2467, 0x2468, 0x2469, 0x246A,
 0x246B, 0x246C, 0x246D, 0x246E, 0x246F, 0x2470, 0x2471, 0x2472,
 0x2473, 0x26A2, 0x26A3, 0x000B
};
static const uint8_t s_table1_mv_bits[ 1100 ] SMS_DATA_SECTION = {
  2,  4,  4,  4,  5,  5,  5,  5,  6,  6,  7,  7,  7,  7,  7,  8,
  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
  8,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
 10, 10, 10, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11,
 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11,
 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11,
 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11,
 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11,
 11, 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,
 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,
 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,
 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,
 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,
 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,
 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,
 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,
 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 13, 13, 13, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
 13, 13, 13, 13, 13, 13, 13, 14, 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
 14, 14, 14, 14, 14, 14, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15,
 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,  4
};
static const uint8_t s_table1_mvx[ 1099 ] SMS_DATA_SECTION = {
 32, 31, 32, 31, 33, 32, 33, 33, 31, 34, 30, 32, 32, 34, 35, 32,
 34, 33, 29, 30, 30, 32, 31, 31, 33, 35, 35, 33, 31, 29, 29, 33,
 34, 30, 31, 28, 36, 30, 34, 32, 32, 37, 32, 32, 25, 27, 39, 32,
 32, 32, 38, 35, 36, 32, 37, 61, 26, 32, 34, 35,  3, 35, 27, 28,
 29, 34, 28, 37, 31, 36, 32, 27, 31, 30, 29, 39, 33, 29, 33, 35,
 25, 25, 29, 33, 31, 31, 31, 33, 32, 30, 32, 32, 41, 39, 33, 36,
 32, 28, 34, 36, 38, 24, 60, 31, 23, 28, 32, 33, 59, 32, 40, 30,
  5, 34, 32, 38, 32, 30, 43,  4, 32, 32, 42, 31, 31, 32, 26, 38,
 26, 22, 21, 37, 61, 63, 37, 31, 32, 33,  2,  1, 23, 33, 41, 27,
 35, 30, 38, 23, 33,  3, 28, 34, 34, 27, 41, 29, 39, 35, 36, 29,
 32, 27, 30, 32, 24, 61, 37, 26, 59, 25, 35, 27, 36, 37, 30, 31,
 34, 40,  3, 28, 34, 39, 32, 31, 32, 30, 24, 28, 35, 36, 26, 32,
 31, 33, 29, 33, 39, 25, 30, 24, 35, 59, 29, 34, 25, 30, 21, 35,
 43, 40, 32, 29,  5, 28, 31, 62, 33, 33, 25, 31, 21, 31, 43, 31,
 34, 33, 20, 40, 39, 31, 31, 57, 38, 32, 42, 33, 32, 31, 32, 29,
 30, 44,  5, 31, 22, 34, 36, 17, 38, 58, 38, 35, 32, 60, 35, 24,
 32, 38, 16, 45, 42, 32, 31, 29,  4, 30, 17, 40, 46, 48, 63, 32,
 42, 19, 41, 22, 28, 36, 45, 33, 33, 32, 29,  7, 41, 42, 18, 33,
 33, 32, 22, 37,  1, 26, 22, 23, 49, 28, 26, 27, 32, 33, 27, 23,
 28, 36, 15,  6, 34, 27, 31, 26, 23,  2, 33, 32, 34, 41, 28, 32,
 41,  0, 36, 38, 34, 31, 47, 32, 17, 31, 39, 33, 37, 51, 30, 47,
 32, 50, 32, 19, 63, 30, 25, 27, 33, 62, 24, 31, 27, 30, 37, 31,
 45, 32, 39, 20, 46, 47, 35, 19, 34,  1, 49, 21, 21, 14, 51, 26,
 23, 31, 36, 35, 58, 29, 29, 21, 20, 42, 13, 28, 12, 40, 31, 33,
 39, 60, 32, 44, 33, 31, 28, 37, 29, 32, 30, 49, 43, 28, 39, 25,
 32, 48,  2, 15, 20, 25, 31, 28, 21, 24, 25, 15, 31, 17, 37, 43,
 18, 32, 33, 24, 33, 36, 13, 33, 31, 39, 11, 31, 33, 32, 39, 37,
 32, 32, 29, 17, 44, 46, 36, 35, 26, 37, 58, 32, 34, 38,  8, 38,
 38, 22, 29, 25, 16, 35, 32, 35, 33, 43, 18, 46, 38, 50, 33, 18,
 53, 60, 13, 32, 36, 33, 51, 36, 43, 45, 27, 42, 29, 24, 30, 25,
 31, 52, 31, 35, 38,  9, 22, 34,  4, 17, 28, 55, 42, 25, 17, 20,
 47, 34, 33, 16, 40, 25, 16, 30, 53, 29, 10, 11, 14, 26, 33,  4,
 35, 44, 26, 16, 31, 26, 34, 38, 29, 31, 30, 24, 22, 61, 32,  9,
 45, 34, 31, 19,  9, 31, 46, 31, 35, 54, 29, 57, 30, 50,  3, 31,
 63, 34, 47, 41, 51, 18, 31, 14, 37, 38, 31, 24, 32, 31, 50, 33,
 31, 54, 27,  9, 33, 23, 19, 32, 29, 29, 33, 28, 47, 49, 30, 47,
 33, 27, 25, 54, 44, 45, 50, 58, 51, 48, 33, 59, 33, 34, 57, 13,
 26, 33, 13, 48, 30, 11,  7, 56, 34, 55, 26,  0, 26, 35,  1, 51,
 33, 53, 31, 45, 12, 29, 29, 51, 31, 48,  2,  6, 34, 30, 28, 33,
 60, 40, 27, 46, 31,  9, 35, 29, 31, 39, 55, 46, 19, 37, 62, 34,
 30, 16, 19, 49, 41, 41, 39, 37, 14,  5, 13, 35, 55, 30, 40, 40,
 42,  8, 20, 25, 45, 35, 33, 36, 54, 38, 27, 37, 62, 40, 15, 59,
 49, 31, 29, 34, 34, 39, 24, 29, 25, 29, 21, 29, 10, 61, 33, 49,
 35, 34,  3, 38, 39, 29,  7, 41,  1, 35,  4, 23, 15, 23, 11, 37,
 28, 35, 30, 30, 24,  1, 43, 56,  8, 34, 42, 24, 45, 30, 20, 23,
  8, 38, 22, 33, 17, 52, 34, 22, 53, 43, 44,  1, 27, 31, 41, 43,
 41, 30, 31, 36, 30,  5, 55, 31, 33, 30, 40, 23, 15, 29, 34, 34,
 59, 34, 30, 11, 13, 38,  5,  0, 30, 42,  5, 30, 29, 34, 10, 44,
 30, 63, 35, 12,  3, 26, 15, 17, 25, 34, 43, 39, 34, 56, 29, 23,
 30, 12, 30, 10, 35,  9, 24, 58, 10, 12, 54, 33, 37, 20, 41, 35,
 29, 18, 61, 30, 40, 24, 39, 53, 62, 26, 29, 33, 34, 53, 49, 21,
 27, 11, 63, 20, 26, 23,  7, 13,  6, 47, 29, 30,  9, 51, 22, 34,
 21, 25, 33, 56, 57, 30, 38, 51, 51, 38, 63, 28, 40, 35, 33, 18,
 33, 33, 24, 58, 58, 34, 49, 29, 43,  4,  1,  4, 42, 35, 35, 30,
 17,  5, 56, 61, 25, 37, 36, 55, 28, 35, 29, 50, 48, 52,  2, 42,
 34, 40, 46, 46, 43, 35, 29, 48, 20, 29, 31, 41,  7, 30, 35, 19,
 14, 21,  8, 39, 39, 40, 46, 55, 34,  6, 30, 34, 37, 25, 37, 33,
 22, 44, 52, 17, 35, 29, 36, 35, 40, 37, 28, 30, 50, 14, 28, 55,
  6, 23, 19, 14, 30,  3, 30, 28, 28, 61, 61, 47, 45, 48, 40, 40,
 34, 34, 25, 30, 29, 35,  4, 26, 53, 50, 26, 41, 27, 59, 27, 38,
 39,  3, 50, 43, 47, 23, 33, 55, 35, 21, 23, 35, 61, 33, 46, 52,
 35, 34, 24, 30, 43, 16, 37, 21,  2, 24, 45, 34, 30, 55, 55,  1,
 29, 29, 26, 28, 25, 31, 36, 22, 17, 30, 52,  2, 44, 44, 57, 26,
 62, 41, 39, 57, 26, 46, 49, 11, 16, 19,  5, 59, 38, 39, 58, 38,
 25, 49, 50, 22, 28, 59,  9, 59,  7, 28, 55, 17,  4, 35, 50, 21,
 29, 44, 47, 18, 24, 19, 25, 42, 35,  3, 51, 35, 16, 35, 30, 63,
 57, 39, 39, 25, 35, 38,  9, 16, 36, 45, 31, 60, 14, 34, 42, 24,
  0, 37, 18, 61, 57, 37, 28, 53, 20, 46, 14, 47, 38, 38, 38,  9,
 34, 39, 43, 17, 39, 59,  5, 27,  0, 12, 27
};
static const uint8_t s_table1_mvy[ 1099 ] SMS_DATA_SECTION = {
 32, 32, 31, 31, 32, 33, 31, 33, 33, 32, 32, 30, 34, 31, 32, 29,
 33, 30, 32, 33, 31, 35, 34, 30, 34, 31, 33, 29, 29, 31, 33, 35,
 30, 30, 35, 32, 32, 34, 34, 28, 25, 32, 36, 27, 32, 32, 32, 37,
 39,  3, 32, 30, 31, 26, 31, 32, 32, 38, 29, 29, 32, 34, 31, 31,
 34, 35, 33, 33, 28, 33,  1, 33, 27, 29, 30, 31, 28, 29, 37, 35,
 31, 33, 35, 27, 36, 37, 25, 25, 61, 35,  4,  5, 32, 33, 36, 30,
 23, 30, 28, 34, 31, 32, 32, 39, 32, 34, 21, 39, 32, 59, 32, 28,
 32, 36, 60, 33, 24, 36, 32, 32, 41,  2, 32, 38, 26, 22, 33, 30,
 31, 32, 32, 30, 31, 32, 29,  3, 40, 38, 32, 32, 33, 26, 31, 34,
 28, 38, 34, 31,  3, 31, 35, 38, 27, 35, 33, 28, 29, 27, 29, 27,
 43, 29, 37, 63, 31, 33, 34, 30, 31, 30, 37, 30, 35, 35, 26, 41,
 37, 31, 33, 28, 26, 30, 42, 24,  7, 27, 33, 29, 36, 28, 34, 57,
 23, 41, 36, 23, 35, 34, 25, 30, 25, 33, 25, 25, 29, 24, 33, 39,
 33, 33,  0, 37, 31, 36, 21, 32, 61, 24, 35, 61, 31,  5, 31, 59,
 39, 21, 32, 30, 34, 22, 40, 32, 29, 16, 31,  5, 62,  2, 20, 39,
 39, 32, 33,  1, 31, 24, 36, 32, 36, 32, 28, 26,  6, 31, 38, 34,
 58, 35, 32, 33, 33, 17, 43, 26, 31, 40, 31, 34, 32, 32, 31, 19,
 30, 32, 29, 33, 38, 38, 32, 59, 40, 18, 38, 32, 35, 34, 32, 17,
  1, 15, 30, 28, 31, 28, 34, 29, 32, 27, 35, 27, 49, 22, 37, 34,
 37, 26, 32, 32, 22, 28, 45, 29, 30, 31, 43, 46, 41, 30, 26, 13,
 34, 32, 27, 38, 42, 42, 33, 47, 33, 60, 27, 42, 25, 32, 22, 32,
 48, 32, 45, 33, 33, 41, 27, 25, 19, 31, 35, 19, 36, 42, 27, 17,
 31, 44, 28, 33, 33, 31, 23, 31, 40, 33, 31, 34, 30, 32, 33, 36,
 35, 47, 37, 41, 31, 23, 41, 29, 30, 35, 32, 25, 32, 28, 58,  2,
 37, 33, 14, 33, 49, 20, 39, 36, 21,  9, 23, 33, 35, 24, 39, 37,
 11, 33, 30, 31, 31, 28, 51, 40, 35, 29, 25, 33, 46, 35, 37, 30,
 30,  8, 63, 28, 15, 40, 33, 45, 49, 25, 32,  4, 47, 51, 36, 39,
 53, 10, 24, 29, 30, 31, 25, 40, 38, 38, 33, 56, 23, 27, 32, 37,
 26, 29, 43, 36, 33, 24, 55, 43,  9, 29, 34, 34, 24, 33, 18, 33,
 33, 30, 31, 50, 24, 60, 30, 39, 34, 30, 39, 28, 22, 38,  2, 26,
 63, 32, 57, 21, 39, 33, 28, 18, 30, 34, 22, 33, 29, 41, 30, 34,
 35, 21, 13, 34, 35, 39, 30, 46, 32, 42, 32, 31, 33, 26, 11, 33,
 22, 31, 25, 31, 53, 27, 43, 25, 40, 50, 21, 36, 38, 30, 12, 31,
 34, 20, 15, 29, 32, 62, 30, 13, 17, 32, 19, 31, 20, 31, 30,  7,
  1, 17, 34, 37, 31, 31, 44, 34, 26, 40, 16, 37, 52, 48, 30, 20,
 18, 33, 38, 29,  7, 25, 30, 54, 45, 47, 46, 41, 29, 29, 16, 30,
 14, 26, 38, 34, 34, 29, 34, 30, 29, 30, 57, 30,  4, 46, 33, 29,
 39, 44, 30, 31, 50, 33, 31, 32, 19, 32, 40, 31, 37, 47,  1, 35,
 16, 31,  0, 35, 33,  1, 17, 34,  9, 34, 33, 31, 49, 43, 42, 51,
 34, 29, 23, 29, 14, 30, 45, 49, 11, 24, 31, 28, 35, 41, 30, 44,
 18, 29, 34, 35, 36, 25, 26, 21, 31, 30, 34, 19, 34, 44, 36, 38,
 25, 31, 28, 23, 37,  3, 55, 41, 30, 22, 41, 24, 33, 26, 35, 35,
 30, 55, 51, 47, 48, 38, 24, 15, 21, 50, 25, 46, 30, 29, 10, 34,
 42, 45, 29, 42, 22,  3, 33, 27, 34,  1, 34, 28, 34, 36, 35, 23,
 23, 13, 58,  3, 26, 63, 25, 31, 34, 61, 38, 39, 25, 61, 29, 37,
 30, 41, 26, 48, 28, 33, 50, 35, 30, 37, 29, 29, 40,  6, 39, 28,
 28, 19,  8, 22, 45, 34, 35, 10, 58, 17, 37, 39, 30, 18, 54, 14,
 29, 16, 59, 30, 35, 23, 35, 30, 47, 36, 29, 55, 20, 12, 31, 35,
 14, 29, 18, 34, 34, 24, 29, 26, 22,  2, 27, 23,  8, 30, 55, 38,
 60, 31,  4, 34, 49, 34, 27, 34, 33, 30, 31, 54, 42, 35, 38, 46,
 44, 26, 27,  9, 39, 25, 21, 29, 28, 42, 13,  0,  5, 34, 37, 28,
 24, 29, 63, 26, 22, 27, 29, 25, 33, 25, 61,  0, 35, 25, 36, 15,
 27, 40, 53, 33,  3, 10, 16, 37, 38, 18, 30, 46, 27,  9,  6, 29,
 62,  8, 42, 28, 29,  3, 25, 16, 26, 29, 35, 28, 27, 51, 61, 48,
 37,  9, 34,  7, 49, 45, 20, 29, 21,  5,  5, 29, 28, 34, 29, 24,
 10, 24, 35, 36, 38, 55, 11, 36, 38, 53, 54, 26, 30, 49, 20, 27,
 30, 39, 33, 41, 49, 22, 38, 38,  4, 30,  8,  9,  3, 24, 22, 50,
 37, 36, 31, 27,  2,  9, 42, 63, 25, 19, 44,  1, 28, 28, 48, 30,
 34, 41, 41, 38, 12, 27, 15,  0, 16, 34, 35, 38, 28, 29, 40, 42,
 51, 52, 45, 54, 59, 59, 42, 44, 37, 26, 46, 24, 15, 39, 22, 46,
 19, 35, 38, 17, 37, 23, 52, 55, 50, 37, 26, 11, 37, 12, 24, 30,
 16, 13, 22, 13, 36, 35, 40, 41, 34, 41, 26, 53, 51,  5, 21, 30,
  2, 63, 41, 20,  1, 56, 21, 24, 25,  5, 28, 35, 26, 28, 30, 18,
 29, 23, 40, 34, 20, 42, 39, 34, 28, 61, 38, 27, 62,  9, 36, 17,
  9, 49, 24, 25, 54, 34, 39, 37,  3,  1, 25, 38, 38, 44, 35, 36,
 12, 60, 36, 38, 40, 25, 43, 39, 53, 28, 39, 57, 46, 10, 52, 27,
 35, 42, 45, 59, 15, 60, 38, 24, 23, 39, 12, 29, 24,  0, 20, 16,
 28, 43, 35, 28,  1, 49,  4, 21, 42, 39, 29,  3, 44, 21, 53, 55,
 11,  5,  3, 39, 53, 28, 25, 19, 34, 28, 21
};
static MVTable s_mv_tables[ 2 ] = {
 { 1099, s_table0_mv_code, s_table0_mv_bits, s_table0_mvx, s_table0_mvy },
 { 1099, s_table1_mv_code, s_table1_mv_bits, s_table1_mvx, s_table1_mvy }
};
static const uint32_t s_table0_dc_lum[ 120 ][ 2 ] SMS_DATA_SECTION = {
 { 0x00001,  1 }, { 0x00001,  2 }, { 0x00001,  4 }, { 0x00001,  5 },
 { 0x00005,  5 }, { 0x00007,  5 }, { 0x00008,  6 }, { 0x0000C,  6 },
 { 0x00000,  7 }, { 0x00002,  7 }, { 0x00012,  7 }, { 0x0001A,  7 },
 { 0x00003,  8 }, { 0x00007,  8 }, { 0x00027,  8 }, { 0x00037,  8 },
 { 0x00005,  9 }, { 0x0004C,  9 }, { 0x0006C,  9 }, { 0x0006D,  9 },
 { 0x00008, 10 }, { 0x00019, 10 }, { 0x0009B, 10 }, { 0x0001B, 10 },
 { 0x0009A, 10 }, { 0x00013, 11 }, { 0x00034, 11 }, { 0x00035, 11 },
 { 0x00061, 12 }, { 0x00048, 13 }, { 0x000C4, 13 }, { 0x0004A, 13 },
 { 0x000C6, 13 }, { 0x000C7, 13 }, { 0x00092, 14 }, { 0x0018B, 14 },
 { 0x00093, 14 }, { 0x00183, 14 }, { 0x00182, 14 }, { 0x00096, 14 },
 { 0x00097, 14 }, { 0x00180, 14 }, { 0x00314, 15 }, { 0x00315, 15 },
 { 0x00605, 16 }, { 0x00604, 16 }, { 0x00606, 16 }, { 0x00C0E, 17 },
 { 0x303CD, 23 }, { 0x303C9, 23 }, { 0x303C8, 23 }, { 0x303CA, 23 },
 { 0x303CB, 23 }, { 0x303CC, 23 }, { 0x303CE, 23 }, { 0x303CF, 23 },
 { 0x303D0, 23 }, { 0x303D1, 23 }, { 0x303D2, 23 }, { 0x303D3, 23 },
 { 0x303D4, 23 }, { 0x303D5, 23 }, { 0x303D6, 23 }, { 0x303D7, 23 },
 { 0x303D8, 23 }, { 0x303D9, 23 }, { 0x303DA, 23 }, { 0x303DB, 23 },
 { 0x303DC, 23 }, { 0x303DD, 23 }, { 0x303DE, 23 }, { 0x303DF, 23 },
 { 0x303E0, 23 }, { 0x303E1, 23 }, { 0x303E2, 23 }, { 0x303E3, 23 },
 { 0x303E4, 23 }, { 0x303E5, 23 }, { 0x303E6, 23 }, { 0x303E7, 23 },
 { 0x303E8, 23 }, { 0x303E9, 23 }, { 0x303EA, 23 }, { 0x303EB, 23 },
 { 0x303EC, 23 }, { 0x303ED, 23 }, { 0x303EE, 23 }, { 0x303EF, 23 },
 { 0x303F0, 23 }, { 0x303F1, 23 }, { 0x303F2, 23 }, { 0x303F3, 23 },
 { 0x303F4, 23 }, { 0x303F5, 23 }, { 0x303F6, 23 }, { 0x303F7, 23 },
 { 0x303F8, 23 }, { 0x303F9, 23 }, { 0x303FA, 23 }, { 0x303FB, 23 },
 { 0x303FC, 23 }, { 0x303FD, 23 }, { 0x303FE, 23 }, { 0x303FF, 23 },
 { 0x60780, 24 }, { 0x60781, 24 }, { 0x60782, 24 }, { 0x60783, 24 },
 { 0x60784, 24 }, { 0x60785, 24 }, { 0x60786, 24 }, { 0x60787, 24 },
 { 0x60788, 24 }, { 0x60789, 24 }, { 0x6078A, 24 }, { 0x6078B, 24 },
 { 0x6078C, 24 }, { 0x6078D, 24 }, { 0x6078E, 24 }, { 0x6078F, 24 }
};
static const uint32_t s_table0_dc_chroma[ 120 ][ 2 ] SMS_DATA_SECTION = {
 { 0x000000,  2 }, { 0x000001,  2 }, { 0x000005,  3 }, { 0x000009,  4 },
 { 0x00000D,  4 }, { 0x000011,  5 }, { 0x00001D,  5 }, { 0x00001F,  5 },
 { 0x000021,  6 }, { 0x000031,  6 }, { 0x000038,  6 }, { 0x000033,  6 },
 { 0x000039,  6 }, { 0x00003D,  6 }, { 0x000061,  7 }, { 0x000079,  7 },
 { 0x000080,  8 }, { 0x0000C8,  8 }, { 0x0000CA,  8 }, { 0x0000F0,  8 },
 { 0x000081,  8 }, { 0x0000C0,  8 }, { 0x0000C9,  8 }, { 0x000107,  9 },
 { 0x000106,  9 }, { 0x000196,  9 }, { 0x000183,  9 }, { 0x0001E3,  9 },
 { 0x0001E2,  9 }, { 0x00020A, 10 }, { 0x00020B, 10 }, { 0x000609, 11 },
 { 0x000412, 11 }, { 0x000413, 11 }, { 0x00060B, 11 }, { 0x000411, 11 },
 { 0x00060A, 11 }, { 0x00065F, 11 }, { 0x000410, 11 }, { 0x00065D, 11 },
 { 0x00065E, 11 }, { 0x000CB8, 12 }, { 0x000C10, 12 }, { 0x000CB9, 12 },
 { 0x001823, 13 }, { 0x003045, 14 }, { 0x006089, 15 }, { 0x00C110, 16 },
 { 0x304448, 22 }, { 0x304449, 22 }, { 0x30444A, 22 }, { 0x30444B, 22 },
 { 0x30444C, 22 }, { 0x30444D, 22 }, { 0x30444E, 22 }, { 0x30444F, 22 },
 { 0x304450, 22 }, { 0x304451, 22 }, { 0x304452, 22 }, { 0x304453, 22 },
 { 0x304454, 22 }, { 0x304455, 22 }, { 0x304456, 22 }, { 0x304457, 22 },
 { 0x304458, 22 }, { 0x304459, 22 }, { 0x30445A, 22 }, { 0x30445B, 22 },
 { 0x30445C, 22 }, { 0x30445D, 22 }, { 0x30445E, 22 }, { 0x30445F, 22 },
 { 0x304460, 22 }, { 0x304461, 22 }, { 0x304462, 22 }, { 0x304463, 22 },
 { 0x304464, 22 }, { 0x304465, 22 }, { 0x304466, 22 }, { 0x304467, 22 },
 { 0x304468, 22 }, { 0x304469, 22 }, { 0x30446A, 22 }, { 0x30446B, 22 },
 { 0x30446C, 22 }, { 0x30446D, 22 }, { 0x30446E, 22 }, { 0x30446F, 22 },
 { 0x304470, 22 }, { 0x304471, 22 }, { 0x304472, 22 }, { 0x304473, 22 },
 { 0x304474, 22 }, { 0x304475, 22 }, { 0x304476, 22 }, { 0x304477, 22 },
 { 0x304478, 22 }, { 0x304479, 22 }, { 0x30447A, 22 }, { 0x30447B, 22 },
 { 0x30447C, 22 }, { 0x30447D, 22 }, { 0x30447E, 22 }, { 0x30447F, 22 },
 { 0x608880, 23 }, { 0x608881, 23 }, { 0x608882, 23 }, { 0x608883, 23 },
 { 0x608884, 23 }, { 0x608885, 23 }, { 0x608886, 23 }, { 0x608887, 23 },
 { 0x608888, 23 }, { 0x608889, 23 }, { 0x60888A, 23 }, { 0x60888B, 23 },
 { 0x60888C, 23 }, { 0x60888D, 23 }, { 0x60888E, 23 }, { 0x60888F, 23 }
};
static const uint32_t s_table1_dc_lum[ 120 ][ 2 ] SMS_DATA_SECTION = {
 { 0x000002,  2 }, { 0x000003,  2 }, { 0x000003,  3 }, { 0x000002,  4 },
 { 0x000005,  4 }, { 0x000001,  5 }, { 0x000003,  5 }, { 0x000008,  5 },
 { 0x000000,  6 }, { 0x000005,  6 }, { 0x00000D,  6 }, { 0x00000F,  6 },
 { 0x000013,  6 }, { 0x000008,  7 }, { 0x000018,  7 }, { 0x00001C,  7 },
 { 0x000024,  7 }, { 0x000004,  8 }, { 0x000006,  8 }, { 0x000012,  8 },
 { 0x000032,  8 }, { 0x00003B,  8 }, { 0x00004A,  8 }, { 0x00004B,  8 },
 { 0x00000B,  9 }, { 0x000026,  9 }, { 0x000027,  9 }, { 0x000066,  9 },
 { 0x000074,  9 }, { 0x000075,  9 }, { 0x000014, 10 }, { 0x00001C, 10 },
 { 0x00001F, 10 }, { 0x00001D, 10 }, { 0x00002B, 11 }, { 0x00003D, 11 },
 { 0x00019D, 11 }, { 0x00019F, 11 }, { 0x000054, 12 }, { 0x000339, 12 },
 { 0x000338, 12 }, { 0x00033D, 12 }, { 0x0000AB, 13 }, { 0x0000F1, 13 },
 { 0x000678, 13 }, { 0x0000F2, 13 }, { 0x0001E0, 14 }, { 0x0001E1, 14 },
 { 0x000154, 14 }, { 0x000CF2, 14 }, { 0x0003CC, 15 }, { 0x0002AB, 15 },
 { 0x0019E7, 15 }, { 0x0003CE, 15 }, { 0x0019E6, 15 }, { 0x000554, 16 },
 { 0x00079F, 16 }, { 0x000555, 16 }, { 0x000F3D, 17 }, { 0x000F37, 17 },
 { 0x000F3C, 17 }, { 0x000F35, 17 }, { 0x001E6D, 18 }, { 0x001E68, 18 },
 { 0x003CD8, 19 }, { 0x003CD3, 19 }, { 0x003CD9, 19 }, { 0x0079A4, 20 },
 { 0x0F34BA, 25 }, { 0x0F34B4, 25 }, { 0x0F34B5, 25 }, { 0x0F34B6, 25 },
 { 0x0F34B7, 25 }, { 0x0F34B8, 25 }, { 0x0F34B9, 25 }, { 0x0F34BB, 25 },
 { 0x0F34BC, 25 }, { 0x0F34BD, 25 }, { 0x0F34BE, 25 }, { 0x0F34BF, 25 },
 { 0x1E6940, 26 }, { 0x1E6941, 26 }, { 0x1E6942, 26 }, { 0x1E6943, 26 },
 { 0x1E6944, 26 }, { 0x1E6945, 26 }, { 0x1E6946, 26 }, { 0x1E6947, 26 },
 { 0x1E6948, 26 }, { 0x1E6949, 26 }, { 0x1E694A, 26 }, { 0x1E694B, 26 },
 { 0x1E694C, 26 }, { 0x1E694D, 26 }, { 0x1E694E, 26 }, { 0x1E694F, 26 },
 { 0x1E6950, 26 }, { 0x1E6951, 26 }, { 0x1E6952, 26 }, { 0x1E6953, 26 },
 { 0x1E6954, 26 }, { 0x1E6955, 26 }, { 0x1E6956, 26 }, { 0x1E6957, 26 },
 { 0x1E6958, 26 }, { 0x1E6959, 26 }, { 0x1E695A, 26 }, { 0x1E695B, 26 },
 { 0x1E695C, 26 }, { 0x1E695D, 26 }, { 0x1E695E, 26 }, { 0x1E695F, 26 },
 { 0x1E6960, 26 }, { 0x1E6961, 26 }, { 0x1E6962, 26 }, { 0x1E6963, 26 },
 { 0x1E6964, 26 }, { 0x1E6965, 26 }, { 0x1E6966, 26 }, { 0x1E6967, 26 }
};

static const uint32_t s_table1_dc_chroma[ 120 ][ 2 ] SMS_DATA_SECTION = {
 { 0x0000000,  2 }, { 0x0000001,  2 }, { 0x0000004,  3 }, { 0x0000007,  3 },
 { 0x000000B,  4 }, { 0x000000D,  4 }, { 0x0000015,  5 }, { 0x0000028,  6 },
 { 0x0000030,  6 }, { 0x0000032,  6 }, { 0x0000052,  7 }, { 0x0000062,  7 },
 { 0x0000066,  7 }, { 0x00000A6,  8 }, { 0x00000C6,  8 }, { 0x00000CF,  8 },
 { 0x000014F,  9 }, { 0x000018E,  9 }, { 0x000019C,  9 }, { 0x000029D, 10 },
 { 0x000033A, 10 }, { 0x0000538, 11 }, { 0x000063C, 11 }, { 0x000063E, 11 },
 { 0x000063F, 11 }, { 0x0000676, 11 }, { 0x0000A73, 12 }, { 0x0000C7A, 12 },
 { 0x0000CEF, 12 }, { 0x00014E5, 13 }, { 0x00019DD, 13 }, { 0x00029C8, 14 },
 { 0x00029C9, 14 }, { 0x00063DD, 15 }, { 0x00033B8, 14 }, { 0x00033B9, 14 },
 { 0x000C7B6, 16 }, { 0x00063D8, 15 }, { 0x00063DF, 15 }, { 0x000C7B3, 16 },
 { 0x000C7B4, 16 }, { 0x000C7B5, 16 }, { 0x00063DE, 15 }, { 0x000C7B7, 16 },
 { 0x000C7B8, 16 }, { 0x000C7B9, 16 }, { 0x0018F65, 17 }, { 0x0031EC8, 18 },
 { 0x0C7B248, 24 }, { 0x0C7B249, 24 }, { 0x0C7B24A, 24 }, { 0x0C7B24B, 24 },
 { 0x0C7B24C, 24 }, { 0x0C7B24D, 24 }, { 0x0C7B24E, 24 }, { 0x0C7B24F, 24 },
 { 0x0C7B250, 24 }, { 0x0C7B251, 24 }, { 0x0C7B252, 24 }, { 0x0C7B253, 24 },
 { 0x0C7B254, 24 }, { 0x0C7B255, 24 }, { 0x0C7B256, 24 }, { 0x0C7B257, 24 },
 { 0x0C7B258, 24 }, { 0x0C7B259, 24 }, { 0x0C7B25A, 24 }, { 0x0C7B25B, 24 },
 { 0x0C7B25C, 24 }, { 0x0C7B25D, 24 }, { 0x0C7B25E, 24 }, { 0x0C7B25F, 24 },
 { 0x0C7B260, 24 }, { 0x0C7B261, 24 }, { 0x0C7B262, 24 }, { 0x0C7B263, 24 },
 { 0x0C7B264, 24 }, { 0x0C7B265, 24 }, { 0x0C7B266, 24 }, { 0x0C7B267, 24 },
 { 0x0C7B268, 24 }, { 0x0C7B269, 24 }, { 0x0C7B26A, 24 }, { 0x0C7B26B, 24 },
 { 0x0C7B26C, 24 }, { 0x0C7B26D, 24 }, { 0x0C7B26E, 24 }, { 0x0C7B26F, 24 },
 { 0x0C7B270, 24 }, { 0x0C7B271, 24 }, { 0x0C7B272, 24 }, { 0x0C7B273, 24 },
 { 0x0C7B274, 24 }, { 0x0C7B275, 24 }, { 0x0C7B276, 24 }, { 0x0C7B277, 24 },
 { 0x0C7B278, 24 }, { 0x0C7B279, 24 }, { 0x0C7B27A, 24 }, { 0x0C7B27B, 24 },
 { 0x0C7B27C, 24 }, { 0x0C7B27D, 24 }, { 0x0C7B27E, 24 }, { 0x0C7B27F, 24 },
 { 0x18F6480, 25 }, { 0x18F6481, 25 }, { 0x18F6482, 25 }, { 0x18F6483, 25 },
 { 0x18F6484, 25 }, { 0x18F6485, 25 }, { 0x18F6486, 25 }, { 0x18F6487, 25 },
 { 0x18F6488, 25 }, { 0x18F6489, 25 }, { 0x18F648A, 25 }, { 0x18F648B, 25 },
 { 0x18F648C, 25 }, { 0x18F648D, 25 }, { 0x18F648E, 25 }, { 0x18F648F, 25 }
};
static const uint8_t s_v2_intra_cbpc[ 4 ][ 2 ] SMS_DATA_SECTION = {
 { 1, 1 }, { 0, 3 }, { 1, 3 }, { 1, 2 }
};
static const uint8_t s_v2_mb_type[ 8 ][ 2 ] SMS_DATA_SECTION = {
 { 1, 1 }, {    0, 2 }, {    3, 3 }, {   9, 5 },
 { 5, 4 }, { 0x21, 7 }, { 0x20, 7 }, {0x11, 6 }
};
static const uint16_t s_table_mb_intra[ 64 ][ 2 ] SMS_DATA_SECTION = {
 { 0x01, 1 }, { 0x017,  6 }, { 0x009,  5 }, { 0x005,  5 },
 { 0x06, 5 }, { 0x047,  9 }, { 0x020,  7 }, { 0x010,  7 },
 { 0x02, 5 }, { 0x07C,  9 }, { 0x03A,  7 }, { 0x01D,  7 },
 { 0x02, 6 }, { 0x0EC,  9 }, { 0x077,  8 }, { 0x000,  8 },
 { 0x03, 5 }, { 0x0B7,  9 }, { 0x02C,  7 }, { 0x013,  7 },
 { 0x01, 6 }, { 0x168, 10 }, { 0x046,  8 }, { 0x03F,  8 },
 { 0x1E, 6 }, { 0x712, 13 }, { 0x0B5,  9 }, { 0x042,  8 },
 { 0x22, 7 }, { 0x1C5, 11 }, { 0x11E, 10 }, { 0x087,  9 },
 { 0x06, 4 }, { 0x003,  9 }, { 0x01E,  7 }, { 0x01C,  6 },
 { 0x12, 7 }, { 0x388, 12 }, { 0x044,  9 }, { 0x070,  9 },
 { 0x1F, 6 }, { 0x23E, 11 }, { 0x039,  8 }, { 0x08E,  9 },
 { 0x01, 7 }, { 0x1C6, 11 }, { 0x0B6,  9 }, { 0x045,  9 },
 { 0x14, 6 }, { 0x23F, 11 }, { 0x07D,  9 }, { 0x018,  9 },
 { 0x07, 7 }, { 0x1C7, 11 }, { 0x086,  9 }, { 0x019,  9 },
 { 0x15, 6 }, { 0x1DB, 10 }, { 0x002,  9 }, { 0x046,  9 },
 { 0x0D, 8 }, { 0x713, 13 }, { 0x1DA, 10 }, { 0x169, 10 }
};
static const uint8_t s_table_inter_intra[ 4 ][ 2 ] = {
 { 0, 1 }, { 2, 2 }, { 6, 3 }, { 7, 3 }
};
static const uint32_t s_table_mb_non_intra[ 128 ][ 2 ] SMS_DATA_SECTION = {
 { 0x0040,  7 }, { 0x0013C9, 13 }, { 0x009FD, 12 }, { 0x001FC, 15 },
 { 0x09FC, 12 }, { 0x000A83, 18 }, { 0x12D34, 17 }, { 0x083BC, 16 },
 { 0x083A, 12 }, { 0x0007F8, 17 }, { 0x003FD, 16 }, { 0x003FF, 16 },
 { 0x0079, 13 }, { 0x000A82, 18 }, { 0x0969D, 16 }, { 0x002A4, 16 },
 { 0x0978, 12 }, { 0x000543, 17 }, { 0x041DF, 15 }, { 0x007F9, 17 },
 { 0x12F3, 13 }, { 0x025A6B, 18 }, { 0x25EF9, 18 }, { 0x003FA, 16 },
 { 0x20EE, 14 }, { 0x0969AB, 20 }, { 0x0969C, 16 }, { 0x25EF8, 18 },
 { 0x12D2, 13 }, { 0x000A85, 18 }, { 0x0969E, 16 }, { 0x04BC8, 15 },
 { 0x003D, 12 }, { 0x012F7F, 17 }, { 0x002A2, 16 }, { 0x0969F, 16 },
 { 0x25EE, 14 }, { 0x12D355, 21 }, { 0x12F7D, 17 }, { 0x12F7E, 17 },
 { 0x09E5, 12 }, { 0x000A81, 18 }, { 0x4B4D4, 19 }, { 0x083BD, 16 },
 { 0x0078, 13 }, { 0x00969B, 16 }, { 0x003FE, 16 }, { 0x002A5, 16 },
 { 0x007E, 13 }, { 0x000A80, 18 }, { 0x002A3, 16 }, { 0x003FB, 16 },
 { 0x1076, 13 }, { 0x000A84, 18 }, { 0x00153, 15 }, { 0x04BC9, 15 },
 { 0x0055, 13 }, { 0x12D354, 21 }, { 0x04BDE, 15 }, { 0x025E5, 14 },
 { 0x025B, 10 }, { 0x004B4C, 15 }, { 0x0096B, 12 }, { 0x0096A, 12 },
 { 0x0001,  2 }, { 0x000000,  7 }, { 0x00026,  6 }, { 0x0012B,  9 },
 { 0x0007,  3 }, { 0x00020F, 10 }, { 0x00004,  9 }, { 0x00028, 12 },
 { 0x0006,  3 }, { 0x00020A, 10 }, { 0x00128,  9 }, { 0x0002B, 12 },
 { 0x0011,  5 }, { 0x00001B, 11 }, { 0x0013A,  9 }, { 0x004FF, 11 },
 { 0x0003,  4 }, { 0x000277, 10 }, { 0x00106,  9 }, { 0x00839, 12 },
 { 0x000B,  4 }, { 0x00027B, 10 }, { 0x0012C,  9 }, { 0x004BF, 11 },
 { 0x0009,  6 }, { 0x000035, 12 }, { 0x0027E, 10 }, { 0x013C8, 13 },
 { 0x0001,  6 }, { 0x0004AA, 11 }, { 0x00208, 10 }, { 0x00029, 12 },
 { 0x0001,  4 }, { 0x000254, 10 }, { 0x0012E,  9 }, { 0x00838, 12 },
 { 0x0024,  6 }, { 0x0004F3, 11 }, { 0x00276, 10 }, { 0x012F6, 13 },
 { 0x0001,  5 }, { 0x00027A, 10 }, { 0x0013E,  9 }, { 0x0003E, 12 },
 { 0x0008,  6 }, { 0x000413, 11 }, { 0x0000C, 10 }, { 0x004BE, 11 },
 { 0x0014,  5 }, { 0x000412, 11 }, { 0x00253, 10 }, { 0x0097A, 12 },
 { 0x0021,  6 }, { 0x0004AB, 11 }, { 0x0020B, 10 }, { 0x00034, 12 },
 { 0x0015,  5 }, { 0x000278, 10 }, { 0x00252, 10 }, { 0x00968, 12 },
 { 0x0005,  5 }, { 0x00000B, 10 }, { 0x0009C,  8 }, { 0x0000E, 10 }
};
static const uint32_t s_table_mb_non_intra2[ 128 ][ 2 ] SMS_DATA_SECTION = {
 { 0x0000A7, 14 }, { 0x01B2B8, 18 }, { 0x01B28E, 18 }, { 0x036575, 19 }, 
 { 0x006CAC, 16 }, { 0x000A69, 18 }, { 0x002934, 20 }, { 0x00526B, 21 }, 
 { 0x006CA1, 16 }, { 0x01B2B9, 18 }, { 0x0029AD, 20 }, { 0x029353, 24 }, 
 { 0x006CA7, 16 }, { 0x006CAB, 16 }, { 0x01B2BB, 18 }, { 0x00029B, 16 }, 
 { 0x00D944, 17 }, { 0x000A6A, 18 }, { 0x0149A8, 23 }, { 0x03651F, 19 }, 
 { 0x006CAF, 16 }, { 0x000A4C, 18 }, { 0x03651E, 19 }, { 0x000A48, 18 }, 
 { 0x00299C, 20 }, { 0x00299F, 20 }, { 0x029352, 24 }, { 0x0029AC, 20 }, 
 { 0x000296, 16 }, { 0x00D946, 17 }, { 0x000A68, 18 }, { 0x000298, 16 }, 
 { 0x000527, 17 }, { 0x00D94D, 17 }, { 0x0014D7, 19 }, { 0x036574, 19 }, 
 { 0x000A5C, 18 }, { 0x01B299, 18 }, { 0x00299D, 20 }, { 0x00299E, 20 }, 
 { 0x000525, 17 }, { 0x000A66, 18 }, { 0x00A4D5, 22 }, { 0x00149B, 19 }, 
 { 0x000295, 16 }, { 0x006CAD, 16 }, { 0x000A49, 18 }, { 0x000521, 17 }, 
 { 0x006CAA, 16 }, { 0x00D945, 17 }, { 0x01B298, 18 }, { 0x00052F, 17 }, 
 { 0x003654, 15 }, { 0x006CA0, 16 }, { 0x000532, 17 }, { 0x000291, 16 }, 
 { 0x003652, 15 }, { 0x000520, 17 }, { 0x000A5D, 18 }, { 0x000294, 16 }, 
 { 0x00009B, 11 }, { 0x0006E2, 12 }, { 0x000028, 12 }, { 0x0001B0, 10 }, 
 { 0x000001,  3 }, { 0x000010,  8 }, { 0x00002F,  6 }, { 0x00004C, 10 }, 
 { 0x00000D,  4 }, { 0x000000, 10 }, { 0x000006,  9 }, { 0x000134, 12 }, 
 { 0x00000C,  4 }, { 0x000007, 10 }, { 0x000007,  9 }, { 0x0006E1, 12 }, 
 { 0x00000E,  5 }, { 0x0000DA,  9 }, { 0x000022,  9 }, { 0x000364, 11 }, 
 { 0x00000F,  4 }, { 0x000006, 10 }, { 0x00000F,  9 }, { 0x000135, 12 }, 
 { 0x000014,  5 }, { 0x0000DD,  9 }, { 0x000004,  9 }, { 0x000015, 11 }, 
 { 0x00001A,  6 }, { 0x0001B3, 10 }, { 0x000005, 10 }, { 0x0006E3, 12 }, 
 { 0x00000C,  5 }, { 0x0000B9,  8 }, { 0x000004,  8 }, { 0x0000DB,  9 }, 
 { 0x00000E,  4 }, { 0x00000B, 10 }, { 0x000023,  9 }, { 0x0006CB, 12 }, 
 { 0x000005,  6 }, { 0x0001B1, 10 }, { 0x000001, 10 }, { 0x0006E0, 12 }, 
 { 0x000011,  5 }, { 0x0000DF,  9 }, { 0x00000E,  9 }, { 0x000373, 11 }, 
 { 0x000003,  5 }, { 0x0000B8,  8 }, { 0x000006,  8 }, { 0x000175,  9 }, 
 { 0x000015,  5 }, { 0x000174,  9 }, { 0x000027,  9 }, { 0x000372, 11 }, 
 { 0x000010,  5 }, { 0x0000BB,  8 }, { 0x000005,  8 }, { 0x0000DE,  9 }, 
 { 0x00000F,  5 }, { 0x000001,  9 }, { 0x000012,  8 }, { 0x000004, 10 }, 
 { 0x000002,  3 }, { 0x000016,  5 }, { 0x000009,  4 }, { 0x000001,  5 }
};

static const uint32_t s_table_mb_non_intra3[ 128 ][ 2 ] SMS_DATA_SECTION = {
 { 0x0002A1, 10 }, { 0x005740, 15 }, { 0x01A0BF, 18 }, { 0x015D19, 17 }, 
 { 0x001514, 13 }, { 0x00461E, 15 }, { 0x015176, 17 }, { 0x015177, 17 }, 
 { 0x0011AD, 13 }, { 0x00682E, 16 }, { 0x0682F9, 20 }, { 0x03417D, 19 }, 
 { 0x001A36, 14 }, { 0x002A2D, 14 }, { 0x00D05E, 17 }, { 0x006824, 16 }, 
 { 0x001515, 13 }, { 0x00545C, 15 }, { 0x0230E9, 18 }, { 0x011AFA, 17 }, 
 { 0x0015D7, 13 }, { 0x005747, 15 }, { 0x008D79, 16 }, { 0x006825, 16 }, 
 { 0x002BA2, 14 }, { 0x00A8BA, 16 }, { 0x0235F6, 18 }, { 0x015D18, 17 }, 
 { 0x0011AE, 13 }, { 0x00346F, 15 }, { 0x008C3B, 16 }, { 0x00346E, 15 }, 
 { 0x000D1A, 13 }, { 0x00461F, 15 }, { 0x0682F8, 20 }, { 0x011875, 17 }, 
 { 0x002BA1, 14 }, { 0x008D61, 16 }, { 0x0235F7, 18 }, { 0x0230E8, 18 }, 
 { 0x001513, 13 }, { 0x008D7B, 16 }, { 0x011AF4, 17 }, { 0x011AF5, 17 }, 
 { 0x001185, 13 }, { 0x0046BF, 15 }, { 0x008D60, 16 }, { 0x008D7C, 16 }, 
 { 0x001512, 13 }, { 0x00461C, 15 }, { 0x00AE8D, 16 }, { 0x008D78, 16 }, 
 { 0x000D0E, 13 }, { 0x003413, 15 }, { 0x0046B1, 15 }, { 0x003416, 15 }, 
 { 0x000AEA, 12 }, { 0x002A2C, 14 }, { 0x005741, 15 }, { 0x002A2F, 14 }, 
 { 0x000158,  9 }, { 0x0008D2, 12 }, { 0x00054C, 11 }, { 0x000686, 12 }, 
 { 0x000000,  2 }, { 0x000069,  8 }, { 0x00006B,  8 }, { 0x00068C, 12 }, 
 { 0x000007,  3 }, { 0x00015E,  9 }, { 0x0002A3, 10 }, { 0x000AE9, 12 }, 
 { 0x000006,  3 }, { 0x000231, 10 }, { 0x0002B8, 10 }, { 0x001A08, 14 }, 
 { 0x000010,  5 }, { 0x0001A9, 10 }, { 0x000342, 11 }, { 0x000A88, 12 }, 
 { 0x000004,  4 }, { 0x0001A2, 10 }, { 0x0002A4, 10 }, { 0x001184, 13 }, 
 { 0x000012,  5 }, { 0x000232, 10 }, { 0x0002B2, 10 }, { 0x000680, 12 }, 
 { 0x00001B,  6 }, { 0x00046A, 11 }, { 0x00068E, 12 }, { 0x002359, 14 }, 
 { 0x000016,  5 }, { 0x00015F,  9 }, { 0x0002A0, 10 }, { 0x00054D, 11 }, 
 { 0x000005,  4 }, { 0x000233, 10 }, { 0x0002B9, 10 }, { 0x0015D6, 13 }, 
 { 0x000022,  6 }, { 0x000468, 11 }, { 0x000683, 12 }, { 0x001A0A, 14 }, 
 { 0x000013,  5 }, { 0x000236, 10 }, { 0x0002BB, 10 }, { 0x001186, 13 }, 
 { 0x000017,  5 }, { 0x0001AB, 10 }, { 0x0002A7, 10 }, { 0x0008D3, 12 }, 
 { 0x000014,  5 }, { 0x000237, 10 }, { 0x000460, 11 }, { 0x000D0F, 13 }, 
 { 0x000019,  6 }, { 0x0001AA, 10 }, { 0x0002B3, 10 }, { 0x000681, 12 }, 
 { 0x000018,  6 }, { 0x0001A8, 10 }, { 0x0002A5, 10 }, { 0x00068F, 12 }, 
 { 0x000007,  4 }, { 0x000055,  7 }, { 0x000047,  7 }, { 0x0000AD,  8 }
};

static const uint32_t s_table_mb_non_intra4[ 128 ][ 2 ] SMS_DATA_SECTION = {
 { 0x0000D4,  8 }, { 0x0021C5, 14 }, { 0x00F18A, 16 }, { 0x00D5BC, 16 }, 
 { 0x000879, 12 }, { 0x00354D, 14 }, { 0x010E3F, 17 }, { 0x010F54, 17 }, 
 { 0x000866, 12 }, { 0x00356E, 14 }, { 0x010F55, 17 }, { 0x010E3E, 17 }, 
 { 0x0010CE, 13 }, { 0x003C84, 14 }, { 0x00D5BD, 16 }, { 0x00F18B, 16 }, 
 { 0x000868, 12 }, { 0x00438C, 15 }, { 0x0087AB, 16 }, { 0x00790B, 15 }, 
 { 0x000F10, 12 }, { 0x00433D, 15 }, { 0x006AD3, 15 }, { 0x00790A, 15 }, 
 { 0x001AA7, 13 }, { 0x0043D4, 15 }, { 0x00871E, 16 }, { 0x006ADF, 15 }, 
 { 0x000D7C, 12 }, { 0x003C94, 14 }, { 0x00438D, 15 }, { 0x006AD2, 15 }, 
 { 0x0006BC, 11 }, { 0x0021E9, 14 }, { 0x006ADA, 15 }, { 0x006A99, 15 }, 
 { 0x0010F7, 13 }, { 0x004389, 15 }, { 0x006ADB, 15 }, { 0x0078C4, 15 }, 
 { 0x000D56, 12 }, { 0x0035F7, 14 }, { 0x00438E, 15 }, { 0x006A98, 15 }, 
 { 0x000D52, 12 }, { 0x003C95, 14 }, { 0x004388, 15 }, { 0x00433C, 15 }, 
 { 0x000D54, 12 }, { 0x001E4B, 13 }, { 0x003C63, 14 }, { 0x003C83, 14 }, 
 { 0x000861, 12 }, { 0x0021EB, 14 }, { 0x00356C, 14 }, { 0x0035F6, 14 }, 
 { 0x000863, 12 }, { 0x00219F, 14 }, { 0x003568, 14 }, { 0x003C82, 14 }, 
 { 0x0001AE,  9 }, { 0x0010C0, 13 }, { 0x000F11, 12 }, { 0x001AFA, 13 }, 
 { 0x000000,  1 }, { 0x0000F0,  8 }, { 0x0001AD,  9 }, { 0x0010C1, 13 }, 
 { 0x00000A,  4 }, { 0x0003C5, 10 }, { 0x000789, 11 }, { 0x001AB5, 13 }, 
 { 0x000009,  4 }, { 0x000435, 11 }, { 0x000793, 11 }, { 0x001E40, 13 }, 
 { 0x00001D,  5 }, { 0x0003CB, 10 }, { 0x000878, 12 }, { 0x001AAF, 13 }, 
 { 0x00000B,  4 }, { 0x0003C7, 10 }, { 0x000791, 11 }, { 0x001AAB, 13 }, 
 { 0x00001F,  5 }, { 0x000436, 11 }, { 0x0006BF, 11 }, { 0x000F19, 12 }, 
 { 0x00003D,  6 }, { 0x000D51, 12 }, { 0x0010C4, 13 }, { 0x0021E8, 14 }, 
 { 0x000036,  6 }, { 0x000437, 11 }, { 0x0006AF, 11 }, { 0x0010C5, 13 }, 
 { 0x00000C,  4 }, { 0x000432, 11 }, { 0x000794, 11 }, { 0x001E30, 13 }, 
 { 0x000042,  7 }, { 0x000870, 12 }, { 0x000F24, 12 }, { 0x001E43, 13 }, 
 { 0x000020,  6 }, { 0x00043E, 11 }, { 0x000795, 11 }, { 0x001AAA, 13 }, 
 { 0x000037,  6 }, { 0x0006AC, 11 }, { 0x0006AE, 11 }, { 0x0010F6, 13 }, 
 { 0x000034,  6 }, { 0x00043A, 11 }, { 0x000D50, 12 }, { 0x001AAE, 13 }, 
 { 0x000039,  6 }, { 0x00043F, 11 }, { 0x00078D, 11 }, { 0x0010D2, 13 }, 
 { 0x000038,  6 }, { 0x00043B, 11 }, { 0x0006BD, 11 }, { 0x0010D3, 13 }, 
 { 0x000011,  5 }, { 0x0001AC,  9 }, { 0x0000F3,  8 }, { 0x000439, 11 }
};

static const uint32_t ( *s_wmv2_inter_table[ 4 ] )[ 2 ] = {
 s_table_mb_non_intra2, s_table_mb_non_intra3,
 s_table_mb_non_intra4, s_table_mb_non_intra,
};

static uint32_t s_v2_dc_lum_table   [ 512 ][ 2 ];
static uint32_t s_v2_dc_chroma_table[ 512 ][ 2 ];

static SMS_VLC s_dc_lum_vlc   [ 2 ];
static SMS_VLC s_dc_chroma_vlc[ 2 ];
static SMS_VLC s_v2_dc_lum_vlc;
static SMS_VLC s_v2_dc_chroma_vlc;
static SMS_VLC s_cbpy_vlc;
static SMS_VLC s_v2_intra_cbpc_vlc;
static SMS_VLC s_v2_mb_type_vlc;
static SMS_VLC s_v2_mv_vlc;
static SMS_VLC s_mb_intra_vlc;
static SMS_VLC s_v1_intra_cbpc_vlc;
static SMS_VLC s_v1_inter_cbpc_vlc;
static SMS_VLC s_inter_intra_vlc;
static SMS_VLC s_mb_non_intra_vlc[ 4 ];

static int32_t MSMPEG4_Init    ( SMS_CodecContext*                                   );
static int32_t MSMPEG4_Decode  ( SMS_CodecContext*, SMS_RingBuffer*, SMS_RingBuffer* );
static void    MSMPEG4_Destroy ( SMS_CodecContext*                                   );

static int _msmpeg4_decode_mb ( SMS_DCTELEM[ 6 ][ 64 ] );

void SMS_Codec_MSMPEG4_Open ( SMS_CodecContext* apCtx ) {

 apCtx -> m_pCodec = calloc (  1, sizeof ( SMS_Codec )  );

 apCtx -> m_pCodec -> m_pName = "msmpeg4";
 apCtx -> m_pCodec -> Init    = MSMPEG4_Init;
 apCtx -> m_pCodec -> Decode  = MSMPEG4_Decode;
 apCtx -> m_pCodec -> Destroy = MSMPEG4_Destroy;

}  /* end SMS_Codec_MSMPEG4_Open */

static int32_t MSMPEG4_Init ( SMS_CodecContext* apCtx ) {

 if ( !s_Init ) {

  int lLevel, lUniCode, lUniLen;

  for ( lLevel = -256; lLevel < 256; ++lLevel ) {

   int lL;
   int lSize = 0;
   int lV    = abs ( lLevel );

   while ( lV ) {

    lV >>= 1;
    ++lSize;

   }  /* end while */

   lL = lLevel < 0 ? ( -lLevel ) ^ (  ( 1 << lSize ) - 1  ) : lLevel;

   lUniCode  = g_DCtab_lum[ lSize ][ 0 ];
   lUniLen   = g_DCtab_lum[ lSize ][ 1 ];
   lUniCode ^= ( 1 << lUniLen ) - 1;

   if ( lSize > 0 ) {

    lUniCode <<= lSize;
    lUniCode  |= lL;
    lUniLen   += lSize;

    if ( lSize > 8 ) {

     lUniCode <<= 1;
     lUniCode  |= 1;
     ++lUniLen;

    }  /* end if */

   }  /* end if */

   s_v2_dc_lum_table[ lLevel + 256 ][ 0 ] = lUniCode;
   s_v2_dc_lum_table[ lLevel + 256 ][ 1 ] = lUniLen;

   lUniCode  = g_DCtab_chrom[ lSize ][ 0 ];
   lUniLen   = g_DCtab_chrom[ lSize ][ 1 ];
   lUniCode ^= ( 1 << lUniLen ) - 1;
            
   if ( lSize > 0 ) {

    lUniCode <<= lSize;
    lUniCode  |= lL;
    lUniLen   += lSize;

    if ( lSize > 8 ) {

     lUniCode <<= 1;
     lUniCode  |= 1;
     ++lUniLen;

    }  /* end if */

   }  /* end if */

   s_v2_dc_chroma_table[ lLevel + 256 ][ 0 ] = lUniCode;
   s_v2_dc_chroma_table[ lLevel + 256 ][ 1 ] = lUniLen;

  }  /* end for */

  for ( lLevel = 0; lLevel < NB_RL_TABLES; ++lLevel ) {

   SMS_RL_Init     ( &s_rl_table[ lLevel ] );
   SMS_VLC_RL_Init ( &s_rl_table[ lLevel ] );

  }  /* end for */

  for ( lLevel = 0; lLevel < 2; ++lLevel ) {

   MVTable* lpMV = &s_mv_tables[ lLevel ];

   SMS_VLC_Init (
    &lpMV -> m_VLC, MV_VLC_BITS, lpMV -> m_N + 1, 
     lpMV -> m_pTblMVBits, 1, 1,
     lpMV -> m_pTblMVCode, 2, 2
   );

  }  /* end for */

  SMS_VLC_Init (
   &s_dc_lum_vlc[ 0 ], DC_VLC_BITS, 120, 
   &s_table0_dc_lum[ 0 ][ 1 ], 8, 4,
   &s_table0_dc_lum[ 0 ][ 0 ], 8, 4
  );
  SMS_VLC_Init (
   &s_dc_chroma_vlc[ 0 ], DC_VLC_BITS, 120, 
   &s_table0_dc_chroma[ 0 ][ 1 ], 8, 4,
   &s_table0_dc_chroma[ 0 ][ 0 ], 8, 4
  );
  SMS_VLC_Init (
   &s_dc_lum_vlc[ 1 ], DC_VLC_BITS, 120, 
   &s_table1_dc_lum[ 0 ][ 1 ], 8, 4,
   &s_table1_dc_lum[ 0 ][ 0 ], 8, 4
  );
  SMS_VLC_Init (
   &s_dc_chroma_vlc[ 1 ], DC_VLC_BITS, 120, 
   &s_table1_dc_chroma[ 0 ][ 1 ], 8, 4,
   &s_table1_dc_chroma[ 0 ][ 0 ], 8, 4
  );
  SMS_VLC_Init (
   &s_v2_dc_lum_vlc, DC_VLC_BITS, 512, 
   &s_v2_dc_lum_table[ 0 ][ 1 ], 8, 4,
   &s_v2_dc_lum_table[ 0 ][ 0 ], 8, 4
  );
  SMS_VLC_Init (
   &s_v2_dc_chroma_vlc, DC_VLC_BITS, 512, 
   &s_v2_dc_chroma_table[ 0 ][ 1 ], 8, 4,
   &s_v2_dc_chroma_table[ 0 ][ 0 ], 8, 4
  );
  SMS_VLC_Init (
   &s_cbpy_vlc, CBPY_VLC_BITS, 16,
   &g_cbpy_tab[ 0 ][ 1 ], 2, 1,
   &g_cbpy_tab[ 0 ][ 0 ], 2, 1
  );
  SMS_VLC_Init (
   &s_v2_intra_cbpc_vlc, V2_INTRA_CBPC_VLC_BITS, 4,
   &s_v2_intra_cbpc[ 0 ][ 1 ], 2, 1,
   &s_v2_intra_cbpc[ 0 ][ 0 ], 2, 1
  );
  SMS_VLC_Init (
   &s_v2_mb_type_vlc, V2_MB_TYPE_VLC_BITS, 8,
   &s_v2_mb_type[ 0 ][ 1 ], 2, 1,
   &s_v2_mb_type[ 0 ][ 0 ], 2, 1
  );
  SMS_VLC_Init (
   &s_v2_mv_vlc, V2_MV_VLC_BITS, 33,
   &g_mvtab[ 0 ][ 1 ], 2, 1,
   &g_mvtab[ 0 ][ 0 ], 2, 1
  );
  SMS_VLC_Init (
   &s_mb_intra_vlc, MB_INTRA_VLC_BITS, 64, 
   &s_table_mb_intra[ 0 ][ 1 ], 4, 2,
   &s_table_mb_intra[ 0 ][ 0 ], 4, 2
  );
  SMS_VLC_Init (
   &s_v1_intra_cbpc_vlc, V1_INTRA_CBPC_VLC_BITS, 8, 
   g_IntraMCBPC_bits, 1, 1,
   g_IntraMCBPC_code, 1, 1
  );
  SMS_VLC_Init (
   &s_v1_inter_cbpc_vlc, V1_INTER_CBPC_VLC_BITS, 25, 
   g_InterMCBPC_bits, 1, 1,
   g_InterMCBPC_code, 1, 1
  );
  SMS_VLC_Init (
   &s_inter_intra_vlc, INTER_INTRA_VLC_BITS, 4, 
   &s_table_inter_intra[ 0 ][ 1 ], 2, 1,
   &s_table_inter_intra[ 0 ][ 0 ], 2, 1
  );

  for ( lLevel = 0; lLevel < 4; ++lLevel )

   SMS_VLC_Init (
    &s_mb_non_intra_vlc[ lLevel ], MB_NON_INTRA_VLC_BITS, 128, 
    &s_wmv2_inter_table[ lLevel ][ 0 ][ 1 ], 8, 4,
    &s_wmv2_inter_table[ lLevel ][ 0 ][ 0 ], 8, 4
   );

  SMS_MPEGContext_Init ( apCtx -> m_Width, apCtx -> m_Height );

  MPEG4_CommonInit ( apCtx );

 }  /* end if */

 SMS_MPEG_InitScanTable ( &g_MPEGCtx.m_InterScanTbl,  g_SMS_DSP_zigzag_direct             );
 SMS_MPEG_InitScanTable ( &g_MPEGCtx.m_IntraScanTbl,  g_SMS_DSP_zigzag_direct             );
 SMS_MPEG_InitScanTable ( &g_MPEGCtx.m_IntraHScanTbl, g_SMS_DSP_alternate_horizontal_scan );
 SMS_MPEG_InitScanTable ( &g_MPEGCtx.m_IntraVScanTbl, g_SMS_DSP_alternate_vertical_scan   );

 BASECTX().m_pY_DCScaleTbl = s_y_dc_scale_table;
 BASECTX().m_pC_DCScaleTbl = s_c_dc_scale_table;
 BASECTX().DecodeMB        = _msmpeg4_decode_mb;

 BASECTX().m_pCodedBlockBase = calloc (
  1, BASECTX().m_B8Stride * (  2 * BASECTX().m_MBH + 1  )
 );
 BASECTX().m_pCodedBlock     = g_MPEGCtx.m_pCodedBlockBase + g_MPEGCtx.m_B8Stride + 1;

 ++s_Init;

 return 1;

}  /* end MSMPEG4_Init */

static void MSMPEG4_Destroy ( SMS_CodecContext* apCtx ) {

 if ( s_Init && !--s_Init ) {

  int i;

  for ( i = 0; i < NB_RL_TABLES; ++i ) {

   SMS_RL_Free     ( &s_rl_table[ i ] );
   SMS_VLC_RL_Free ( &s_rl_table[ i ] );

  }  /* end for */

  for ( i = 0; i < 2; ++i ) SMS_VLC_Free ( &s_mv_tables[ i ].m_VLC );

  SMS_VLC_Free ( &s_dc_lum_vlc   [ 0 ] );
  SMS_VLC_Free ( &s_dc_chroma_vlc[ 0 ] );
  SMS_VLC_Free ( &s_dc_lum_vlc   [ 1 ] );
  SMS_VLC_Free ( &s_dc_chroma_vlc[ 1 ] );
  SMS_VLC_Free ( &s_v2_dc_lum_vlc      );
  SMS_VLC_Free ( &s_v2_dc_chroma_vlc   );
  SMS_VLC_Free ( &s_cbpy_vlc           );
  SMS_VLC_Free ( &s_v2_intra_cbpc_vlc  );
  SMS_VLC_Free ( &s_v2_mb_type_vlc     );
  SMS_VLC_Free ( &s_v2_mv_vlc          );
  SMS_VLC_Free ( &s_mb_intra_vlc       );
  SMS_VLC_Free ( &s_v1_intra_cbpc_vlc  );
  SMS_VLC_Free ( &s_v1_inter_cbpc_vlc  );
  SMS_VLC_Free ( &s_inter_intra_vlc    );

  for ( i = 0; i < 4; ++i ) SMS_VLC_Free ( &s_mb_non_intra_vlc[ i ] );

  SMS_MPEGContext_Destroy ();
  MPEG4_CommonDestroy     ();

  free (  BASECTX().m_pCodedBlockBase  );

 }  /* end if */

}  /* end MSMPEG4_Destroy */

static SMS_INLINE int _msmpeg4_pred_dc (
                       int aN, uint16_t** appDCVal, int* apDir
                      ) {

 int      lA, lB, lC, lWrap, lPred, lScale;
 int16_t* lpDCVal;

 lScale  = aN < 4 ? g_MPEGCtx.m_Y_DCScale : g_MPEGCtx.m_C_DCScale;
 lWrap   = g_MPEGCtx.m_BlockWrap[ aN ];
 lpDCVal = g_MPEGCtx.m_pDCVal[ 0 ] + g_MPEGCtx.m_BlockIdx[ aN ];

 lA = lpDCVal[ -1         ];
 lB = lpDCVal[ -1 - lWrap ];
 lC = lpDCVal[    - lWrap ];
    
 if (  g_MPEGCtx.m_FirstSliceLine && !( aN & 2 )  ) lB = lC = 1024;

 if ( lScale == 8 ) {

  lA = (  lA + ( 8 >> 1 )  ) / 8;
  lB = (  lB + ( 8 >> 1 )  ) / 8;
  lC = (  lC + ( 8 >> 1 )  ) / 8;

 } else {

  lA = SMS_FASTDIV(   (  lA + ( lScale >> 1 )  ), lScale   );
  lB = SMS_FASTDIV(   (  lB + ( lScale >> 1 )  ), lScale   );
  lC = SMS_FASTDIV(   (  lC + ( lScale >> 1 )  ), lScale   );

 }  /* end else */

 if (  abs ( lA - lB ) <= abs ( lB - lC )  ) {

  lPred  = lC;
  *apDir = 1;

 } else {

  lPred  = lA;
  *apDir = 0;

 }  /* end else */

 *appDCVal = &lpDCVal[ 0 ];

 return lPred;

}  /* end _msmpeg4_pred_dc */

static int _msmpeg4_decode_dc ( int aN, int* apDir ) {

 int             lLevel, lPred;
 SMS_BitContext* lpBitCtx = &g_MPEGCtx.m_BitCtx;
 uint16_t*       lpDCVal;

 lLevel = aN < 4 ? SMS_GetVLC2 ( lpBitCtx, s_dc_lum_vlc   [ g_MPEGCtx.m_DCTblIdx ].m_pTable, DC_VLC_BITS, 3 )
                 : SMS_GetVLC2 ( lpBitCtx, s_dc_chroma_vlc[ g_MPEGCtx.m_DCTblIdx ].m_pTable, DC_VLC_BITS, 3 );

 if ( lLevel < 0 ) return -1;

 if ( lLevel == DC_MAX ) {

  lLevel = SMS_GetBits ( lpBitCtx, 8 );

  if (  SMS_GetBit ( lpBitCtx )  ) lLevel = -lLevel;

 } else if ( lLevel ) {

  if (  SMS_GetBit ( lpBitCtx )  ) lLevel = -lLevel;

 }  /* end if */

 lPred   = _msmpeg4_pred_dc ( aN, &lpDCVal, apDir );
 lLevel += lPred;

 *lpDCVal = aN < 4 ? lLevel * g_MPEGCtx.m_Y_DCScale
                   : lLevel * g_MPEGCtx.m_C_DCScale;
 return lLevel;

}  /* end _msmpeg4_decode_dc */

static int _msmpeg4_decode_motion ( int* apMX, int* apMY ) {

 MVTable*        lpMV;
 int             lCode, lMX, lMY;
 SMS_BitContext* lpBitCtx = &g_MPEGCtx.m_BitCtx;

 lpMV  = &s_mv_tables[ g_MPEGCtx.m_MVTblIdx ];
 lCode = SMS_GetVLC2 ( lpBitCtx, lpMV -> m_VLC.m_pTable, MV_VLC_BITS, 2 );

 if ( lCode < 0 ) return -1;

 if ( lCode == lpMV -> m_N ) {

  lMX = SMS_GetBits ( lpBitCtx, 6 );
  lMY = SMS_GetBits ( lpBitCtx, 6 );

 } else {

  lMX = lpMV -> m_pTblMVX[ lCode ];
  lMY = lpMV -> m_pTblMVY[ lCode ];

 }  /* end else */

 lMX += *apMX - 32;
 lMY += *apMY - 32;

 if ( lMX <= -64 )

  lMX += 64;

 else if ( lMX >= 64 ) lMX -= 64;

 if ( lMY <= -64 )

  lMY += 64;

 else if ( lMY >= 64) lMY -= 64;

 *apMX = lMX;
 *apMY = lMY;

 return 0;

}  /* end _msmpeg4_decode_motion */

static SMS_INLINE int _msmpeg4_decode_block (
                       SMS_DCTELEM* apBlock, int aN, int aCoded, const uint8_t* apScanTbl
                      ) {

 int              i, lLevel, lLast, lRun, lRunDiff;
 int              lDCPredDir;
 int              lQMul, lQAdd;
 SMS_RLTable*     lpRL;
 SMS_RL_VLC_ELEM* lpRLVLC;

 if ( g_MPEGCtx.m_MBIntra ) {

  lQMul  = 1;
  lQAdd  = 0;
  lLevel = _msmpeg4_decode_dc ( aN, &lDCPredDir );
        
  if ( lLevel < 0 ) {

   if ( g_MPEGCtx.m_InterIntraPred )

    lLevel = 0;

   else return -1;

  }  /* end if */

  if ( aN < 4 ) {

   lpRL = &s_rl_table[ g_MPEGCtx.m_RLTblIdx ];

   if ( lLevel > 256 * g_MPEGCtx.m_Y_DCScale ) {

    if ( !g_MPEGCtx.m_InterIntraPred ) return -1;

   }  /* end if */

  } else {

   lpRL = &s_rl_table[ 3 + g_MPEGCtx.m_RLChromaTblIdx ];

   if ( lLevel > 256 * g_MPEGCtx.m_C_DCScale ) {

    if ( !g_MPEGCtx.m_InterIntraPred ) return -1;

   }  /* end if */

  }  /* end else */

  apBlock[ 0 ] = lLevel;
  lRunDiff     = 0;
  i            = 0;

  if ( ! aCoded ) goto not_coded;

  if ( g_MPEGCtx.m_ACPred )

   apScanTbl = !lDCPredDir ? g_MPEGCtx.m_IntraVScanTbl.m_pScantable
                           : g_MPEGCtx.m_IntraHScanTbl.m_pScantable;

  else apScanTbl = g_MPEGCtx.m_IntraScanTbl.m_pScantable;

  lpRLVLC = lpRL ->m_pRLVLC[ 0 ];

 } else {

  lQMul    = g_MPEGCtx.m_QScale << 1;
  lQAdd    = ( g_MPEGCtx.m_QScale - 1 ) | 1;
  i        = -1;
  lpRL     = &s_rl_table[ 3 + g_MPEGCtx.m_RLTblIdx ];
  lRunDiff = 1;

  if ( ! aCoded ) {

   g_MPEGCtx.m_BlockLastIdx[ aN ] = i;
   return 0;

  }  /* end if */

  if ( !apScanTbl ) apScanTbl = g_MPEGCtx.m_InterScanTbl.m_pScantable;

  lpRLVLC = lpRL -> m_pRLVLC[ g_MPEGCtx.m_QScale ];

 }  /* end else */

 {  /* begin block */

  SMS_BitContext* lpBitCtx = &g_MPEGCtx.m_BitCtx;

  SMS_OPEN_READER( re, lpBitCtx );

  for ( ;; ) {

   SMS_UPDATE_CACHE( re, lpBitCtx );
   SMS_GET_RL_VLC( lLevel, lRun, re, lpBitCtx, lpRLVLC, TEX_VLC_BITS, 2 );

   if ( !lLevel ) {

    int lCache = SMS_GET_CACHE( re, lpBitCtx );

    if (  !( lCache & 0x80000000 )  ) {

     if (  !( lCache & 0x40000000 )  ) {

      SMS_LAST_SKIP_BITS( re, lpBitCtx, 2);
      SMS_UPDATE_CACHE( re, lpBitCtx );

      lLast  = SMS_SHOW_UBITS( re, lpBitCtx, 1 ); SMS_SKIP_CACHE( re, 1 );
      lRun   = SMS_SHOW_UBITS( re, lpBitCtx, 6 ); SMS_SKIP_CACHE( re, 6 );
      lLevel = SMS_SHOW_SBITS( re, lpBitCtx, 8 ); SMS_LAST_SKIP_CACHE( re, lpBitCtx, 8 );

      SMS_SKIP_COUNTER( re, 1 + 6 + 8 );

      if ( lLevel > 0 )

       lLevel = lLevel * lQMul + lQAdd;

      else lLevel= lLevel * lQMul - lQAdd;

      i += lRun + 1;

      if ( lLast ) i += 192;

     } else {

      SMS_SKIP_BITS( re, lpBitCtx, 2 );
      SMS_GET_RL_VLC( lLevel, lRun, re, lpBitCtx, lpRLVLC, TEX_VLC_BITS, 2 );

      i     += lRun + lpRL -> m_pMaxRun[ lRun >> 7 ][ lLevel / lQMul ] + lRunDiff;
      lLevel = (  lLevel ^ SMS_SHOW_SBITS( re, lpBitCtx, 1 )  ) - SMS_SHOW_SBITS( re, lpBitCtx, 1 );

      SMS_LAST_SKIP_BITS( re, lpBitCtx, 1 );

     }  /* end else */

    } else {

     SMS_SKIP_BITS( re, lpBitCtx, 1 );
     SMS_GET_RL_VLC( lLevel, lRun, re, lpBitCtx, lpRLVLC, TEX_VLC_BITS, 2 );

     i     += lRun;
     lLevel = lLevel + lpRL -> m_pMaxLevel[ lRun >> 7 ][ ( lRun - 1 ) &63 ] * lQMul;
     lLevel = (  lLevel ^ SMS_SHOW_SBITS(re, lpBitCtx, 1 )  ) - SMS_SHOW_SBITS( re, lpBitCtx, 1 );

     SMS_LAST_SKIP_BITS( re, lpBitCtx, 1 );

    }  /* end else */

   } else {

    i     += lRun;
    lLevel = (  lLevel ^ SMS_SHOW_SBITS( re, lpBitCtx, 1 )  ) - SMS_SHOW_SBITS( re, lpBitCtx, 1 );

    SMS_LAST_SKIP_BITS(re, &s->gb, 1);

   }  /* end else */

   if ( i > 62 ) {

    i -= 192;

    if (  i & ( ~63 )  ) {

     const int lLeft = lpBitCtx -> m_szInBits  - SMS_BitCount ( lpBitCtx );

     if (   (  i + 192 == 64 && lLevel / lQMul == -1 ) && lLeft >= 0  )

      break;

     else return -1;

    }  /* end if */

    apBlock[  apScanTbl[ i ]  ] = lLevel;

    break;

   }  /* end if */

   apBlock[  apScanTbl[ i ]  ] = lLevel;

  }  /* end for */

  SMS_CLOSE_READER( re, lpBitCtx );

 }  /* end block */
not_coded:
 if ( g_MPEGCtx.m_MBIntra ) {

  MPEG4_PredAC ( apBlock, aN, lDCPredDir );

  if ( g_MPEGCtx.m_ACPred ) i = 63;

 }  /* end if */

 g_MPEGCtx.m_BlockLastIdx[ aN ] = i;

 return 0;

}  /* end _msmpeg4_decode_block */

static SMS_INLINE int _msmpeg4_coded_block_pred ( int aN, uint8_t** appCodedBlock ) {

 int lXY, lWrap, lPred, lA, lB, lC;

 lXY   = g_MPEGCtx.m_BlockIdx[ aN ];
 lWrap = g_MPEGCtx.m_B8Stride;

 lA = g_MPEGCtx.m_pCodedBlock[ lXY - 1         ];
 lB = g_MPEGCtx.m_pCodedBlock[ lXY - 1 - lWrap ];
 lC = g_MPEGCtx.m_pCodedBlock[ lXY     - lWrap ];

 lPred          = lB == lC ? lA : lC;
 *appCodedBlock = &g_MPEGCtx.m_pCodedBlock[ lXY ];
 
 return lPred;

}  /* end _msmpeg4_coded_block_pred */

static int _msmpeg4_decode012 ( SMS_BitContext* apCtx ) {

 return !SMS_GetBit ( apCtx ) ? 0 : SMS_GetBit ( apCtx ) + 1;

}  /* end _msmpeg4_decode012 */

static int _msmpeg4_decode_mb ( SMS_DCTELEM aBlock[ 6 ][ 64 ] ) {

 int      i,     lCBP, lCode;
 uint8_t*        lpCodedVal;
 uint32_t* const lpMBType = &g_MPEGCtx.m_CurPic.m_pMBType[
  g_MPEGCtx.m_MBX  + g_MPEGCtx.m_MBY * g_MPEGCtx.m_MBStride
 ];
 SMS_BitContext* lpBitCtx = &g_MPEGCtx.m_BitCtx;

 IDCT_ClrBlocks ();

 if ( g_MPEGCtx.m_PicType == SMS_FT_P_TYPE ) {

  if ( g_MPEGCtx.m_UseSkipMBCode ) {

   if (  SMS_GetBit ( lpBitCtx )  ) {

    g_MPEGCtx.m_MBIntra = 0;

    for ( i = 0; i < 6; ++i ) g_MPEGCtx.m_BlockLastIdx[ i ] = -1;

    g_MPEGCtx.m_MVDir  = SMS_MV_DIR_FORWARD;
    g_MPEGCtx.m_MVType = SMS_MV_TYPE_16X16;

    g_MPEGCtx.m_MV[ 0 ][ 0 ][ 0 ] = 0;
    g_MPEGCtx.m_MV[ 0 ][ 0 ][ 1 ] = 0;

    g_MPEGCtx.m_MBSkiped = 1;
    *lpMBType            = SMS_MB_TYPE_SKIP | SMS_MB_TYPE_L0 | SMS_MB_TYPE_16x16;

    return 0;

   }  /* end if */

  }  /* end if */
        
  lCode = SMS_GetVLC2 ( lpBitCtx, s_mb_non_intra_vlc[ DEFAULT_INTER_INDEX ].m_pTable, MB_NON_INTRA_VLC_BITS, 3 );

  if ( lCode < 0 ) return -1;

  g_MPEGCtx.m_MBIntra = ( ~lCode & 0x40 ) >> 6;
  lCBP                = lCode & 0x3F;

 } else {

  g_MPEGCtx.m_MBIntra = 1;
  lCode               = SMS_GetVLC2 ( lpBitCtx, s_mb_intra_vlc.m_pTable, MB_INTRA_VLC_BITS, 2 );

  if ( lCode < 0 ) return -1;

  lCBP = 0;

  for ( i = 0; i < 6; ++i ) {

   int lVal = (   (  lCode >> ( 5 - i )  ) & 1   );

   if ( i < 4 ) {

    int lPred = _msmpeg4_coded_block_pred ( i, &lpCodedVal );

    lVal ^= lPred;
    *lpCodedVal = lVal;

   }  /* end if */

   lCBP |= lVal << ( 5 - i );

  }  /* end for */

 }  /* end else */

 if ( !g_MPEGCtx.m_MBIntra ) {

  int lMX, lMY;

  if ( g_MPEGCtx.m_PerMBRLTbl && lCBP ) {

   g_MPEGCtx.m_RLTblIdx       = _msmpeg4_decode012 ( lpBitCtx );
   g_MPEGCtx.m_RLChromaTblIdx = g_MPEGCtx.m_RLTblIdx;

  }  /* end if */

  SMS_H263_PredMotion ( 0, 0, &lMX, &lMY );

  if (  _msmpeg4_decode_motion ( &lMX, &lMY ) < 0  ) return -1;

  g_MPEGCtx.m_MVDir  = SMS_MV_DIR_FORWARD;
  g_MPEGCtx.m_MVType = SMS_MV_TYPE_16X16;

  g_MPEGCtx.m_MV[ 0 ][ 0 ][ 0 ] = lMX;
  g_MPEGCtx.m_MV[ 0 ][ 0 ][ 1 ] = lMY;

  *lpMBType = SMS_MB_TYPE_L0 | SMS_MB_TYPE_16x16;

 } else {

  g_MPEGCtx.m_ACPred = SMS_GetBit ( lpBitCtx );
  *lpMBType          = SMS_MB_TYPE_INTRA;

  if ( g_MPEGCtx.m_InterIntraPred )

   g_MPEGCtx.m_H263AICDir = SMS_GetVLC2 (
    lpBitCtx, s_inter_intra_vlc.m_pTable, INTER_INTRA_VLC_BITS, 1
   );

  if ( g_MPEGCtx.m_PerMBRLTbl && lCBP ) {

   g_MPEGCtx.m_RLTblIdx       = _msmpeg4_decode012 ( lpBitCtx );
   g_MPEGCtx.m_RLChromaTblIdx = g_MPEGCtx.m_RLTblIdx;

  }  /* end if */

 }  /* end else */

 for ( i = 0; i < 6; ++i )

  if (  _msmpeg4_decode_block (
          aBlock[ i ], i, (  lCBP >> ( 5 - i )  ) & 1, NULL
         ) < 0
  ) return -1;

 return 0;

}  /* end _msmpeg4_decode_mb */

static int _msmpeg4_decode_picture_header ( void ) {

 int             lCode;
 SMS_BitContext* lpBitCtx = &g_MPEGCtx.m_BitCtx;

 g_MPEGCtx.m_PicType = SMS_GetBits ( lpBitCtx, 2 ) + 1;

 if ( g_MPEGCtx.m_PicType != SMS_FT_I_TYPE &&
      g_MPEGCtx.m_PicType != SMS_FT_P_TYPE
 ) return 1;

 g_MPEGCtx.m_ChromaQScale =
 g_MPEGCtx.m_QScale       = SMS_GetBits ( lpBitCtx, 5 );

 if ( !g_MPEGCtx.m_QScale ) return -1;

 if ( g_MPEGCtx.m_PicType == SMS_FT_I_TYPE ) {

  lCode = SMS_GetBits ( lpBitCtx, 5 );

  if ( lCode < 0x17 ) return -1;

  g_MPEGCtx.m_SliceHeight = g_MPEGCtx.m_MBH / ( lCode - 0x16 );

  g_MPEGCtx.m_RLChromaTblIdx = _msmpeg4_decode012 ( lpBitCtx );
  g_MPEGCtx.m_RLTblIdx       = _msmpeg4_decode012 ( lpBitCtx );
  g_MPEGCtx.m_DCTblIdx       = SMS_GetBit ( lpBitCtx );
  g_MPEGCtx.m_NoRounding     = 1;

 } else {

  g_MPEGCtx.m_UseSkipMBCode  = SMS_GetBit ( lpBitCtx );
  g_MPEGCtx.m_RLTblIdx       = _msmpeg4_decode012 ( lpBitCtx );
  g_MPEGCtx.m_RLChromaTblIdx = g_MPEGCtx.m_RLTblIdx;
  g_MPEGCtx.m_DCTblIdx       = SMS_GetBit ( lpBitCtx );
  g_MPEGCtx.m_MVTblIdx       = SMS_GetBit ( lpBitCtx );

  if ( g_MPEGCtx.m_FlipFlopRnd )

   g_MPEGCtx.m_NoRounding ^= 1;

  else g_MPEGCtx.m_NoRounding = 0;

 }  /* end else */

 return 0;

}  /* end _msmpeg4_decode_picture_header */

static int _msmpeg4_decode_ext_header ( int aBufSize ) {

 SMS_BitContext* lpBitCtx = &g_MPEGCtx.m_BitCtx;
 int             lLeft    = aBufSize * 8 - SMS_BitCount ( lpBitCtx );
 int             lLength  = 17;

 if ( lLeft >= lLength && lLeft < lLength + 8 ) {

  SMS_GetBits ( lpBitCtx, 5 );

  g_MPEGCtx.m_BitRate     = SMS_GetBits ( lpBitCtx, 11 ) * 1024;
  g_MPEGCtx.m_FlipFlopRnd = SMS_GetBit ( lpBitCtx );

 } else if ( lLeft < lLength + 8 ) g_MPEGCtx.m_FlipFlopRnd = 0;

 return 0;

}  /* end _msmpeg4_decode_ext_header */

static void _msmpeg4_decode_slice ( void ) {

 g_MPEGCtx.m_FirstSliceLine = 1;
 g_MPEGCtx.m_ResyncMBX      = g_MPEGCtx.m_MBX;
 g_MPEGCtx.m_ResyncMBY      = g_MPEGCtx.m_MBY;

 SMS_MPEG_SetQScale ( g_MPEGCtx.m_QScale );

 g_MPEGCtx.MBCallback = SMS_MPEG_DummyCB;

 for ( ; g_MPEGCtx.m_MBY < g_MPEGCtx.m_MBH; ++g_MPEGCtx.m_MBY ) {

  if ( g_MPEGCtx.m_ResyncMBY + g_MPEGCtx.m_SliceHeight == g_MPEGCtx.m_MBY ) return;

  SMS_MPEG_InitBlockIdx ();

  for ( ; g_MPEGCtx.m_MBX < g_MPEGCtx.m_MBW; ++g_MPEGCtx.m_MBX ) {

   int lRet;

   SMS_MPEG_UpdateBlockIdx ();

   if ( g_MPEGCtx.m_ResyncMBX     == g_MPEGCtx.m_MBX &&
        g_MPEGCtx.m_ResyncMBY + 1 == g_MPEGCtx.m_MBY
   ) g_MPEGCtx.m_FirstSliceLine = 0;

   g_MPEGCtx.m_MVDir  = SMS_MV_DIR_FORWARD;
   g_MPEGCtx.m_MVType = SMS_MV_TYPE_16X16;

   lRet = g_MPEGCtx.DecodeMB ( g_MPEGCtx.m_pBlock );

   if ( g_MPEGCtx.m_PicType != SMS_FT_B_TYPE ) SMS_H263_UpdateMotionVal ();

   if ( lRet < 0 ) {

    if ( lRet == SMS_SLICE_END ) {

     SMS_MPEG_DecodeMB ( g_MPEGCtx.m_pBlock );

     --g_MPEGCtx.m_PaddingBugScore;
                        
     if ( ++g_MPEGCtx.m_MBX >= g_MPEGCtx.m_MBW ) {

        g_MPEGCtx.m_MBX = 0;
      ++g_MPEGCtx.m_MBY;

     }  /* end if */

     goto end;

    } else if ( lRet == SMS_SLICE_NOEND ) goto end;

    goto end;

   }  /* end if */

   SMS_MPEG_DecodeMB ( g_MPEGCtx.m_pBlock );

  }  /* end for */

  g_MPEGCtx.m_MBX = 0;

 }  /* end for */

 if ( g_MPEGCtx.m_Bugs & SMS_BUG_NO_PADDING ) {

  int lLeft     = g_MPEGCtx.m_BitCtx.m_szInBits - SMS_BitCount ( &g_MPEGCtx.m_BitCtx );
  int lMaxExtra = 7;

  if ( g_MPEGCtx.m_PicType == SMS_FT_I_TYPE ) lMaxExtra += 17;
        
  lMaxExtra += 256 * 256 * 256 * 64;
        
  if ( lLeft < lMaxExtra && lLeft > 0 ) goto end;

 }  /* end if */
end:
 DMA_Wait ( DMAC_VIF0 );

 while (   (  *( volatile unsigned int* )0x10003800  ) & 3   );

 g_MPEGCtx.MBCallback ( g_MPEGCtx.m_pDestCB );

}  /* end _msmpeg4_decode_slice */

static int32_t MSMPEG4_Decode ( SMS_CodecContext* apCtx, SMS_RingBuffer* apOutput, SMS_RingBuffer* apInput ) {

 uint8_t*         lpBuf;
 int32_t          lBufSize;
 SMS_FrameBuffer* lpFrame;
 SMS_BitContext*  lpBitCtx;
 int              retVal   = 0;
 SMS_AVPacket*    lpPkt    = ( SMS_AVPacket* )SMS_RingBufferWait ( apInput );

 if ( !lpPkt ) return retVal;

 if (  !( lpPkt -> m_Flags & SMS_PKT_FLAG_SUB )  ) {

  lpBitCtx = &g_MPEGCtx.m_BitCtx;
  lpBuf    = lpPkt -> m_pData;
  lBufSize = lpPkt -> m_Size;
  g_MPEGCtx.m_pParentCtx = apCtx;

  SMS_InitGetBits ( lpBitCtx, lpBuf, lBufSize << 3 );
  g_MPEGCtx.m_BSBufSize = 0;

  if ( g_MPEGCtx.m_pCurPic == NULL || g_MPEGCtx.m_pCurPic -> m_pBuf )

   g_MPEGCtx.m_pCurPic = &g_MPEGCtx.m_pPic[ SMS_MPEGContext_FindUnusedPic () ];

  if (  _msmpeg4_decode_picture_header () < 0  ) goto end;

  apCtx -> m_HasBFrames = 0;

  g_MPEGCtx.m_Bugs             |= SMS_BUG_NO_PADDING;
  g_MPEGCtx.m_CurPic.m_Type     = g_MPEGCtx.m_PicType;
  g_MPEGCtx.m_CurPic.m_KeyFrame = g_MPEGCtx.m_PicType == SMS_FT_I_TYPE;

  if (  SMS_MPEG_FrameStart () < 0  ) goto end;

  g_MPEGCtx.m_MBX = 0; 
  g_MPEGCtx.m_MBY = 0;

  _msmpeg4_decode_slice ();

  while ( g_MPEGCtx.m_MBY < g_MPEGCtx.m_MBH ) {

   if (  g_MPEGCtx.m_MBX                           ||
         g_MPEGCtx.m_MBY % g_MPEGCtx.m_SliceHeight ||
         SMS_BitCount ( lpBitCtx ) > lpBitCtx -> m_szInBits
   ) break;

   SMS_MPEG_CleanBuffers ();

   _msmpeg4_decode_slice ();

  }  /* end while */

  if ( g_MPEGCtx.m_PicType == SMS_FT_I_TYPE ) _msmpeg4_decode_ext_header ( lBufSize );

  SMS_MPEG_FrameEnd ();

  if ( g_MPEGCtx.m_PicType == SMS_FT_B_TYPE || g_MPEGCtx.m_LowDelay )
   lpFrame = g_MPEGCtx.m_CurPic.m_pBuf;
  else lpFrame = g_MPEGCtx.m_LastPic.m_pBuf;

  apCtx -> m_FrameNr = g_MPEGCtx.m_PicNr - 1;

  if (  ( retVal = g_MPEGCtx.m_pLastPic || g_MPEGCtx.m_LowDelay )  )
   lpFrame -> m_FrameType = g_MPEGCtx.m_PicType;
  else lpFrame = g_MPEGCtx.m_CurPic.m_pBuf;

  if ( apCtx -> m_HasBFrames && lpFrame -> m_FrameType != SMS_FT_B_TYPE ) {

   lpFrame -> m_PTS  = g_MPEGCtx.m_LastPPTS + g_MPEGCtx.m_MSPerFrame;
   g_MPEGCtx.m_LastPPTS = lpPkt -> m_PTS;

  } else lpFrame -> m_PTS = lpPkt -> m_PTS;

  lpFrame -> m_SPTS = lpPkt -> m_PTS;

  if ( retVal ) {

   SMS_FrameBuffer** lppFrame = ( SMS_FrameBuffer** )SMS_RingBufferAlloc ( apOutput, 4 );

   *lppFrame = lpFrame;

   SMS_RingBufferPost ( apOutput );

  }  /* end if */

 } else {

  retVal = SMS_DXSB_Decode ( lpPkt, apOutput );

 }  /* end else */
end:
 SMS_RingBufferFree ( apInput, lpPkt -> m_Size + 64 );

 return retVal;

}  /* end MSMPEG4_Decode */
