﻿using System;
using System.Collections.Generic;
using System.Globalization;
using System.IO;
using Oni.Imaging;

namespace Oni.Akira
{
    internal class AkiraImporter : Importer
    {
        private bool debug;
        //private string defaultTexture = "NONE";
        //private bool importLights;
        //private bool noLight;
        //private bool noTextures;

        public AkiraImporter(string[] args)
        {
            foreach (string arg in args)
            {
                if (arg == "-debug")
                {
                    debug = true;
                }
                //if (arg.StartsWith("-texdefault:", StringComparison.Ordinal))
                //{
                //    int i = arg.IndexOf(':');
                //    defaultTexture = arg.Substring(i + 1);
                //}
                //else if (arg.StartsWith("-lights", StringComparison.Ordinal))
                //{
                //    importLights = true;
                //}
                //else if (arg == "-env-notxmp")
                //{
                //    noTextures = true;
                //}
                //else if (arg.StartsWith("-nolight", StringComparison.Ordinal))
                //{
                //    noLight = true;
                //}
            }
        }

        public override void Import(string filePath, string outputDirPath)
        {
            Import(new[] { filePath }, outputDirPath);
        }

        public void Import(IList<string> files, string outputDirPath)
        {
            Import(files, outputDirPath, Path.GetFileNameWithoutExtension(files[0]));
        }

        public void Import(IList<string> files, string outputDirPath, string name)
        {
            PolygonMesh mesh = AkiraDaeReader.Read(files);

            BeginImport();
            AkiraDatWriter.Write(mesh, this, name, debug);
            Write(outputDirPath);
        }
    }
}
