using System;

namespace Oni.Akira
{
    [Flags]
    internal enum GunkFlags : uint
    {
        None = 0,
        DoorFrame = 0x01,

        Ghost = 0x02,
        StairsUp = 0x04,
        StairsDown = 0x08,

        Stairs = 0x10,
        Transparent = 0x80,
        TwoSided = 0x0200,
        NoCollision = 0x0800,
        Invisible = 0x00002000,
        NoObjectCollision = 0x4000,
        NoCharacterCollision = 0x8000,
        NoOcclusion = 0x010000,
        Danger = 0x020000,
        GridIgnore = 0x400000,
        NoDecals = 0x800000,
        Furniture = 0x01000000,

        SoundTransparent = 0x08000000,
        Impassable = 0x10000000,

        Triangle = 0x00000040,
        Horizontal = 0x00080000,
        Vertical = 0x00100000,

        ProjectionBit0 = 0x02000000,
        ProjectionBit1 = 0x04000000,
    }

    internal enum PolygonProjectionPlane
    {
        None,
        XY,
        XZ,
        YZ
    }
}
