﻿using System;
using System.Collections.Generic;

namespace Oni.Akira
{
    internal static class OctreeBuilder
    {
        private static readonly BoundingBox rootBoundingBox = new BoundingBox(new Vector3(-4096.0f), new Vector3(4096.0f));

        public static OctreeNode Build(PolygonMesh mesh, bool debug)
        {
            IEnumerable<Polygon> polygons = mesh.Polygons;

            if (debug)
                polygons = polygons.Concatenate(mesh.Ghosts);

            var root = new OctreeNode(rootBoundingBox, polygons, mesh.Rooms);
            root.Build();
            return root;
        }

        public static OctreeNode Build(PolygonMesh mesh, GunkFlags excludeFlags)
        {
            var root = new OctreeNode(rootBoundingBox, mesh.Polygons.Where(p => (p.Flags & excludeFlags) == 0), mesh.Rooms);
            root.Build();
            return root;
        }

        public static OctreeNode Build(PolygonMesh mesh, Func<Polygon, bool> polygonFilter)
        {
            var root = new OctreeNode(rootBoundingBox, mesh.Polygons.Where(polygonFilter), mesh.Rooms);
            root.Build();
            return root;
        }

        public static OctreeNode BuildRoomsOctree(PolygonMesh mesh)
        {
            var root = new OctreeNode(rootBoundingBox, new Polygon[0], mesh.Rooms);
            root.Build();
            return root;
        }
    }
}
