﻿using System;

namespace Oni.Akira
{
    internal class PolygonEdge
    {
        private static readonly PolygonEdge[] emptyEdges = new PolygonEdge[0];
        private readonly Polygon polygon;
        private readonly int index;
        private PolygonEdge[] adjacency = emptyEdges;

        public PolygonEdge(Polygon polygon, int index)
        {
            this.polygon = polygon;
            this.index = index;
        }

        public Polygon Polygon => polygon;

        public int Index => index;
        public int EndIndex => (index + 1) % polygon.Edges.Length;

        public int Point0Index => polygon.PointIndices[index];
        public int Point1Index => polygon.PointIndices[EndIndex];

        public PolygonEdge[] Adjancency
        {
            get { return adjacency; }
            set { adjacency = value; }
        }
    }
}
