﻿using System;
using System.IO;
using Oni.Metadata;

namespace Oni
{
    internal class BinImporter : Importer
    {
        public override void Import(string filePath, string outputDirPath)
        {
            using (var reader = new BinaryReader(filePath))
            {
                int tag = reader.ReadInt32();

                if (!Enum.IsDefined(typeof(BinaryTag), tag))
                    throw new NotSupportedException(string.Format(".bin file with tag '{0:x}' is unuspported", tag));

                var tagName = ((BinaryTag)tag).ToString();

                BeginImport();

                var bina = CreateInstance(TemplateTag.BINA, tagName + Path.GetFileNameWithoutExtension(filePath));

                using (var writer = bina.OpenWrite())
                {
                    writer.Write(reader.Length);
                    writer.Write(32);
                }

                RawWriter.Write(tag);
                RawWriter.Write(reader.ReadBytes(reader.Length - 4));

                Write(outputDirPath);
            }
        }
    }
}
