﻿using System;
using System.Collections.Generic;

namespace Oni.Collections
{
    internal class Set<T> : IEnumerable<T>
    {
        private readonly Dictionary<T, int> set;

        public Set()
        {
            set = new Dictionary<T, int>();
        }

        public Set(IEqualityComparer<T> comparer)
        {
            set = new Dictionary<T, int>(comparer);
        }

        public bool Add(T t)
        {
            if (set.ContainsKey(t))
                return false;

            set.Add(t, 0);
            return true;
        }

        public bool Contains(T t) => set.ContainsKey(t);

        public int Count => set.Count;

        public void UnionWith(IEnumerable<T> with)
        {
            foreach (T t in with)
                set[t] = 0;
        }

        public IEnumerator<T> GetEnumerator()
        {
            foreach (var pair in set)
                yield return pair.Key;
        }

        System.Collections.IEnumerator System.Collections.IEnumerable.GetEnumerator() => GetEnumerator();
    }
}
