﻿using System;

namespace Oni.Dae
{
	internal class EffectParameter
	{
		private object value;
		private string reference;

		public EffectParameter()
		{
		}

		public EffectParameter(string sid, object value)
		{
			Sid = sid;
			this.value = value;
			SetValueOwner(this);
		}

		public EffectParameter(string sid, object value, Effect parent)
		{
			Sid = sid;
			this.value = value;
		}

		public string Sid { get; set; }
		public string Semantic { get; set; }

		public object Value
		{
			get
			{
				return value;
			}
			set
			{
				SetValueOwner(null);

				this.value = value;

				if (value != null)
					reference = null;

				SetValueOwner(this);
			}
		}

		private void SetValueOwner(EffectParameter owner)
		{
			EffectSampler sampler = value as EffectSampler;

			if (sampler != null)
			{
				sampler.Owner = owner;
				return;
			}

			EffectSurface surface = value as EffectSurface;

			if (surface != null)
			{
				surface.DeclaringParameter = owner;
				return;
			}
		}

		public string Reference
		{
			get
			{
				return reference;
			}
			set
			{
				reference = value;

				if (reference != null)
					this.value = null;
			}
		}
	}
}
