﻿using System;
using System.Collections.Generic;

namespace Oni.Dae
{
    internal class MeshPrimitives
    {
        private readonly MeshPrimitiveType primitiveType;
        private readonly List<IndexedInput> inputs;
        private readonly List<int> vertexCounts;

        public MeshPrimitives(MeshPrimitiveType primitiveType)
        {
            this.primitiveType = primitiveType;
            this.inputs = new List<IndexedInput>(3);
            this.vertexCounts = new List<int>();
        }

        public MeshPrimitives(MeshPrimitiveType primitiveType, IEnumerable<IndexedInput> inputs)
        {
            this.primitiveType = primitiveType;
            this.inputs = new List<IndexedInput>(inputs);
            this.vertexCounts = new List<int>();
        }

        public MeshPrimitiveType PrimitiveType => primitiveType;

        public string MaterialSymbol { get; set; }

        public List<IndexedInput> Inputs => inputs;

        public List<int> VertexCounts => vertexCounts;
    }
}
