﻿using System;
using System.IO;

namespace Oni.Dae
{
    internal class Reader
    {
        public static Scene ReadFile(string filePath)
        {
            string type = Path.GetExtension(filePath);

            if (string.Equals(type, ".dae", StringComparison.OrdinalIgnoreCase))
                return IO.DaeReader.ReadFile(filePath);
            else if (string.Equals(type, ".obj", StringComparison.OrdinalIgnoreCase))
                return IO.ObjReader.ReadFile(filePath);
            else
                throw new NotSupportedException($"Unsupported 3D file type {type}");
        }
    }
}
