﻿using System.Collections.Generic;

namespace Oni.Dae
{
    internal class TransformCollection : List<Transform>
    {
        public Matrix ToMatrix()
        {
            var matrix = Matrix.Identity;

            foreach (var transform in Utils.Reverse(this))
                matrix *= transform.ToMatrix();

            return matrix;
        }

        public TransformScale Scale(string sid, Vector3 scale)
        {
            var transform = new TransformScale(sid, scale);
            Add(transform);
            return transform;
        }

        public TransformRotate Rotate(string sid, Vector3 axis, float angle)
        {
            var transform = new TransformRotate(sid, axis, angle);
            Add(transform);
            return transform;
        }

        public TransformTranslate Translate(string sid, Vector3 translate)
        {
            var transform = new TransformTranslate(sid, translate);
            Add(transform);
            return transform;
        }
    }
}
