﻿using System;

namespace Oni.Dae
{
    internal class TransformRotate : Transform
    {
        private static readonly string[] valueNames = new[] { "X", "Y", "Z", "ANGLE" };

        public TransformRotate()
            : base(4)
        {
        }

        public TransformRotate(Vector3 axis, float angle)
            : base(4)
        {
            Axis = axis;
            Angle = angle;
        }

        public TransformRotate(string sid, Vector3 axis, float angle)
            : base(sid, 4)
        {
            Axis = axis;
            Angle = angle;
        }

        public Vector3 Axis
        {
            get { return new Vector3(Values); }
            set { value.CopyTo(Values); }
        }

        public float Angle
        {
            get { return Values[3]; }
            set { Values[3] = value; }
        }

        public Sampler AngleAnimation => GetAnimation(3);

        public override Matrix ToMatrix() => Matrix.CreateFromAxisAngle(Axis, MathHelper.ToRadians(Angle));
        public Quaternion ToQuaternion() => Quaternion.CreateFromAxisAngle(Axis, MathHelper.ToRadians(Angle));

        public override int ValueNameToValueIndex(string name) => Array.FindIndex(valueNames, x => string.Equals(x, name, StringComparison.OrdinalIgnoreCase));
        public override string ValueIndexToValueName(int index) => valueNames[index];
    }
}
