﻿using System;

namespace Oni.Dae
{
    internal class TransformScale : Transform
    {
        private static readonly string[] valueNames = new[] { "X", "Y", "Z" };

        public TransformScale()
            : base(3)
        {
        }

        public TransformScale(string sid, Vector3 scale)
            : base(sid, 3)
        {
            Scale = scale;
        }

        public Vector3 Scale
        {
            get { return new Vector3(Values); }
            set { value.CopyTo(Values); }
        }

        public override Matrix ToMatrix() => Matrix.CreateScale(Scale);

        public override int ValueNameToValueIndex(string name) => Array.FindIndex(valueNames, x => string.Equals(x, name, StringComparison.OrdinalIgnoreCase));
        public override string ValueIndexToValueName(int index) => valueNames[index];
    }
}
