﻿using System;

namespace Oni.Dae
{
    internal class TransformTranslate : Transform
    {
        private static readonly string[] valueNames = new[] { "X", "Y", "Z" };

        public TransformTranslate()
            : base(3)
        {
        }

        public TransformTranslate(Vector3 translation)
            : base(3)
        {
            Translation = translation;
        }

        public TransformTranslate(string sid, Vector3 translation)
            : base(sid, 3)
        {
            Translation = translation;
        }

        public Vector3 Translation
        {
            get { return new Vector3(Values); }
            set { value.CopyTo(Values); }
        }

        public override Matrix ToMatrix() => Matrix.CreateTranslation(Translation);

        public override int ValueNameToValueIndex(string name) => Array.FindIndex(valueNames, x => string.Equals(x, name, StringComparison.OrdinalIgnoreCase));
        public override string ValueIndexToValueName(int index) => valueNames[index];
    }
}
