﻿using System;
using System.IO;

namespace Oni.Dae
{
    internal class Writer
    {
        public static void WriteFile(string filePath, Scene scene)
        {
            string type = Path.GetExtension(filePath);

            if (string.Equals(type, ".dae", StringComparison.OrdinalIgnoreCase))
                IO.DaeWriter.WriteFile(filePath, scene);
            else if (string.Equals(type, ".obj", StringComparison.OrdinalIgnoreCase))
                IO.ObjWriter.WriteFile(filePath, scene);
            else
                throw new NotSupportedException(string.Format("Unsupported 3D file type {0}", type));
        }
    }
}
