﻿using System;

namespace Oni.Game
{
    internal class WeaponClass
    {
        private InstanceDescriptor geometry;

        public static WeaponClass Read(InstanceDescriptor descriptor)
        {
            if (descriptor.Template.Tag != TemplateTag.ONWC)
                throw new ArgumentException(string.Format("The specified descriptor has a wrong template {0}", descriptor.Template.Tag), "descriptor");

            var weapon = new WeaponClass();

            using (var reader = descriptor.OpenRead(0x58))
                weapon.geometry = reader.ReadInstance();

            return weapon;
        }

        public InstanceDescriptor Geometry => geometry;
    }
}
