﻿using System;
using System.Collections.Generic;

namespace Oni.Imaging
{
	internal static class DdsReader
	{
		public static List<Surface> Read(string filePath, bool noMipMaps)
		{
            var surfaces = new List<Surface>();

            using (var reader = new BinaryReader(filePath))
			{
                var header = DdsHeader.Read(reader);
				var format = header.GetSurfaceFormat();

				for (int i = 0; i < header.MipmapCount; i++)
				{
					int width = Math.Max(header.Width >> i, 1);
					int height = Math.Max(header.Height >> i, 1);

					if (format == SurfaceFormat.DXT1)
					{
						width = Math.Max(width, 4);
						height = Math.Max(height, 4);
					}

                    var surface = new Surface(width, height, format);
					reader.Read(surface.Data, 0, surface.Data.Length);
					surfaces.Add(surface);

                    if (noMipMaps)
                        break;
				}
			}

			return surfaces;
		}
	}
}
