﻿using System;
using System.Collections.Generic;
using System.IO;

namespace Oni.Imaging
{
    internal class DdsWriter
    {
        public static void Write(IList<Surface> surfaces, string filePath)
        {
            using (var stream = File.Create(filePath))
            using (var writer = new BinaryWriter(stream))
            {
                var header = DdsHeader.Create(surfaces);

                header.Write(writer);

                foreach (var surface in surfaces)
                    writer.Write(surface.Data);
            }
        }
    }
}
