﻿namespace Oni
{
    internal abstract class ImporterDescriptor
    {
        private readonly ImporterFile file;
        private readonly TemplateTag tag;
        private readonly int index;
        private readonly string name;

        protected ImporterDescriptor(ImporterFile file, TemplateTag tag, int index, string name)
        {
            this.file = file;
            this.tag = tag;
            this.index = index;
            this.name = name;
        }

        public ImporterFile File => file;
        public TemplateTag Tag => tag;
        public int Index => index;
        public string Name => name;

        public abstract BinaryWriter OpenWrite();
        public abstract BinaryWriter OpenWrite(int offset);
    }
}
