﻿using System;
using System.Collections.Generic;

namespace Oni
{
    internal static class ImporterDescriptorExtensions
    {
        public static void WriteIndices(this ImporterDescriptor descriptor, int[] indices)
        {
            using (var writer = descriptor.OpenWrite(20))
            {
                writer.Write(indices.Length);
                writer.Write(indices);
            }
        }

        public static void WritePoints(this ImporterDescriptor descriptor, ICollection<Vector3> points)
        {
            var bbox = BoundingBox.CreateFromPoints(points);
            var bsphere = BoundingSphere.CreateFromPoints(points);

            using (var writer = descriptor.OpenWrite(12))
            {
                writer.Write(bbox);
                writer.Write(bsphere);
                writer.Write(points.Count);
                writer.Write(points);
            }
        }

        public static void WriteTexCoords(this ImporterDescriptor descriptor, ICollection<Vector2> texCoords)
        {
            using (var writer = descriptor.OpenWrite(20))
            {
                writer.Write(texCoords.Count);
                writer.Write(texCoords);
            }
        }

        public static void WriteVectors(this ImporterDescriptor descriptor, ICollection<Vector3> vectors)
        {
            using (var writer = descriptor.OpenWrite(20))
            {
                writer.Write(vectors.Count);
                writer.Write(vectors);
            }
        }

        public static void WritePlanes(this ImporterDescriptor descriptor, ICollection<Plane> planes)
        {
            using (var writer = descriptor.OpenWrite(20))
            {
                writer.Write(planes.Count);
                writer.Write(planes);
            }
        }
    }
}
