﻿using System;
using System.Collections.Generic;
using System.Xml;

namespace Oni.Level
{
    using Oni.Physics;

    partial class LevelImporter
    {
        private static IEnumerable<ObjectParticle> ReadParticles(XmlReader xml, string basePath)
        {
            if (xml.SkipEmpty())
                yield break;

            xml.ReadStartElement();

            while (xml.IsStartElement())
                yield return ObjectXmlReader.ReadParticle(xml);

            xml.ReadEndElement();
        }

        private void ImportParticle(string tag, Matrix matrix, ObjectParticle particle)
        {
            level.particles.Add(new ObjectParticle {
                ParticleClass = particle.ParticleClass,
                Tag = tag + "_" + particle.Tag,
                Matrix = particle.Matrix * matrix,
                DecalScale = particle.DecalScale,
                Flags = particle.Flags
            });
        }
    }
}
