﻿using System;
using System.Xml;
using Oni.Metadata;

namespace Oni.Level
{
    internal class ScriptCharacter
    {
        public string className;
        public string name;
        public string weaponClassName;
        public int flagId;
        public int scriptId;
        public InstanceMetadata.AISACharacterFlags flags;
        public InstanceMetadata.AISACharacterTeam team;
        public string onSpawn;
        public string onDeath;
        public string onSeenEnemy;
        public string onAlarmed;
        public string onHurt;
        public string onDefeated;
        public string onOutOfAmmo;
        public string onNoPath;
        public int ammo;

        public static ScriptCharacter Read(XmlReader xml)
        {
            xml.ReadStartElement("Character");

            var chr = new ScriptCharacter {
                name = xml.ReadElementContentAsString("Name", ""),
                scriptId = xml.ReadElementContentAsInt("ScriptId", ""),
                flagId = xml.ReadElementContentAsInt("FlagId", ""),
                flags = xml.ReadElementContentAsEnum<InstanceMetadata.AISACharacterFlags>("Flags"),
                team = xml.ReadElementContentAsEnum<InstanceMetadata.AISACharacterTeam>("Team"),
                className = xml.ReadElementContentAsString("Class", "")
            };

            xml.ReadStartElement("Scripts");
            chr.onSpawn = xml.ReadElementContentAsString("Spawn", "");
            chr.onDeath = xml.ReadElementContentAsString("Die", "");
            chr.onSeenEnemy = xml.ReadElementContentAsString("Combat", "");
            chr.onAlarmed = xml.ReadElementContentAsString("Alarm", "");
            chr.onHurt = xml.ReadElementContentAsString("Hurt", "");
            chr.onDefeated = xml.ReadElementContentAsString("Defeated", "");
            chr.onOutOfAmmo = xml.ReadElementContentAsString("OutOfAmmo", "");
            chr.onNoPath = xml.ReadElementContentAsString("NoPath", "");
            xml.ReadEndElement();

            chr.weaponClassName = xml.ReadElementContentAsString("Weapon", "");
            chr.ammo = xml.ReadElementContentAsInt("Ammo", "");

            xml.ReadEndElement();

            return chr;
        }
    }
}
