﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Xml;

namespace Oni.Level
{
    using Oni.Akira;
    using Oni.Metadata;
    using Oni.Motoko;
    using Oni.Xml;

    partial class LevelImporter
    {
        private Motoko.TextureImporter3 textureImporter;
        private TextureFormat defaultTextureFormat = TextureFormat.BGR;
        private TextureFormat defaultAlphaTextureFormat = TextureFormat.RGBA;
        private int maxTextureSize = 512;

        private void ReadTextures(XmlReader xml, string basePath)
        {
            if (xml.SkipEmpty())
                return;

            string format = xml.GetAttribute("Format");
            string alphaFormat = xml.GetAttribute("AlphaFormat");
            string size = xml.GetAttribute("MaxSize");

            if (format != null)
                defaultTextureFormat = TextureImporter.ParseTextureFormat(format);

            if (alphaFormat != null)
                defaultAlphaTextureFormat = TextureImporter.ParseTextureFormat(alphaFormat);

            if (size != null)
                maxTextureSize = int.Parse(size);

            xml.ReadStartElement("Textures");

            while (xml.IsStartElement())
            {
                if (xml.LocalName == "Import")
                {
                    var importPath = Path.Combine(basePath, xml.ReadElementContentAsString());

                    var settings = new XmlReaderSettings {
                        IgnoreWhitespace = true,
                        IgnoreProcessingInstructions = true,
                        IgnoreComments = true
                    };

                    using (var importXml = XmlReader.Create(importPath, settings))
                    {
                        importXml.ReadStartElement("Oni");
                        ReadTextures(importXml, Path.GetDirectoryName(importPath));
                        importXml.ReadEndElement();
                    }
                }
                else
                {
                    textureImporter.ReadOptions(xml, basePath);
                }
            }

            xml.ReadEndElement();
        }
    }
}
