﻿using System;

namespace Oni
{
    internal static class FMath
    {
        public static float Sign(float x)
        {
            if (x > 0.0f)
                return 1.0f;
            else if (x < 0.0f)
                return -1.0f;
            else
                return 0.0f;
        }

        public static float Sqrt(float x) => (float)Math.Sqrt(x);
        public static float Sqr(float x) => x * x;
        public static float Atan2(float y, float x) => (float)Math.Atan2(y, x);
        public static float Cos(float x) => (float)Math.Cos(x);
        public static float Sin(float x) => (float)Math.Sin(x);
        public static float Acos(float x) => (float)Math.Acos(x);
        public static float Round(float x, int digits) => (float)Math.Round(x, digits);
        public static int RoundToInt32(float f) => (int)Math.Round(f);
        public static int TruncateToInt32(float f) => (int)Math.Truncate(f);
    }
}
