﻿using System;

namespace Oni
{
    internal static class MathHelper
    {
        public const float Eps = 1e-5f;
        public const float Pi = 3.141593f;
        public const float HalfPi = Pi / 2.0f;
        public const float PiOver4 = Pi / 4.0f;
        public const float TwoPi = 2.0f * Pi;

        public static float ToDegrees(float radians) => radians * (180.0f / Pi);
        public static float ToRadians(float degrees) => degrees * (Pi / 180.0f);
        public static float Distance(float v1, float v2) => Math.Abs(v2 - v1);
        public static float Lerp(float v1, float v2, float amount) => v1 + (v2 - v1) * amount;

        public static int Lerp(int v1, int v2, float amount)
        {
            if (amount == 0.0f)
                return v1;

            if (amount == 1.0f)
                return v2;

            return (int)(v1 + (v2 - v1) * amount);
        }

        public static float Clamp(float v, float min, float max)
        {
            v = (v > max) ? max : v;
            v = (v < min) ? min : v;

            return v;
        }

        public static int Clamp(int v, int min, int max)
        {
            v = (v > max) ? max : v;
            v = (v < min) ? min : v;

            return v;
        }

        public static float Area(Vector2[] points)
        {
            float area = 0.0f;

            for (int i = 0; i < points.Length; i++)
            {
                int j = (i + 1) % points.Length;
                area += points[i].X * points[j].Y;
                area -= points[i].Y * points[j].X;
            }

            return Math.Abs(area * 0.5f);
        }
    }
}
