﻿using System;
using System.Globalization;

namespace Oni.Metadata
{
    internal class MetaArray : MetaType
    {
        private readonly MetaType elementType;
        private readonly int count;

        public MetaArray(MetaType elementType, int count)
        {
            this.elementType = elementType;
            this.count = count;

            Name = string.Format(CultureInfo.InvariantCulture, "{0}[{1}]", elementType.Name, count);
            Size = elementType.Size * count;
        }

        public MetaType ElementType => elementType;

        public int Count => count;

        protected override bool IsLeafImpl() => elementType.IsLeaf;

        public override void Accept(IMetaTypeVisitor visitor) => visitor.VisitArray(this);
    }
}
