﻿namespace Oni.Metadata
{
    internal class MetaPadding : MetaArray
    {
        private readonly byte fillByte;

        public MetaPadding(int length) : this(length, 0)
        {
        }

        public MetaPadding(int length, byte fillByte) : base(MetaType.Byte, length)
        {
            this.fillByte = fillByte;
        }

        public byte FillByte => fillByte;

        public override void Accept(IMetaTypeVisitor visitor) => visitor.VisitPadding(this);
    }
}
