﻿using System;
using System.Collections.Generic;

namespace Oni.Metadata
{
    internal class MetaStruct : MetaType
    {
        private readonly List<Field> fields = new List<Field>();
        private readonly MetaStruct baseStruct;

        public MetaStruct(params Field[] declaredFields)
            : this(null, null, declaredFields)
        {
        }

        public MetaStruct(MetaStruct baseStruct, params Field[] declaredFields)
            : this(null, null, declaredFields)
        {
        }

        public MetaStruct(string name, params Field[] declaredFields)
            : this(name, null, declaredFields)
        {
        }

        public MetaStruct(string name, MetaStruct baseStruct, params Field[] declaredFields)
        {
            this.baseStruct = baseStruct;

            if (baseStruct != null)
                fields.AddRange(baseStruct.fields);

            fields.AddRange(declaredFields);

            int size = 0;

            foreach (var field in fields)
                size += field.Type.Size;

            Name = name;
            Size = size;
        }

        public IEnumerable<Field> Fields => fields;

        protected override bool IsLeafImpl()
        {
            foreach (var field in fields)
            {
                if (!field.Type.IsLeaf)
                    return false;
            }

            return true;
        }

        public override void Accept(IMetaTypeVisitor visitor)
        {
            visitor.VisitStruct(this);
        }
    }
}
