﻿using System;

namespace Oni.Metadata
{
    internal class MetaVarArray : MetaType
    {
        private readonly MetaType elementType;
        private readonly Field lengthField;

        public MetaVarArray(MetaType lengthType, MetaType elementType)
        {
            if (lengthType != MetaType.Int16 && lengthType != MetaType.Int32)
                throw new ArgumentException("lengthType must be Int16 or Int32", "lengthType");

            this.lengthField = new Field(lengthType, "Length");
            this.elementType = elementType;

            Name = string.Format("{0}[{1}]", elementType.Name, lengthType.Name);
            Size = lengthType.Size;
        }

        public Field CountField => lengthField;

        public MetaType ElementType => elementType;

        protected override bool IsLeafImpl() => elementType.IsLeaf;

        public override void Accept(IMetaTypeVisitor visitor) => visitor.VisitVarArray(this);
    }
}
