﻿using System;
using System.Collections.Generic;

namespace Oni.Metadata
{
    internal class OniPcMetadata : InstanceMetadata
    {
        //
        // Binary Data template
        //

        private static MetaStruct bina = new MetaStruct("BINAInstance",
            new Field(MetaType.Int32, "DataSize"),
            new BinaryPartField(MetaType.RawOffset, "DataOffset", "DataSize")
        );

        //
        // Oni Sound Binary Data template
        //

        private static MetaStruct osbd = new MetaStruct("OSBDInstance",
            new Field(MetaType.Int32, "DataSize"),
            new BinaryPartField(MetaType.RawOffset, "DataOffset", "DataSize")
        );

        //
        // Texture Map template
        //

        private static MetaStruct txmp = new MetaStruct("TXMPInstance",
            new Field(MetaType.Padding(128)),
            new Field(MetaType.Enum<TXMPFlags>(), "Flags"),
            new Field(MetaType.UInt16, "Width"),
            new Field(MetaType.UInt16, "Height"),
            new Field(MetaType.Enum<TXMPFormat>(), "Format"),
            new Field(MetaType.Pointer(TemplateTag.TXAN), "Animation"),
            new Field(MetaType.Pointer(TemplateTag.TXMP), "EnvMap"),
            new BinaryPartField(MetaType.RawOffset, "DataOffset"),
            new Field(MetaType.Padding(12))
        );

        //
        // Sound Data template
        //

        private static MetaStruct sndd = new MetaStruct("SNDDInstance",
            new Field(MetaType.Int32, "WaveHeaderSize"),

            new Field(MetaType.Int16, "Format"),
            new Field(MetaType.Int16, "ChannelCount"),
            new Field(MetaType.Int32, "SamplesPerSecond"),
            new Field(MetaType.Int32, "BytesPerSecond"),
            new Field(MetaType.Int16, "BlockAlignment"),
            new Field(MetaType.Int16, "BitsPerSample"),
            new Field(MetaType.Int16, "AdpcmHeaderSize"),

            new Field(MetaType.Int16, "SamplesPerBlock"),
            new Field(MetaType.Int16, "CoefficientCount"),
            new Field(MetaType.Array(7, new MetaStruct("ADPCMCoefficient",
                new Field(MetaType.Int16, "Coefficient1"),
                new Field(MetaType.Int16, "Coefficient2")
            )), "Coefficients"),

            new Field(MetaType.Int16, "Duration"),
            new Field(MetaType.Int32, "DataSize"),
            new BinaryPartField(MetaType.RawOffset, "DataOffset", "DataSize")
        );

        protected override void InitializeTemplates(IList<Template> templates)
        {
            base.InitializeTemplates(templates);

            templates.Add(new Template(TemplateTag.BINA, bina, 0xdb41, "Binary Data"));
            templates.Add(new Template(TemplateTag.OSBD, osbd, 0xdb6c, "Oni Sound Binary Data"));
            templates.Add(new Template(TemplateTag.TXMP, txmp, 0x891187581, "Texture Map"));
            templates.Add(new Template(TemplateTag.SNDD, sndd, 0x370578, "Sound Data"));
        }
    }
}
