﻿using System;
using System.Collections.Generic;
using Oni.Imaging;

namespace Oni.Motoko
{
    internal class TextureDatWriter
    {
        private readonly Importer importer;

        public static void Write(Texture texture, string outputDirPath)
        {
            var writer = new DatWriter();
            Write(texture, writer);
            writer.Write(outputDirPath);
        }

        public static void Write(Texture texture, Importer importer)
        {
            var writer = new TextureDatWriter(importer);
            writer.Write(texture);
        }

        private TextureDatWriter(Importer importer)
        {
            this.importer = importer;
        }

        private void Write(Texture texture)
        {
            var txmp = importer.CreateInstance(TemplateTag.TXMP, texture.Name);
            int rawOffset = importer.RawWriter.Align32();
            var flags = texture.Flags;
            ImporterDescriptor envMapTxmp = null;

            if (texture.EnvMap != null)
            {
                envMapTxmp = importer.CreateInstance(TemplateTag.TXMP, texture.EnvMap.Name);
                flags |= TextureFlags.HasEnvMap;
            }

            if (texture.Surfaces.Count > 1)
            {
                flags |= TextureFlags.HasMipMaps;
            }

            using (var writer = txmp.OpenWrite(128))
            {
                writer.Write((int)flags);
                writer.WriteInt16(texture.Width);
                writer.WriteInt16(texture.Height);
                writer.Write((int)texture.Format);
                writer.Write(0);
                writer.Write(envMapTxmp);
                writer.Write(rawOffset);
                writer.Skip(12);
            }

            foreach (var surface in texture.Surfaces)
                importer.RawWriter.Write(surface.Data);
        }
    }
}
