﻿using System.Xml;
using Oni.Akira;
using Oni.Metadata;
using Oni.Motoko;
using Oni.Physics;
using Oni.Xml;

namespace Oni.Objects
{
    internal class ConsoleClass : GunkObjectClass
    {
        public ConsoleClassFlags Flags;
        public Vector3 ActionPoint;
        public Vector3 ActionOrientation;
        public ObjectNode Geometry;
        public Geometry ScreenGeometry;
        public GunkFlags ScreenGunkFlags;
        public string InactiveTexture;
        public string ActiveTexture;
        public string TriggeredTexture;

        public static ConsoleClass Read(InstanceDescriptor cons)
        {
            var klass = new ConsoleClass();

            InstanceDescriptor geometryDescriptor;
            InstanceDescriptor screenGeometryDescriptor;

            using (var reader = cons.OpenRead())
            {
                klass.Flags = (ConsoleClassFlags)reader.ReadUInt32();
                klass.ActionPoint = reader.ReadVector3();
                klass.ActionOrientation = reader.ReadVector3();
                geometryDescriptor = reader.ReadInstance();
                screenGeometryDescriptor = reader.ReadInstance();
                klass.ScreenGunkFlags = (GunkFlags)reader.ReadUInt32();
                klass.InactiveTexture = reader.ReadString(32);
                klass.ActiveTexture = reader.ReadString(32);
                klass.TriggeredTexture = reader.ReadString(32);
            }

            if (geometryDescriptor != null)
                klass.Geometry = ObjectDatReader.ReadObjectGeometry(geometryDescriptor);

            if (screenGeometryDescriptor != null)
                klass.ScreenGeometry = GeometryDatReader.Read(screenGeometryDescriptor);

            return klass;
        }

        public static ConsoleClass Read(XmlReader xml)
        {
            var klass = new ConsoleClass();

            while (xml.IsStartElement())
            {
                switch (xml.LocalName)
                {
                    case "Flags":
                        klass.Flags = xml.ReadElementContentAsEnum<ConsoleClassFlags>();
                        break;
                    case "ActionPoint":
                        klass.ActionPoint = xml.ReadElementContentAsVector3();
                        break;
                    case "ActionOrientation":
                        klass.ActionOrientation = xml.ReadElementContentAsVector3();
                        break;
                    case "ConsoleGeometry":
                        break;
                    case "InactiveTexture":
                        klass.InactiveTexture = xml.ReadElementContentAsString();
                        break;
                    case "ActiveTexture":
                        klass.ActiveTexture = xml.ReadElementContentAsString();
                        break;
                    case "TriggeredTexture":
                        klass.TriggeredTexture = xml.ReadElementContentAsString();
                        break;
                }
            }

            return klass;
        }

        public override ObjectGeometry[] GunkNodes => Geometry.Geometries;
    }
}
