﻿using Oni.Physics;

namespace Oni.Objects
{
    internal class DoorClass : GunkObjectClass
    {
        public ObjectNode Geometry;
        public string AnimationName;
        public ObjectAnimation Animation;
        public float SoundAttenuation;
        public int AllowedSounds;
        public int SoundType;
        public float SoundVolume;
        public string OpenSound;
        public string CloseSound;

        public static DoorClass Read(InstanceDescriptor door)
        {
            var klass = new DoorClass();

            InstanceDescriptor geometryDescriptor;
            InstanceDescriptor animationDescriptor;

            using (var reader = door.OpenRead())
            {
                geometryDescriptor = reader.ReadInstance();
                reader.Skip(4);
                animationDescriptor = reader.ReadInstance();
                klass.SoundAttenuation = reader.ReadSingle();
                klass.AllowedSounds = reader.ReadInt32();
                klass.SoundType = reader.ReadInt32();
                klass.SoundVolume = reader.ReadSingle();
                klass.OpenSound = reader.ReadString(32);
                klass.CloseSound = reader.ReadString(32);
            }

            if (geometryDescriptor != null)
            {
                klass.Geometry = ObjectDatReader.ReadObjectGeometry(geometryDescriptor);
            }

            if (animationDescriptor != null)
            {
                klass.AnimationName = animationDescriptor.Name;
                klass.Animation = ObjectDatReader.ReadAnimation(animationDescriptor);
            }

            return klass;
        }

        public override ObjectGeometry[] GunkNodes => Geometry.Geometries;
    }
}
