﻿using System;
using System.Xml;
using Oni.Imaging;
using Oni.Xml;

namespace Oni.Objects
{
    internal class Flag : ObjectBase
    {
        public Color Color;
        public string Prefix;
        public int ScriptId;
        public string Notes;

        public Flag()
        {
            TypeId = ObjectType.Flag;
        }

        protected override void WriteOsd(BinaryWriter writer)
        {
            writer.Write(Color);
            writer.Write(Prefix, 2);
            writer.WriteInt16(ScriptId);
            writer.Write(Notes, 128);
        }

        protected override void ReadOsd(BinaryReader reader)
        {
            Color = reader.ReadColor();
            Prefix = reader.ReadString(2);
            ScriptId = reader.ReadInt16();
            Notes = reader.ReadString(128);
            Prefix = new string(new char[] { Prefix[1], Prefix[0] });
        }

        protected override void WriteOsd(XmlWriter xml)
        {
            throw new NotImplementedException();
        }

        protected override void ReadOsd(XmlReader xml, ObjectLoadContext context)
        {
            while (xml.IsStartElement())
            {
                switch (xml.LocalName)
                {
                    case "Color":
                        byte[] values = xml.ReadElementContentAsArray<byte>(XmlConvert.ToByte);

                        if (values.Length > 3)
                            Color = new Color(values[0], values[1], values[2], values[3]);
                        else
                            Color = new Color(values[0], values[1], values[2]);

                        break;
                    case "Prefix":
                        string prefix = xml.ReadElementContentAsString();

                        if (prefix.Length > 2)
                        {
                            int prefixId = int.Parse(prefix);
                            prefix = new string(new char[2] { (char)((prefixId >> 8) & 0xff), (char)(prefixId & 0xff) });
                        }

                        Prefix = prefix;
                        break;
                    case "FlagId":
                        ScriptId = xml.ReadElementContentAsInt();
                        break;
                    case "Note":
                        Notes = xml.ReadElementContentAsString();
                        break;
                    default:
                        xml.Skip();
                        break;
                }
            }
        }
    }
}
