﻿using System.Xml;

namespace Oni.Objects
{
    internal class Furniture : GunkObject
    {
        public FurnitureClass Class;
        public string ParticleTag;

        public Furniture()
        {
            TypeId = ObjectType.Furniture;
        }

        protected override void WriteOsd(BinaryWriter writer)
        {
            writer.Write(ClassName, 32);
            writer.Write(ParticleTag, 48);
        }

        protected override void ReadOsd(BinaryReader reader)
        {
            ClassName = reader.ReadString(32);
            ParticleTag = reader.ReadString(48);
        }

        protected override void WriteOsd(XmlWriter xml)
        {
            xml.WriteElementString("Class", ClassName);
            xml.WriteElementString("Particle", ParticleTag);
        }

        protected override void ReadOsd(XmlReader xml, ObjectLoadContext context)
        {
            string className = null;

            while (xml.IsStartElement())
            {
                switch (xml.LocalName)
                {
                    case "Class":
                        className = xml.ReadElementContentAsString();
                        break;
                    case "Particle":
                        ParticleTag = xml.ReadElementContentAsString();
                        break;
                    default:
                        xml.Skip();
                        break;
                }
            }


            Class = context.GetClass(TemplateTag.OFGA, className, FurnitureClass.Read);
            GunkClass = Class;
        }
    }
}
