﻿using System;
using System.Collections.Generic;
using Oni.Akira;
using Oni.Imaging;
using Oni.Motoko;
using Oni.Physics;

namespace Oni.Objects
{
    internal class TriggerClass : GunkObjectClass
    {
        public Color Color;
        public int TimeOn;
        public int TimeOff;
        public float StartOffset;
        public float AnimScale;
        public Geometry RailGeometry;
        public GunkFlags RailGunkFlags;
        public string ActiveSoundName;
        public string HitSoundName;

        public static TriggerClass Read(InstanceDescriptor trig)
        {
            var klass = new TriggerClass();

            InstanceDescriptor railGeometryDescriptor;

            using (var reader = trig.OpenRead())
            {
                klass.Color = reader.ReadColor();
                klass.TimeOn = reader.ReadUInt16();
                klass.TimeOff = reader.ReadUInt16();
                klass.StartOffset = reader.ReadSingle();
                klass.AnimScale = reader.ReadSingle();
                railGeometryDescriptor = reader.ReadInstance();
                reader.Skip(4);
                klass.RailGunkFlags = (GunkFlags)reader.ReadInt32();

                // we do not need the emitter and animation for now
                reader.Skip(8);
                //trge = reader.ReadInstanceLink<TRGEInstance>();
                //oban = reader.ReadInstanceLink<OBANInstance>();

                klass.ActiveSoundName = reader.ReadString(32) + ".amb";
                klass.HitSoundName = reader.ReadString(32) + ".imp";
                reader.Skip(8);
            }

            if (railGeometryDescriptor != null)
                klass.RailGeometry = GeometryDatReader.Read(railGeometryDescriptor);

            return klass;
        }

        public override ObjectGeometry[] GunkNodes
        {
            get
            {
                return new[] {
                    new ObjectGeometry {
                        Geometry = RailGeometry,
                        Flags = RailGunkFlags
                    }
                };
            }
        }
    }
}
